from collections.abc import Iterable, Sequence
from typing import Final, Literal

import numpy.typing as npt
import optype.numpy as onp

from ._flapack import (
    cgbcon as cgbcon,
    cgbsv as cgbsv,
    cgbtrf as cgbtrf,
    cgbtrs as cgbtrs,
    cgebal as cgebal,
    cgecon as cgecon,
    cgeequ as cgeequ,
    cgeequb as cgeequb,
    cgees as cgees,
    cgeev as cgeev,
    cgeev_lwork as cgeev_lwork,
    cgehrd as cgehrd,
    cgehrd_lwork as cgehrd_lwork,
    cgels as cgels,
    cgels_lwork as cgels_lwork,
    cgelsd as cgelsd,
    cgelsd_lwork as cgelsd_lwork,
    cgelss as cgelss,
    cgelss_lwork as cgelss_lwork,
    cgelsy as cgelsy,
    cgelsy_lwork as cgelsy_lwork,
    cgemqrt as cgemqrt,
    cgeqp3 as cgeqp3,
    cgeqrf as cgeqrf,
    cgeqrf_lwork as cgeqrf_lwork,
    cgeqrfp as cgeqrfp,
    cgeqrfp_lwork as cgeqrfp_lwork,
    cgeqrt as cgeqrt,
    cgerqf as cgerqf,
    cgesc2 as cgesc2,
    cgesdd as cgesdd,
    cgesdd_lwork as cgesdd_lwork,
    cgesv as cgesv,
    cgesvd as cgesvd,
    cgesvd_lwork as cgesvd_lwork,
    cgesvx as cgesvx,
    cgetc2 as cgetc2,
    cgetrf as cgetrf,
    cgetri as cgetri,
    cgetri_lwork as cgetri_lwork,
    cgetrs as cgetrs,
    cgges as cgges,
    cggev as cggev,
    cgglse as cgglse,
    cgglse_lwork as cgglse_lwork,
    cgtcon as cgtcon,
    cgtsv as cgtsv,
    cgtsvx as cgtsvx,
    cgttrf as cgttrf,
    cgttrs as cgttrs,
    chbevd as chbevd,
    chbevx as chbevx,
    checon as checon,
    cheequb as cheequb,
    cheev as cheev,
    cheev_lwork as cheev_lwork,
    cheevd as cheevd,
    cheevd_lwork as cheevd_lwork,
    cheevr as cheevr,
    cheevr_lwork as cheevr_lwork,
    cheevx as cheevx,
    cheevx_lwork as cheevx_lwork,
    chegst as chegst,
    chegv as chegv,
    chegv_lwork as chegv_lwork,
    chegvd as chegvd,
    chegvx as chegvx,
    chegvx_lwork as chegvx_lwork,
    chesv as chesv,
    chesv_lwork as chesv_lwork,
    chesvx as chesvx,
    chesvx_lwork as chesvx_lwork,
    chetrd as chetrd,
    chetrd_lwork as chetrd_lwork,
    chetrf as chetrf,
    chetrf_lwork as chetrf_lwork,
    chetri as chetri,
    chetrs as chetrs,
    chfrk as chfrk,
    clangb as clangb,
    clange as clange,
    clantr as clantr,
    clarf as clarf,
    clarfg as clarfg,
    clartg as clartg,
    claswp as claswp,
    clauum as clauum,
    cpbsv as cpbsv,
    cpbtrf as cpbtrf,
    cpbtrs as cpbtrs,
    cpftrf as cpftrf,
    cpftri as cpftri,
    cpftrs as cpftrs,
    cpocon as cpocon,
    cposv as cposv,
    cposvx as cposvx,
    cpotrf as cpotrf,
    cpotri as cpotri,
    cpotrs as cpotrs,
    cppcon as cppcon,
    cppsv as cppsv,
    cpptrf as cpptrf,
    cpptri as cpptri,
    cpptrs as cpptrs,
    cpstf2 as cpstf2,
    cpstrf as cpstrf,
    cpteqr as cpteqr,
    cptsv as cptsv,
    cptsvx as cptsvx,
    cpttrf as cpttrf,
    cpttrs as cpttrs,
    crot as crot,
    csycon as csycon,
    csyconv as csyconv,
    csyequb as csyequb,
    csysv as csysv,
    csysv_lwork as csysv_lwork,
    csysvx as csysvx,
    csysvx_lwork as csysvx_lwork,
    csytf2 as csytf2,
    csytrf as csytrf,
    csytrf_lwork as csytrf_lwork,
    csytri as csytri,
    csytrs as csytrs,
    ctbtrs as ctbtrs,
    ctfsm as ctfsm,
    ctfttp as ctfttp,
    ctfttr as ctfttr,
    ctgexc as ctgexc,
    ctgsen as ctgsen,
    ctgsen_lwork as ctgsen_lwork,
    ctpmqrt as ctpmqrt,
    ctpqrt as ctpqrt,
    ctpttf as ctpttf,
    ctpttr as ctpttr,
    ctrcon as ctrcon,
    ctrexc as ctrexc,
    ctrsen as ctrsen,
    ctrsen_lwork as ctrsen_lwork,
    ctrsyl as ctrsyl,
    ctrtri as ctrtri,
    ctrtrs as ctrtrs,
    ctrttf as ctrttf,
    ctrttp as ctrttp,
    ctzrzf as ctzrzf,
    ctzrzf_lwork as ctzrzf_lwork,
    cuncsd as cuncsd,
    cuncsd_lwork as cuncsd_lwork,
    cunghr as cunghr,
    cunghr_lwork as cunghr_lwork,
    cungqr as cungqr,
    cungrq as cungrq,
    cunmqr as cunmqr,
    cunmrz as cunmrz,
    cunmrz_lwork as cunmrz_lwork,
    dgbcon as dgbcon,
    dgbsv as dgbsv,
    dgbtrf as dgbtrf,
    dgbtrs as dgbtrs,
    dgebal as dgebal,
    dgecon as dgecon,
    dgeequ as dgeequ,
    dgeequb as dgeequb,
    dgees as dgees,
    dgeev as dgeev,
    dgeev_lwork as dgeev_lwork,
    dgehrd as dgehrd,
    dgehrd_lwork as dgehrd_lwork,
    dgejsv as dgejsv,
    dgels as dgels,
    dgels_lwork as dgels_lwork,
    dgelsd as dgelsd,
    dgelsd_lwork as dgelsd_lwork,
    dgelss as dgelss,
    dgelss_lwork as dgelss_lwork,
    dgelsy as dgelsy,
    dgelsy_lwork as dgelsy_lwork,
    dgemqrt as dgemqrt,
    dgeqp3 as dgeqp3,
    dgeqrf as dgeqrf,
    dgeqrf_lwork as dgeqrf_lwork,
    dgeqrfp as dgeqrfp,
    dgeqrfp_lwork as dgeqrfp_lwork,
    dgeqrt as dgeqrt,
    dgerqf as dgerqf,
    dgesc2 as dgesc2,
    dgesdd as dgesdd,
    dgesdd_lwork as dgesdd_lwork,
    dgesv as dgesv,
    dgesvd as dgesvd,
    dgesvd_lwork as dgesvd_lwork,
    dgesvx as dgesvx,
    dgetc2 as dgetc2,
    dgetrf as dgetrf,
    dgetri as dgetri,
    dgetri_lwork as dgetri_lwork,
    dgetrs as dgetrs,
    dgges as dgges,
    dggev as dggev,
    dgglse as dgglse,
    dgglse_lwork as dgglse_lwork,
    dgtcon as dgtcon,
    dgtsv as dgtsv,
    dgtsvx as dgtsvx,
    dgttrf as dgttrf,
    dgttrs as dgttrs,
    dlamch as dlamch,
    dlangb as dlangb,
    dlange as dlange,
    dlantr as dlantr,
    dlarf as dlarf,
    dlarfg as dlarfg,
    dlartg as dlartg,
    dlasd4 as dlasd4,
    dlaswp as dlaswp,
    dlauum as dlauum,
    dorcsd as dorcsd,
    dorcsd_lwork as dorcsd_lwork,
    dorghr as dorghr,
    dorghr_lwork as dorghr_lwork,
    dorgqr as dorgqr,
    dorgrq as dorgrq,
    dormqr as dormqr,
    dormrz as dormrz,
    dormrz_lwork as dormrz_lwork,
    dpbsv as dpbsv,
    dpbtrf as dpbtrf,
    dpbtrs as dpbtrs,
    dpftrf as dpftrf,
    dpftri as dpftri,
    dpftrs as dpftrs,
    dpocon as dpocon,
    dposv as dposv,
    dposvx as dposvx,
    dpotrf as dpotrf,
    dpotri as dpotri,
    dpotrs as dpotrs,
    dppcon as dppcon,
    dppsv as dppsv,
    dpptrf as dpptrf,
    dpptri as dpptri,
    dpptrs as dpptrs,
    dpstf2 as dpstf2,
    dpstrf as dpstrf,
    dpteqr as dpteqr,
    dptsv as dptsv,
    dptsvx as dptsvx,
    dpttrf as dpttrf,
    dpttrs as dpttrs,
    dsbev as dsbev,
    dsbevd as dsbevd,
    dsbevx as dsbevx,
    dsfrk as dsfrk,
    dstebz as dstebz,
    dstein as dstein,
    dstemr as dstemr,
    dstemr_lwork as dstemr_lwork,
    dsterf as dsterf,
    dstev as dstev,
    dstevd as dstevd,
    dsycon as dsycon,
    dsyconv as dsyconv,
    dsyequb as dsyequb,
    dsyev as dsyev,
    dsyev_lwork as dsyev_lwork,
    dsyevd as dsyevd,
    dsyevd_lwork as dsyevd_lwork,
    dsyevr as dsyevr,
    dsyevr_lwork as dsyevr_lwork,
    dsyevx as dsyevx,
    dsyevx_lwork as dsyevx_lwork,
    dsygst as dsygst,
    dsygv as dsygv,
    dsygv_lwork as dsygv_lwork,
    dsygvd as dsygvd,
    dsygvx as dsygvx,
    dsygvx_lwork as dsygvx_lwork,
    dsysv as dsysv,
    dsysv_lwork as dsysv_lwork,
    dsysvx as dsysvx,
    dsysvx_lwork as dsysvx_lwork,
    dsytf2 as dsytf2,
    dsytrd as dsytrd,
    dsytrd_lwork as dsytrd_lwork,
    dsytrf as dsytrf,
    dsytrf_lwork as dsytrf_lwork,
    dsytri as dsytri,
    dsytrs as dsytrs,
    dtbtrs as dtbtrs,
    dtfsm as dtfsm,
    dtfttp as dtfttp,
    dtfttr as dtfttr,
    dtgexc as dtgexc,
    dtgsen as dtgsen,
    dtgsen_lwork as dtgsen_lwork,
    dtgsyl as dtgsyl,
    dtpmqrt as dtpmqrt,
    dtpqrt as dtpqrt,
    dtpttf as dtpttf,
    dtpttr as dtpttr,
    dtrcon as dtrcon,
    dtrexc as dtrexc,
    dtrsen as dtrsen,
    dtrsen_lwork as dtrsen_lwork,
    dtrsyl as dtrsyl,
    dtrtri as dtrtri,
    dtrtrs as dtrtrs,
    dtrttf as dtrttf,
    dtrttp as dtrttp,
    dtzrzf as dtzrzf,
    dtzrzf_lwork as dtzrzf_lwork,
    ilaver as ilaver,
    sgbcon as sgbcon,
    sgbsv as sgbsv,
    sgbtrf as sgbtrf,
    sgbtrs as sgbtrs,
    sgebal as sgebal,
    sgecon as sgecon,
    sgeequ as sgeequ,
    sgeequb as sgeequb,
    sgees as sgees,
    sgeev as sgeev,
    sgeev_lwork as sgeev_lwork,
    sgehrd as sgehrd,
    sgehrd_lwork as sgehrd_lwork,
    sgejsv as sgejsv,
    sgels as sgels,
    sgels_lwork as sgels_lwork,
    sgelsd as sgelsd,
    sgelsd_lwork as sgelsd_lwork,
    sgelss as sgelss,
    sgelss_lwork as sgelss_lwork,
    sgelsy as sgelsy,
    sgelsy_lwork as sgelsy_lwork,
    sgemqrt as sgemqrt,
    sgeqp3 as sgeqp3,
    sgeqrf as sgeqrf,
    sgeqrf_lwork as sgeqrf_lwork,
    sgeqrfp as sgeqrfp,
    sgeqrfp_lwork as sgeqrfp_lwork,
    sgeqrt as sgeqrt,
    sgerqf as sgerqf,
    sgesc2 as sgesc2,
    sgesdd as sgesdd,
    sgesdd_lwork as sgesdd_lwork,
    sgesv as sgesv,
    sgesvd as sgesvd,
    sgesvd_lwork as sgesvd_lwork,
    sgesvx as sgesvx,
    sgetc2 as sgetc2,
    sgetrf as sgetrf,
    sgetri as sgetri,
    sgetri_lwork as sgetri_lwork,
    sgetrs as sgetrs,
    sgges as sgges,
    sggev as sggev,
    sgglse as sgglse,
    sgglse_lwork as sgglse_lwork,
    sgtcon as sgtcon,
    sgtsv as sgtsv,
    sgtsvx as sgtsvx,
    sgttrf as sgttrf,
    sgttrs as sgttrs,
    slamch as slamch,
    slangb as slangb,
    slange as slange,
    slantr as slantr,
    slarf as slarf,
    slarfg as slarfg,
    slartg as slartg,
    slasd4 as slasd4,
    slaswp as slaswp,
    slauum as slauum,
    sorcsd as sorcsd,
    sorcsd_lwork as sorcsd_lwork,
    sorghr as sorghr,
    sorghr_lwork as sorghr_lwork,
    sorgqr as sorgqr,
    sorgrq as sorgrq,
    sormqr as sormqr,
    sormrz as sormrz,
    sormrz_lwork as sormrz_lwork,
    spbsv as spbsv,
    spbtrf as spbtrf,
    spbtrs as spbtrs,
    spftrf as spftrf,
    spftri as spftri,
    spftrs as spftrs,
    spocon as spocon,
    sposv as sposv,
    sposvx as sposvx,
    spotrf as spotrf,
    spotri as spotri,
    spotrs as spotrs,
    sppcon as sppcon,
    sppsv as sppsv,
    spptrf as spptrf,
    spptri as spptri,
    spptrs as spptrs,
    spstf2 as spstf2,
    spstrf as spstrf,
    spteqr as spteqr,
    sptsv as sptsv,
    sptsvx as sptsvx,
    spttrf as spttrf,
    spttrs as spttrs,
    ssbev as ssbev,
    ssbevd as ssbevd,
    ssbevx as ssbevx,
    ssfrk as ssfrk,
    sstebz as sstebz,
    sstein as sstein,
    sstemr as sstemr,
    sstemr_lwork as sstemr_lwork,
    ssterf as ssterf,
    sstev as sstev,
    sstevd as sstevd,
    ssycon as ssycon,
    ssyconv as ssyconv,
    ssyequb as ssyequb,
    ssyev as ssyev,
    ssyev_lwork as ssyev_lwork,
    ssyevd as ssyevd,
    ssyevd_lwork as ssyevd_lwork,
    ssyevr as ssyevr,
    ssyevr_lwork as ssyevr_lwork,
    ssyevx as ssyevx,
    ssyevx_lwork as ssyevx_lwork,
    ssygst as ssygst,
    ssygv as ssygv,
    ssygv_lwork as ssygv_lwork,
    ssygvd as ssygvd,
    ssygvx as ssygvx,
    ssygvx_lwork as ssygvx_lwork,
    ssysv as ssysv,
    ssysv_lwork as ssysv_lwork,
    ssysvx as ssysvx,
    ssysvx_lwork as ssysvx_lwork,
    ssytf2 as ssytf2,
    ssytrd as ssytrd,
    ssytrd_lwork as ssytrd_lwork,
    ssytrf as ssytrf,
    ssytrf_lwork as ssytrf_lwork,
    ssytri as ssytri,
    ssytrs as ssytrs,
    stbtrs as stbtrs,
    stfsm as stfsm,
    stfttp as stfttp,
    stfttr as stfttr,
    stgexc as stgexc,
    stgsen as stgsen,
    stgsen_lwork as stgsen_lwork,
    stgsyl as stgsyl,
    stpmqrt as stpmqrt,
    stpqrt as stpqrt,
    stpttf as stpttf,
    stpttr as stpttr,
    strcon as strcon,
    strexc as strexc,
    strsen as strsen,
    strsen_lwork as strsen_lwork,
    strsyl as strsyl,
    strtri as strtri,
    strtrs as strtrs,
    strttf as strttf,
    strttp as strttp,
    stzrzf as stzrzf,
    stzrzf_lwork as stzrzf_lwork,
    zgbcon as zgbcon,
    zgbsv as zgbsv,
    zgbtrf as zgbtrf,
    zgbtrs as zgbtrs,
    zgebal as zgebal,
    zgecon as zgecon,
    zgeequ as zgeequ,
    zgeequb as zgeequb,
    zgees as zgees,
    zgeev as zgeev,
    zgeev_lwork as zgeev_lwork,
    zgehrd as zgehrd,
    zgehrd_lwork as zgehrd_lwork,
    zgels as zgels,
    zgels_lwork as zgels_lwork,
    zgelsd as zgelsd,
    zgelsd_lwork as zgelsd_lwork,
    zgelss as zgelss,
    zgelss_lwork as zgelss_lwork,
    zgelsy as zgelsy,
    zgelsy_lwork as zgelsy_lwork,
    zgemqrt as zgemqrt,
    zgeqp3 as zgeqp3,
    zgeqrf as zgeqrf,
    zgeqrf_lwork as zgeqrf_lwork,
    zgeqrfp as zgeqrfp,
    zgeqrfp_lwork as zgeqrfp_lwork,
    zgeqrt as zgeqrt,
    zgerqf as zgerqf,
    zgesc2 as zgesc2,
    zgesdd as zgesdd,
    zgesdd_lwork as zgesdd_lwork,
    zgesv as zgesv,
    zgesvd as zgesvd,
    zgesvd_lwork as zgesvd_lwork,
    zgesvx as zgesvx,
    zgetc2 as zgetc2,
    zgetrf as zgetrf,
    zgetri as zgetri,
    zgetri_lwork as zgetri_lwork,
    zgetrs as zgetrs,
    zgges as zgges,
    zggev as zggev,
    zgglse as zgglse,
    zgglse_lwork as zgglse_lwork,
    zgtcon as zgtcon,
    zgtsv as zgtsv,
    zgtsvx as zgtsvx,
    zgttrf as zgttrf,
    zgttrs as zgttrs,
    zhbevd as zhbevd,
    zhbevx as zhbevx,
    zhecon as zhecon,
    zheequb as zheequb,
    zheev as zheev,
    zheev_lwork as zheev_lwork,
    zheevd as zheevd,
    zheevd_lwork as zheevd_lwork,
    zheevr as zheevr,
    zheevr_lwork as zheevr_lwork,
    zheevx as zheevx,
    zheevx_lwork as zheevx_lwork,
    zhegst as zhegst,
    zhegv as zhegv,
    zhegv_lwork as zhegv_lwork,
    zhegvd as zhegvd,
    zhegvx as zhegvx,
    zhegvx_lwork as zhegvx_lwork,
    zhesv as zhesv,
    zhesv_lwork as zhesv_lwork,
    zhesvx as zhesvx,
    zhesvx_lwork as zhesvx_lwork,
    zhetrd as zhetrd,
    zhetrd_lwork as zhetrd_lwork,
    zhetrf as zhetrf,
    zhetrf_lwork as zhetrf_lwork,
    zhetri as zhetri,
    zhetrs as zhetrs,
    zhfrk as zhfrk,
    zlangb as zlangb,
    zlange as zlange,
    zlantr as zlantr,
    zlarf as zlarf,
    zlarfg as zlarfg,
    zlartg as zlartg,
    zlaswp as zlaswp,
    zlauum as zlauum,
    zpbsv as zpbsv,
    zpbtrf as zpbtrf,
    zpbtrs as zpbtrs,
    zpftrf as zpftrf,
    zpftri as zpftri,
    zpftrs as zpftrs,
    zpocon as zpocon,
    zposv as zposv,
    zposvx as zposvx,
    zpotrf as zpotrf,
    zpotri as zpotri,
    zpotrs as zpotrs,
    zppcon as zppcon,
    zppsv as zppsv,
    zpptrf as zpptrf,
    zpptri as zpptri,
    zpptrs as zpptrs,
    zpstf2 as zpstf2,
    zpstrf as zpstrf,
    zpteqr as zpteqr,
    zptsv as zptsv,
    zptsvx as zptsvx,
    zpttrf as zpttrf,
    zpttrs as zpttrs,
    zrot as zrot,
    zsycon as zsycon,
    zsyconv as zsyconv,
    zsyequb as zsyequb,
    zsysv as zsysv,
    zsysv_lwork as zsysv_lwork,
    zsysvx as zsysvx,
    zsysvx_lwork as zsysvx_lwork,
    zsytf2 as zsytf2,
    zsytrf as zsytrf,
    zsytrf_lwork as zsytrf_lwork,
    zsytri as zsytri,
    zsytrs as zsytrs,
    ztbtrs as ztbtrs,
    ztfsm as ztfsm,
    ztfttp as ztfttp,
    ztfttr as ztfttr,
    ztgexc as ztgexc,
    ztgsen as ztgsen,
    ztgsen_lwork as ztgsen_lwork,
    ztpmqrt as ztpmqrt,
    ztpqrt as ztpqrt,
    ztpttf as ztpttf,
    ztpttr as ztpttr,
    ztrcon as ztrcon,
    ztrexc as ztrexc,
    ztrsen as ztrsen,
    ztrsen_lwork as ztrsen_lwork,
    ztrsyl as ztrsyl,
    ztrtri as ztrtri,
    ztrtrs as ztrtrs,
    ztrttf as ztrttf,
    ztrttp as ztrttp,
    ztzrzf as ztzrzf,
    ztzrzf_lwork as ztzrzf_lwork,
    zuncsd as zuncsd,
    zuncsd_lwork as zuncsd_lwork,
    zunghr as zunghr,
    zunghr_lwork as zunghr_lwork,
    zungqr as zungqr,
    zungrq as zungrq,
    zunmqr as zunmqr,
    zunmrz as zunmrz,
    zunmrz_lwork as zunmrz_lwork,
)
from .blas import _FortranFunction

__all__ = ["get_lapack_funcs"]

HAS_ILP64: Final[bool] = ...

def get_lapack_funcs(
    names: Iterable[str] | str,
    arrays: Sequence[onp.ArrayND] = (),
    dtype: npt.DTypeLike | None = None,
    ilp64: Literal["preferred"] | bool = False,
) -> list[_FortranFunction] | _FortranFunction: ...
