from collections.abc import Callable
from typing import Final, Protocol, TypeVar, type_check_only

__all__ = ["docfiller"]

_FT = TypeVar("_FT", bound=Callable[..., object])

@type_check_only
class _Docfiller(Protocol):
    def __call__(self, f: _FT, /) -> _FT: ...

###

_intput_doc: Final[str] = ...
_axis_doc: Final[str] = ...
_output_doc: Final[str] = ...
_nan_doc: Final[str] = ...
_size_foot_doc: Final[str] = ...
_mode_reflect_doc: Final[str] = ...
_mode_interp_constant_doc: Final[str] = ...
_mode_interp_mirror_doc: Final[str] = ...
_mode_multiple_doc: Final[str] = ...
_cval_doc: Final[str] = ...
_origin_doc: Final[str] = ...
_origin_multiple_doc: Final[str] = ...
_extra_arguments_doc: Final[str] = ...
_extra_keywords_doc: Final[str] = ...
_prefilter_doc: Final[str] = ...
docdict: Final[dict[str, str]] = ...

docfiller: Final[_Docfiller]
