from collections.abc import Sequence as Seq
from typing import Any, Literal, TypeAlias, overload
from typing_extensions import TypeVar

import numpy as np
import optype.numpy as onp
import optype.numpy.compat as npc

from ._base import _spbase, sparray
from ._bsr import bsr_array, bsr_matrix
from ._coo import coo_array, coo_matrix
from ._csc import csc_array, csc_matrix
from ._csr import csr_array, csr_matrix
from ._dia import dia_array, dia_matrix
from ._dok import dok_array, dok_matrix
from ._lil import lil_array, lil_matrix
from ._matrix import spmatrix
from ._typing import _Format

__all__ = ["find", "tril", "triu"]

###

_SCT = TypeVar("_SCT", bound=npc.number | np.bool_, default=Any)
_ToDense: TypeAlias = onp.CanArrayND[_SCT] | Seq[_SCT] | Seq[Seq[_SCT] | onp.CanArrayND[_SCT]]

###

#
def find(A: _spbase[_SCT] | _ToDense) -> tuple[onp.Array1D[np.int32], onp.Array1D[np.int32], onp.Array1D[_SCT]]: ...

# NOTE: `tril` and `triu` have identical signatures
@overload  # sparray -> coo_array (default)
def tril(A: sparray[_SCT], k: int = 0, format: Literal["coo"] | None = None) -> coo_array[_SCT, tuple[int, int]]: ...
@overload  # sparray -> bsr_array (positional)
def tril(A: sparray[_SCT], k: int, format: Literal["bsr"]) -> bsr_array[_SCT]: ...
@overload  # sparray -> bsr_array (keyword)
def tril(A: sparray[_SCT], k: int = 0, *, format: Literal["bsr"]) -> bsr_array[_SCT]: ...
@overload  # sparray -> csc_array (positional)
def tril(A: sparray[_SCT], k: int, format: Literal["csc"]) -> csc_array[_SCT]: ...
@overload  # sparray -> csc_array (keyword)
def tril(A: sparray[_SCT], k: int = 0, *, format: Literal["csc"]) -> csc_array[_SCT]: ...
@overload  # sparray -> csr_array (positional)
def tril(A: sparray[_SCT], k: int, format: Literal["csr"]) -> csr_array[_SCT, tuple[int, int]]: ...
@overload  # sparray -> csr_array (keyword)
def tril(A: sparray[_SCT], k: int = 0, *, format: Literal["csr"]) -> csr_array[_SCT, tuple[int, int]]: ...
@overload  # sparray -> dia_array (positional)
def tril(A: sparray[_SCT], k: int, format: Literal["dia"]) -> dia_array[_SCT]: ...
@overload  # sparray -> dia_array (keyword)
def tril(A: sparray[_SCT], k: int = 0, *, format: Literal["dia"]) -> dia_array[_SCT]: ...
@overload  # sparray -> dok_array (positional)
def tril(A: sparray[_SCT], k: int, format: Literal["dok"]) -> dok_array[_SCT, tuple[int, int]]: ...
@overload  # sparray -> dok_array (keyword)
def tril(A: sparray[_SCT], k: int = 0, *, format: Literal["dok"]) -> dok_array[_SCT, tuple[int, int]]: ...
@overload  # sparray -> lil_array (positional)
def tril(A: sparray[_SCT], k: int, format: Literal["lil"]) -> lil_array[_SCT]: ...
@overload  # sparray -> lil_array (keyword)
def tril(A: sparray[_SCT], k: int = 0, *, format: Literal["lil"]) -> lil_array[_SCT]: ...
@overload  # spmatrix | array-like -> coo_matrix (default)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, format: Literal["coo"] | None = None) -> coo_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> bsr_matrix (positional)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["bsr"]) -> bsr_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> bsr_matrix (keyword)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["bsr"]) -> bsr_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> csc_matrix (positional)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["csc"]) -> csc_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> csc_matrix (keyword)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["csc"]) -> csc_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> csr_matrix (positional)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["csr"]) -> csr_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> csr_matrix (keyword)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["csr"]) -> csr_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> dia_matrix (positional)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["dia"]) -> dia_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> dia_matrix (keyword)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["dia"]) -> dia_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> dok_matrix (positional)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["dok"]) -> dok_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> dok_matrix (keyword)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["dok"]) -> dok_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> lil_matrix (positional)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["lil"]) -> lil_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> lil_matrix (keyword)
def tril(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["lil"]) -> lil_matrix[_SCT]: ...
@overload  # catch-all
def tril(A: _spbase[_SCT] | onp.ToComplexND, k: int = 0, *, format: _Format | None = None) -> _spbase[_SCT, tuple[int, int]]: ...

#
@overload  # sparray -> coo_array (default)
def triu(A: sparray[_SCT], k: int = 0, format: Literal["coo"] | None = None) -> coo_array[_SCT, tuple[int, int]]: ...
@overload  # sparray -> bsr_array (positional)
def triu(A: sparray[_SCT], k: int, format: Literal["bsr"]) -> bsr_array[_SCT]: ...
@overload  # sparray -> bsr_array (keyword)
def triu(A: sparray[_SCT], k: int = 0, *, format: Literal["bsr"]) -> bsr_array[_SCT]: ...
@overload  # sparray -> csc_array (positional)
def triu(A: sparray[_SCT], k: int, format: Literal["csc"]) -> csc_array[_SCT]: ...
@overload  # sparray -> csc_array (keyword)
def triu(A: sparray[_SCT], k: int = 0, *, format: Literal["csc"]) -> csc_array[_SCT]: ...
@overload  # sparray -> csr_array (positional)
def triu(A: sparray[_SCT], k: int, format: Literal["csr"]) -> csr_array[_SCT, tuple[int, int]]: ...
@overload  # sparray -> csr_array (keyword)
def triu(A: sparray[_SCT], k: int = 0, *, format: Literal["csr"]) -> csr_array[_SCT, tuple[int, int]]: ...
@overload  # sparray -> dia_array (positional)
def triu(A: sparray[_SCT], k: int, format: Literal["dia"]) -> dia_array[_SCT]: ...
@overload  # sparray -> dia_array (keyword)
def triu(A: sparray[_SCT], k: int = 0, *, format: Literal["dia"]) -> dia_array[_SCT]: ...
@overload  # sparray -> dok_array (positional)
def triu(A: sparray[_SCT], k: int, format: Literal["dok"]) -> dok_array[_SCT, tuple[int, int]]: ...
@overload  # sparray -> dok_array (keyword)
def triu(A: sparray[_SCT], k: int = 0, *, format: Literal["dok"]) -> dok_array[_SCT, tuple[int, int]]: ...
@overload  # sparray -> lil_array (positional)
def triu(A: sparray[_SCT], k: int, format: Literal["lil"]) -> lil_array[_SCT]: ...
@overload  # sparray -> lil_array (keyword)
def triu(A: sparray[_SCT], k: int = 0, *, format: Literal["lil"]) -> lil_array[_SCT]: ...
@overload  # spmatrix | array-like -> coo_matrix (default)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, format: Literal["coo"] | None = None) -> coo_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> bsr_matrix (positional)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["bsr"]) -> bsr_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> bsr_matrix (keyword)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["bsr"]) -> bsr_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> csc_matrix (positional)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["csc"]) -> csc_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> csc_matrix (keyword)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["csc"]) -> csc_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> csr_matrix (positional)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["csr"]) -> csr_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> csr_matrix (keyword)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["csr"]) -> csr_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> dia_matrix (positional)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["dia"]) -> dia_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> dia_matrix (keyword)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["dia"]) -> dia_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> dok_matrix (positional)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["dok"]) -> dok_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> dok_matrix (keyword)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["dok"]) -> dok_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> lil_matrix (positional)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int, format: Literal["lil"]) -> lil_matrix[_SCT]: ...
@overload  # spmatrix | array-like -> lil_matrix (keyword)
def triu(A: spmatrix[_SCT] | _ToDense[_SCT], k: int = 0, *, format: Literal["lil"]) -> lil_matrix[_SCT]: ...
@overload  # catch-all
def triu(A: _spbase[_SCT] | onp.ToComplexND, k: int = 0, *, format: _Format | None = None) -> _spbase[_SCT, tuple[int, int]]: ...
