# defined in scipy/spatial/src/distance_wrap.c

from typing import TypeAlias

import numpy as np
import optype.numpy as onp

_DoubleND: TypeAlias = onp.ArrayND[np.float64]
_Double1D: TypeAlias = onp.Array1D[np.float64]
_Double2D: TypeAlias = onp.Array2D[np.float64]
_BoolND: TypeAlias = onp.ArrayND[np.bool_]
_Bool1D: TypeAlias = onp.Array1D[np.bool_]
_Bool2D: TypeAlias = onp.Array2D[np.bool_]

###
# NOTE: These all return 0.0, and write the result to `dm`.

def cdist_braycurtis_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND) -> float: ...
def cdist_canberra_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND) -> float: ...
def cdist_chebyshev_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND) -> float: ...
def cdist_cityblock_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND) -> float: ...
def cdist_cosine_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND) -> float: ...
def cdist_euclidean_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND) -> float: ...
def cdist_hamming_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND, w: _DoubleND) -> float: ...
def cdist_jaccard_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND) -> float: ...
def cdist_jensenshannon_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND) -> float: ...
def cdist_mahalanobis_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND, VI: _DoubleND) -> float: ...
def cdist_minkowski_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND, p: float) -> float: ...
def cdist_seuclidean_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND, V: _DoubleND) -> float: ...
def cdist_sqeuclidean_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND) -> float: ...
def cdist_weighted_chebyshev_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND, w: _DoubleND) -> float: ...
def cdist_weighted_minkowski_double_wrap(XA: _DoubleND, XB: _DoubleND, dm: _DoubleND, p: float, w: _DoubleND) -> float: ...

#
def cdist_dice_bool_wrap(XA: _BoolND, XB: _BoolND, dm: _DoubleND) -> float: ...
def cdist_hamming_bool_wrap(XA: _BoolND, XB: _BoolND, dm: _DoubleND, w: _DoubleND) -> float: ...
def cdist_jaccard_bool_wrap(XA: _BoolND, XB: _BoolND, dm: _DoubleND) -> float: ...
def cdist_kulczynski1_bool_wrap(XA: _BoolND, XB: _BoolND, dm: _DoubleND) -> float: ...
def cdist_rogerstanimoto_bool_wrap(XA: _BoolND, XB: _BoolND, dm: _DoubleND) -> float: ...
def cdist_russellrao_bool_wrap(XA: _BoolND, XB: _BoolND, dm: _DoubleND) -> float: ...
def cdist_sokalmichener_bool_wrap(XA: _BoolND, XB: _BoolND, dm: _DoubleND) -> float: ...
def cdist_sokalsneath_bool_wrap(XA: _BoolND, XB: _BoolND, dm: _DoubleND) -> float: ...
def cdist_yule_bool_wrap(XA: _BoolND, XB: _BoolND, dm: _DoubleND) -> float: ...

#
def pdist_braycurtis_double_wrap(X: _Double2D, dm: _Double2D, /) -> float: ...
def pdist_canberra_double_wrap(X: _Double2D, dm: _Double2D, /) -> float: ...
def pdist_chebyshev_double_wrap(X: _Double2D, dm: _Double2D, /) -> float: ...
def pdist_cityblock_double_wrap(X: _Double2D, dm: _Double2D, /) -> float: ...
def pdist_cosine_double_wrap(X: _Double2D, dm: _Double2D) -> float: ...
def pdist_euclidean_double_wrap(X: _Double2D, dm: _Double2D, /) -> float: ...
def pdist_hamming_double_wrap(X: _Double2D, dm: _Double2D, w: _DoubleND) -> float: ...
def pdist_jaccard_double_wrap(X: _Double2D, dm: _Double2D, /) -> float: ...
def pdist_jensenshannon_double_wrap(X: _Double2D, dm: _Double2D, /) -> float: ...
def pdist_mahalanobis_double_wrap(X: _Double2D, dm: _Double2D, VI: _Double2D) -> float: ...
def pdist_minkowski_double_wrap(X: _Double2D, dm: _Double2D, p: float) -> float: ...
def pdist_seuclidean_double_wrap(X: _Double2D, dm: _Double2D, V: _DoubleND) -> float: ...
def pdist_sqeuclidean_double_wrap(X: _Double2D, dm: _Double2D, /) -> float: ...
def pdist_weighted_chebyshev_double_wrap(X: _Double2D, dm: _Double2D, w: _DoubleND) -> float: ...
def pdist_weighted_minkowski_double_wrap(X: _Double2D, dm: _Double2D, p: float, w: _DoubleND) -> float: ...

#
def pdist_dice_bool_wrap(X: _Bool2D, dm: _Double2D, /) -> float: ...
def pdist_hamming_bool_wrap(X: _Bool2D, dm: _Double2D, w: _DoubleND) -> float: ...
def pdist_jaccard_bool_wrap(X: _Bool2D, dm: _Double2D, /) -> float: ...
def pdist_kulczynski1_bool_wrap(X: _Bool2D, dm: _Double2D, /) -> float: ...
def pdist_rogerstanimoto_bool_wrap(X: _Bool2D, dm: _Double2D, /) -> float: ...
def pdist_russellrao_bool_wrap(X: _Bool2D, dm: _Double2D, /) -> float: ...
def pdist_sokalmichener_bool_wrap(X: _Bool2D, dm: _Double2D, /) -> float: ...
def pdist_sokalsneath_bool_wrap(X: _Bool2D, dm: _Double2D, /) -> float: ...
def pdist_yule_bool_wrap(X: _Bool2D, dm: _Double2D, /) -> float: ...

###

def to_squareform_from_vector_wrap(M: _Double2D | _Bool2D, v: _Double1D | _Bool1D, /) -> None: ...
def to_vector_from_squareform_wrap(M: _Double2D | _Bool2D, v: _Double1D | _Bool1D, /) -> None: ...
