# https://github.com/scipy/scipy/blob/maintenance/1.16.x/scipy/spatial/transform/_rigid_transform.pyx

from collections.abc import Iterable
from typing import Any, Self, TypeAlias, overload

import numpy as np
import optype as op
import optype.numpy as onp

from ._rotation import Rotation as Rotation, compose_quat as compose_quat

_Indexer: TypeAlias = op.CanIndex | onp.ToInt1D | slice

###

def normalize_dual_quaternion(dual_quat: onp.ArrayND[np.float64]) -> onp.ArrayND[np.float64]: ...
def _create_transformation_matrix(
    translations: onp.ToFloat1D | onp.ToFloat2D, rotation_matrices: onp.ToFloat2D | onp.ToFloat3D, single: bool
) -> onp.ArrayND[np.float64]: ...  # undocumented

class RigidTransform:
    @classmethod
    def from_matrix(cls, /, matrix: onp.ToFloat2D | onp.ToFloat3D) -> Self: ...
    @classmethod
    def from_rotation(cls, /, rotation: Rotation) -> Self: ...
    @classmethod
    def from_translation(cls, /, translation: onp.ToFloat1D | onp.ToFloat2D) -> Self: ...
    @classmethod
    def from_components(cls, /, translation: onp.ToFloat1D | onp.ToFloat2D, rotation: Rotation) -> Self: ...
    @classmethod
    def from_exp_coords(cls, /, exp_coords: onp.ToFloat1D | onp.ToFloat2D) -> Self: ...
    @classmethod
    def from_dual_quat(cls, /, dual_quat: onp.ToFloat1D | onp.ToFloat2D, *, scalar_first: bool = False) -> Self: ...
    @classmethod
    def identity(cls, /, num: onp.ToJustInt | None = None) -> Self: ...
    @classmethod
    def concatenate(cls, /, transforms: RigidTransform | Iterable[RigidTransform]) -> Self: ...

    #
    def __init__(self, /, matrix: onp.ToFloat2D | onp.ToFloat3D, normalize: bool = True, copy: bool = True) -> None: ...
    def __len__(self, /) -> int: ...
    def __getitem__(self, indexer: _Indexer, /) -> Self: ...
    def __setitem__(self, indexer: _Indexer, value: Self, /) -> None: ...
    def __mul__(self, other: Self, /) -> Self: ...
    def __pow__(self, n: onp.ToFloat, /) -> Self: ...

    #
    def __setstate_cython__(self, pyx_state: object, /) -> None: ...  # undocumented
    def __reduce_cython__(self, /) -> None: ...  # undocumented

    #
    def as_matrix(self, /) -> onp.ArrayND[np.float64, tuple[int, int] | tuple[int, int, int]]: ...
    def as_components(self, /) -> tuple[onp.ArrayND[np.float64, tuple[int] | tuple[int, int]], Rotation]: ...
    def as_exp_coords(self, /) -> onp.ArrayND[np.float64, tuple[int] | tuple[int, int]]: ...
    def as_dual_quat(self, /, *, scalar_first: bool = False) -> onp.ArrayND[np.float64, tuple[int] | tuple[int, int]]: ...
    def inv(self, /) -> Self: ...

    #
    @overload
    def apply(self, /, vector: onp.ToFloatStrict1D, inverse: bool = False) -> onp.Array1D[np.float64]: ...
    @overload
    def apply(self, /, vector: onp.ToFloatStrict2D, inverse: bool = False) -> onp.Array2D[np.float64]: ...
    @overload
    def apply(
        self, /, vector: onp.ToFloat1D | onp.ToFloat2D, inverse: bool = False
    ) -> onp.ArrayND[np.float64, tuple[int] | tuple[Any, ...]]: ...

    #
    @property
    def rotation(self, /) -> Rotation: ...
    @property
    def translation(self, /) -> onp.ArrayND[np.float64, tuple[int] | tuple[int, int]]: ...
    @property
    def single(self, /) -> bool: ...
