from typing import Literal, TypeVar

from ._rotation import Rotation

_RotationT = TypeVar("_RotationT", bound=Rotation)

def icosahedral(cls: type[_RotationT]) -> _RotationT: ...
def octahedral(cls: type[_RotationT]) -> _RotationT: ...
def tetrahedral(cls: type[_RotationT]) -> _RotationT: ...
def dicyclic(cls: type[_RotationT], n: int, axis: int = 2) -> _RotationT: ...
def cyclic(cls: type[_RotationT], n: int, axis: int = 2) -> _RotationT: ...
def create_group(
    cls: type[_RotationT], group: Literal["I", "O", "T", "Dn", "Cn"], axis: Literal["x", "y", "z", "X", "Y", "Z"] = "Z"
) -> _RotationT: ...
