from typing import Literal as L, TypeAlias, overload
from typing_extensions import TypeVar, Unpack, deprecated

import numpy as np
import optype as op
import optype.numpy as onp
import optype.numpy.compat as npc

from ._ufuncs import _KwBase, psi as digamma

__all__ = [
    "ai_zeros",
    "assoc_laguerre",
    "bei_zeros",
    "beip_zeros",
    "ber_zeros",
    "bernoulli",
    "berp_zeros",
    "bi_zeros",
    "clpmn",
    "comb",
    "digamma",
    "diric",
    "erf_zeros",
    "euler",
    "factorial",
    "factorial2",
    "factorialk",
    "fresnel_zeros",
    "fresnelc_zeros",
    "fresnels_zeros",
    "h1vp",
    "h2vp",
    "ivp",
    "jn_zeros",
    "jnjnp_zeros",
    "jnp_zeros",
    "jnyn_zeros",
    "jvp",
    "kei_zeros",
    "keip_zeros",
    "kelvin_zeros",
    "ker_zeros",
    "kerp_zeros",
    "kvp",
    "lmbda",
    "lpmn",
    "lpn",
    "lqmn",
    "lqn",
    "mathieu_even_coef",
    "mathieu_odd_coef",
    "obl_cv_seq",
    "pbdn_seq",
    "pbdv_seq",
    "pbvv_seq",
    "perm",
    "polygamma",
    "pro_cv_seq",
    "riccati_jn",
    "riccati_yn",
    "sinc",
    "softplus",
    "stirling2",
    "y0_zeros",
    "y1_zeros",
    "y1p_zeros",
    "yn_zeros",
    "ynp_zeros",
    "yvp",
    "zeta",
]

###

_T = TypeVar("_T")
_T0 = TypeVar("_T0")
_T1 = TypeVar("_T1")

_ArrayT = TypeVar("_ArrayT", bound=onp.ArrayND)
_ShapeT = TypeVar("_ShapeT", bound=tuple[int, ...])
_SCT_iu = TypeVar("_SCT_iu", bound=npc.integer)
_SCT_f = TypeVar("_SCT_f", bound=npc.floating)
_SCT_fc = TypeVar("_SCT_fc", bound=npc.inexact)

_ToIntOrND: TypeAlias = onp.ToInt | onp.ToIntND
_ToFloatOrND: TypeAlias = onp.ToFloat | onp.ToFloatND
_ToComplexOrND: TypeAlias = onp.ToComplex | onp.ToComplexND
_ToJustComplexOrND: TypeAlias = onp.ToJustComplex | onp.ToJustComplexND

_Extend0: TypeAlias = L["zero"]
_ExtendC: TypeAlias = L["complex"]
_Extend: TypeAlias = L[_Extend0, _ExtendC]

# ruff: noqa: PYI042
_tuple2: TypeAlias = tuple[_T, _T]
_tuple4: TypeAlias = tuple[_T0, _T1, _T1, _T1]
_tuple8: TypeAlias = tuple[_T0, _T1, _T1, _T1, _T1, _T1, _T1, _T1]

_i4: TypeAlias = np.int32
_i8: TypeAlias = np.int64
_f4: TypeAlias = np.float32
_f8: TypeAlias = np.float64
_c4: TypeAlias = np.complex64
_c8: TypeAlias = np.complex128

_fc8: TypeAlias = _f8 | _c8

_i: TypeAlias = _i4 | _i8
_f: TypeAlias = _f4 | _f8
_c: TypeAlias = _c4 | _c8
_fc: TypeAlias = _f | _c

_f8_1d: TypeAlias = onp.Array1D[_f8]
_f8_nd: TypeAlias = onp.ArrayND[_f8]
_c8_1d: TypeAlias = onp.Array1D[_c8]
_c8_nd: TypeAlias = onp.ArrayND[_c8]
_fc8_nd: TypeAlias = onp.ArrayND[_fc8]

_i_nd: TypeAlias = onp.ArrayND[_i]
_f_nd: TypeAlias = onp.ArrayND[_f]
_c_nd: TypeAlias = onp.ArrayND[_c]
_fc_nd: TypeAlias = onp.ArrayND[_fc]

###

@overload
def sinc(x: _SCT_fc) -> _SCT_fc: ...
@overload
def sinc(x: float | onp.ToInt) -> _f8: ...
@overload
def sinc(x: op.JustComplex) -> _c8: ...
@overload
def sinc(x: complex) -> _fc8: ...  # type: ignore[overload-cannot-match]  # pyright: ignore[reportOverlappingOverload]s
@overload
def sinc(x: onp.ToIntND) -> _f8_nd: ...
@overload
def sinc(x: onp.ToFloatND) -> onp.ArrayND[npc.floating]: ...
@overload
def sinc(x: onp.ToComplexND) -> onp.ArrayND[npc.inexact]: ...

#
@overload
def diric(x: onp.ToFloat, n: int | _i) -> onp.Array0D[_f8]: ...
@overload
def diric(x: onp.ToFloat, n: onp.ToInt) -> onp.Array0D[npc.floating]: ...
@overload
def diric(x: _ToFloatOrND, n: onp.ToInt) -> onp.ArrayND[npc.floating]: ...

#
def jnjnp_zeros(nt: onp.ToInt) -> _tuple4[_f8_1d, onp.Array1D[_i4]]: ...
def jnyn_zeros(n: onp.ToInt, nt: onp.ToInt) -> _tuple4[_f8_1d, _f8_1d]: ...
def jn_zeros(n: onp.ToInt, nt: onp.ToInt) -> _f8_1d: ...
def jnp_zeros(n: onp.ToInt, nt: onp.ToInt) -> _f8_1d: ...
def yn_zeros(n: onp.ToInt, nt: onp.ToInt) -> _f8_1d: ...
def ynp_zeros(n: onp.ToInt, nt: onp.ToInt) -> _f8_1d: ...

#
def y0_zeros(nt: onp.ToInt, complex: op.CanBool = False) -> _tuple2[_c8_1d]: ...
def y1_zeros(nt: onp.ToInt, complex: op.CanBool = False) -> _tuple2[_c8_1d]: ...
def y1p_zeros(nt: onp.ToInt, complex: op.CanBool = False) -> _tuple2[_c8_1d]: ...

#
@overload
def jvp(v: onp.ToFloat, z: onp.ToFloat, n: onp.ToInt = 1) -> _f: ...
@overload
def jvp(v: onp.ToFloat, z: onp.ToJustComplex, n: onp.ToInt = 1) -> _c: ...
@overload
def jvp(v: onp.ToFloat, z: onp.ToComplex, n: onp.ToInt = 1) -> _fc: ...
@overload
def jvp(v: _ToFloatOrND, z: onp.ToFloatND, n: onp.ToInt = 1) -> _f_nd: ...
@overload
def jvp(v: onp.ToFloatND, z: _ToFloatOrND, n: onp.ToInt = 1) -> _f_nd: ...
@overload
def jvp(v: _ToFloatOrND, z: onp.ToJustComplexND, n: onp.ToInt = 1) -> _c_nd: ...
@overload
def jvp(v: onp.ToFloatND, z: _ToJustComplexOrND, n: onp.ToInt = 1) -> _c_nd: ...
@overload
def jvp(v: _ToFloatOrND, z: onp.ToComplexND, n: onp.ToInt = 1) -> _fc_nd: ...
@overload
def jvp(v: onp.ToFloatND, z: _ToComplexOrND, n: onp.ToInt = 1) -> _fc_nd: ...

#
@overload
def yvp(v: onp.ToFloat, z: onp.ToFloat, n: onp.ToInt = 1) -> _f: ...
@overload
def yvp(v: onp.ToFloat, z: onp.ToJustComplex, n: onp.ToInt = 1) -> _c: ...
@overload
def yvp(v: onp.ToFloat, z: onp.ToComplex, n: onp.ToInt = 1) -> _fc: ...
@overload
def yvp(v: _ToFloatOrND, z: onp.ToFloatND, n: onp.ToInt = 1) -> _f_nd: ...
@overload
def yvp(v: onp.ToFloatND, z: _ToFloatOrND, n: onp.ToInt = 1) -> _f_nd: ...
@overload
def yvp(v: _ToFloatOrND, z: onp.ToJustComplexND, n: onp.ToInt = 1) -> _c_nd: ...
@overload
def yvp(v: onp.ToFloatND, z: _ToJustComplexOrND, n: onp.ToInt = 1) -> _c_nd: ...
@overload
def yvp(v: _ToFloatOrND, z: onp.ToComplexND, n: onp.ToInt = 1) -> _fc_nd: ...
@overload
def yvp(v: onp.ToFloatND, z: _ToComplexOrND, n: onp.ToInt = 1) -> _fc_nd: ...

#
@overload
def kvp(v: onp.ToFloat, z: onp.ToFloat, n: onp.ToInt = 1) -> _f: ...
@overload
def kvp(v: onp.ToFloat, z: onp.ToJustComplex, n: onp.ToInt = 1) -> _c: ...
@overload
def kvp(v: onp.ToFloat, z: onp.ToComplex, n: onp.ToInt = 1) -> _fc: ...
@overload
def kvp(v: _ToFloatOrND, z: onp.ToFloatND, n: onp.ToInt = 1) -> _f_nd: ...
@overload
def kvp(v: onp.ToFloatND, z: _ToFloatOrND, n: onp.ToInt = 1) -> _f_nd: ...
@overload
def kvp(v: _ToFloatOrND, z: onp.ToJustComplexND, n: onp.ToInt = 1) -> _c_nd: ...
@overload
def kvp(v: onp.ToFloatND, z: _ToJustComplexOrND, n: onp.ToInt = 1) -> _c_nd: ...
@overload
def kvp(v: _ToFloatOrND, z: onp.ToComplexND, n: onp.ToInt = 1) -> _fc_nd: ...
@overload
def kvp(v: onp.ToFloatND, z: _ToComplexOrND, n: onp.ToInt = 1) -> _fc_nd: ...

#
@overload
def ivp(v: onp.ToFloat, z: onp.ToFloat, n: onp.ToInt = 1) -> _f: ...
@overload
def ivp(v: onp.ToFloat, z: onp.ToJustComplex, n: onp.ToInt = 1) -> _c: ...
@overload
def ivp(v: onp.ToFloat, z: onp.ToComplex, n: onp.ToInt = 1) -> _fc: ...
@overload
def ivp(v: _ToFloatOrND, z: onp.ToFloatND, n: onp.ToInt = 1) -> _f_nd: ...
@overload
def ivp(v: onp.ToFloatND, z: _ToFloatOrND, n: onp.ToInt = 1) -> _f_nd: ...
@overload
def ivp(v: _ToFloatOrND, z: onp.ToJustComplexND, n: onp.ToInt = 1) -> _c_nd: ...
@overload
def ivp(v: onp.ToFloatND, z: _ToJustComplexOrND, n: onp.ToInt = 1) -> _c_nd: ...
@overload
def ivp(v: _ToFloatOrND, z: onp.ToComplexND, n: onp.ToInt = 1) -> _fc_nd: ...
@overload
def ivp(v: onp.ToFloatND, z: _ToComplexOrND, n: onp.ToInt = 1) -> _fc_nd: ...

#
@overload
def h1vp(v: onp.ToFloat, z: onp.ToComplex, n: onp.ToInt = 1) -> _c: ...
@overload
def h1vp(v: _ToFloatOrND, z: onp.ToComplexND, n: onp.ToInt = 1) -> _c: ...
@overload
def h1vp(v: onp.ToFloatND, z: _ToComplexOrND, n: onp.ToInt = 1) -> _c: ...

#
@overload
def h2vp(v: onp.ToFloat, z: onp.ToComplex, n: onp.ToInt = 1) -> _c: ...
@overload
def h2vp(v: _ToFloatOrND, z: onp.ToComplexND, n: onp.ToInt = 1) -> _c: ...
@overload
def h2vp(v: onp.ToFloatND, z: _ToComplexOrND, n: onp.ToInt = 1) -> _c: ...

#
def riccati_jn(n: onp.ToInt, x: onp.ToFloat) -> _tuple2[_f8_1d]: ...
def riccati_yn(n: onp.ToInt, x: onp.ToFloat) -> _tuple2[_f8_1d]: ...

#
def erf_zeros(nt: onp.ToInt) -> _c8_1d: ...
def fresnelc_zeros(nt: onp.ToInt) -> _c8_1d: ...
def fresnels_zeros(nt: onp.ToInt) -> _c8_1d: ...
def fresnel_zeros(nt: onp.ToInt) -> _c8_1d: ...

#
@overload
def assoc_laguerre(x: onp.ToFloat, n: onp.ToInt, k: onp.ToFloat = 0.0) -> _f: ...
@overload
def assoc_laguerre(x: onp.ToJustComplex, n: onp.ToInt, k: onp.ToFloat = 0.0) -> _c: ...
@overload
def assoc_laguerre(x: onp.ToComplex, n: onp.ToInt, k: onp.ToFloat = 0.0) -> _fc: ...
@overload
def assoc_laguerre(x: _ToFloatOrND, n: _ToIntOrND, k: onp.ToFloatND) -> _f_nd: ...
@overload
def assoc_laguerre(x: _ToFloatOrND, n: onp.ToIntND, k: _ToFloatOrND) -> _f_nd: ...
@overload
def assoc_laguerre(x: onp.ToFloatND, n: _ToIntOrND, k: _ToFloatOrND) -> _f_nd: ...
@overload
def assoc_laguerre(x: _ToJustComplexOrND, n: _ToIntOrND, k: onp.ToFloatND) -> _c_nd: ...
@overload
def assoc_laguerre(x: _ToJustComplexOrND, n: onp.ToIntND, k: _ToFloatOrND) -> _c_nd: ...
@overload
def assoc_laguerre(x: onp.ToJustComplexND, n: _ToIntOrND, k: _ToFloatOrND) -> _c_nd: ...
@overload
def assoc_laguerre(x: _ToComplexOrND, n: _ToIntOrND, k: onp.ToFloatND) -> _fc_nd: ...
@overload
def assoc_laguerre(x: _ToComplexOrND, n: onp.ToIntND, k: _ToFloatOrND) -> _fc_nd: ...
@overload
def assoc_laguerre(x: onp.ToComplexND, n: _ToIntOrND, k: _ToFloatOrND) -> _fc_nd: ...
@overload
def assoc_laguerre(x: _ToComplexOrND, n: _ToIntOrND, k: _ToFloatOrND) -> _fc | _fc_nd: ...

#
@overload
def polygamma(n: onp.ToInt, x: onp.ToFloat) -> _f8: ...
@overload
def polygamma(n: _ToIntOrND, x: onp.ToFloatND) -> _f8_nd: ...
@overload
def polygamma(n: onp.ToIntND, x: _ToFloatOrND) -> _f8_nd: ...
@overload
def polygamma(n: _ToIntOrND, x: _ToFloatOrND) -> _f8 | _f8_nd: ...

#
def mathieu_even_coef(m: onp.ToInt, q: onp.ToFloat) -> _f8_1d: ...
def mathieu_odd_coef(m: onp.ToInt, q: onp.ToFloat) -> _f8_1d: ...

#
@overload
def lqn(n: onp.ToInt, z: onp.ToFloat) -> _tuple2[_f8_1d]: ...
@overload
def lqn(n: onp.ToInt, z: _ToFloatOrND) -> _tuple2[_f8_nd]: ...
@overload
def lqn(n: onp.ToInt, z: onp.ToJustComplex) -> _tuple2[_c8_1d]: ...
@overload
def lqn(n: onp.ToInt, z: _ToJustComplexOrND) -> _tuple2[_c8_nd]: ...
@overload
def lqn(n: onp.ToInt, z: _ToComplexOrND) -> _tuple2[_f8_nd] | _tuple2[_c8_nd]: ...

#
@overload
def lqmn(m: onp.ToFloat, n: onp.ToFloat, z: onp.ToFloat) -> _tuple2[_f8_1d]: ...
@overload
def lqmn(m: onp.ToFloat, n: onp.ToFloat, z: _ToFloatOrND) -> _tuple2[_f8_nd]: ...
@overload
def lqmn(m: onp.ToFloat, n: onp.ToFloat, z: onp.ToJustComplex) -> _tuple2[_c8_1d]: ...
@overload
def lqmn(m: onp.ToFloat, n: onp.ToFloat, z: _ToJustComplexOrND) -> _tuple2[_c8_nd]: ...
@overload
def lqmn(m: onp.ToFloat, n: onp.ToFloat, z: _ToComplexOrND) -> _tuple2[_f8_nd] | _tuple2[_c8_nd]: ...

# accepts floating input, but it's probably not useful
def bernoulli(n: onp.ToFloat) -> _f8_1d: ...
def euler(n: onp.ToFloat) -> _f8_1d: ...
def ai_zeros(nt: onp.ToFloat) -> _tuple4[_f8_1d, _f8_1d]: ...
def bi_zeros(nt: onp.ToFloat) -> _tuple4[_f8_1d, _f8_1d]: ...

#
def lmbda(v: onp.ToFloat, x: onp.ToFloat) -> _tuple2[_f8_1d]: ...
def pbdv_seq(v: onp.ToFloat, x: onp.ToFloat) -> _tuple2[_f8_1d]: ...
def pbvv_seq(v: onp.ToFloat, x: onp.ToFloat) -> _tuple2[_f8_1d]: ...
def pbdn_seq(n: onp.ToInt, z: onp.ToComplex) -> _tuple2[_c8_1d]: ...

#
def ber_zeros(nt: onp.ToInt) -> _f8_1d: ...
def bei_zeros(nt: onp.ToInt) -> _f8_1d: ...
def ker_zeros(nt: onp.ToInt) -> _f8_1d: ...
def kei_zeros(nt: onp.ToInt) -> _f8_1d: ...
def berp_zeros(nt: onp.ToInt) -> _f8_1d: ...
def beip_zeros(nt: onp.ToInt) -> _f8_1d: ...
def kerp_zeros(nt: onp.ToInt) -> _f8_1d: ...
def keip_zeros(nt: onp.ToInt) -> _f8_1d: ...
def kelvin_zeros(nt: onp.ToInt) -> _tuple8[_f8_1d, _f8_1d]: ...

#
def pro_cv_seq(m: onp.ToInt, n: onp.ToInt, c: onp.ToFloat) -> _f8_1d: ...
def obl_cv_seq(m: onp.ToInt, n: onp.ToInt, c: onp.ToFloat) -> _f8_1d: ...

#
@deprecated(
    "This function is deprecated as of SciPy 1.15.0 and will be removed in SciPy 1.17.0. "
    "Please use `scipy.special.legendre_p_all` instead."
)
def lpn(n: onp.ToInt, z: onp.ToComplex) -> onp.ArrayND[npc.inexact]: ...
@deprecated(
    "This function is deprecated as of SciPy 1.15.0 and will be removed in SciPy 1.17.0. "
    "Please use `scipy.special.assoc_legendre_p_all` instead."
)
def lpmn(m: onp.ToInt, n: onp.ToInt, z: _ToFloatOrND) -> _tuple2[_f8_nd]: ...
@deprecated(
    "This function is deprecated as of SciPy 1.15.0 and will be removed in SciPy 1.17.0. "
    "Please use `scipy.special.assoc_legendre_p_all` instead."
)
def clpmn(m: onp.ToInt, n: onp.ToInt, z: _ToComplexOrND, type: L[2, 3] = 3) -> _tuple2[_c8_nd]: ...

#
@overload
def comb(N: onp.ToInt | onp.Array0D[npc.integer], k: onp.ToInt, *, exact: onp.ToTrue, repetition: op.CanBool = False) -> int: ...
@overload
def comb(N: onp.ToFloat, k: onp.ToFloat, *, exact: onp.ToFalse = False, repetition: op.CanBool = False) -> _f: ...
@overload
def comb(N: _ToFloatOrND, k: onp.ToFloatND, *, exact: onp.ToFalse = False, repetition: op.CanBool = False) -> _f_nd: ...
@overload
def comb(N: onp.ToFloatND, k: _ToFloatOrND, *, exact: onp.ToFalse = False, repetition: op.CanBool = False) -> _f_nd: ...
@overload
def comb(N: _ToFloatOrND, k: _ToFloatOrND, *, exact: onp.ToFalse = False, repetition: op.CanBool = False) -> _f | _f_nd: ...

#
@overload
def perm(N: onp.ToInt | onp.Array0D[npc.integer], k: onp.ToInt | onp.Array0D[npc.integer], exact: onp.ToTrue) -> int: ...
@overload
def perm(N: onp.ToFloat, k: onp.ToFloat, exact: onp.ToFalse = False) -> _f: ...
@overload
def perm(N: _ToFloatOrND, k: onp.ToFloatND, exact: onp.ToFalse = False) -> _f_nd: ...
@overload
def perm(N: onp.ToFloatND, k: _ToFloatOrND, exact: onp.ToFalse = False) -> _f_nd: ...
@overload
def perm(N: _ToFloatOrND, k: _ToFloatOrND, exact: onp.ToFalse = False) -> _f | _f_nd: ...

#
@overload
def factorial(n: onp.ToJustInt, exact: onp.ToTrue, extend: _Extend0 = "zero") -> int: ...
@overload
def factorial(n: onp.ToIntND, exact: onp.ToTrue, extend: _Extend0 = "zero") -> _i_nd: ...
@overload
def factorial(n: onp.ToFloat, exact: onp.ToFalse = False, extend: _Extend = "zero") -> _f8: ...
@overload
def factorial(n: onp.ToFloatND, exact: onp.ToFalse = False, extend: _Extend = "zero") -> _f8_nd: ...
@overload
def factorial(n: onp.ToComplex, exact: onp.ToFalse, extend: _ExtendC) -> _fc8: ...
@overload
def factorial(n: onp.ToComplexND, exact: onp.ToFalse, extend: _ExtendC) -> _fc8_nd: ...
@overload
def factorial(n: onp.ToComplex, exact: onp.ToFalse = False, *, extend: _ExtendC) -> _fc8: ...
@overload
def factorial(n: onp.ToComplexND, exact: onp.ToFalse = False, *, extend: _ExtendC) -> _fc8_nd: ...

#
@overload
def factorial2(n: int, exact: onp.ToTrue, extend: _Extend0 = "zero") -> int: ...
@overload
def factorial2(n: _SCT_iu, exact: onp.ToTrue, extend: _Extend0 = "zero") -> _SCT_iu: ...
@overload
def factorial2(n: onp.ToIntND, exact: onp.ToTrue, extend: _Extend0 = "zero") -> _i_nd: ...
@overload
def factorial2(n: onp.ToFloat, exact: onp.ToFalse = False, extend: _Extend = "zero") -> _f8: ...
@overload
def factorial2(n: onp.ToFloatND, exact: onp.ToFalse = False, extend: _Extend = "zero") -> _f8_nd: ...
@overload
def factorial2(n: onp.ToComplex, exact: onp.ToFalse, extend: _ExtendC) -> _fc8: ...
@overload
def factorial2(n: onp.ToComplexND, exact: onp.ToFalse, extend: _ExtendC) -> _fc8_nd: ...
@overload
def factorial2(n: onp.ToComplex, exact: onp.ToFalse = False, *, extend: _ExtendC) -> _fc8: ...
@overload
def factorial2(n: onp.ToComplexND, exact: onp.ToFalse = False, *, extend: _ExtendC) -> _fc8_nd: ...

#
@overload
def factorialk(n: onp.ToJustInt, k: onp.ToJustInt, exact: onp.ToTrue, extend: _Extend0 = "zero") -> int: ...
@overload
def factorialk(n: onp.ToJustIntND, k: onp.ToJustInt, exact: onp.ToTrue, extend: _Extend0 = "zero") -> _i_nd: ...
@overload
def factorialk(n: onp.ToFloat, k: onp.ToInt, exact: onp.ToFalse = False, extend: _Extend = "zero") -> _f8: ...
@overload
def factorialk(n: onp.ToFloatND, k: onp.ToInt, exact: onp.ToFalse = False, extend: _Extend = "zero") -> _f8_nd: ...
@overload
def factorialk(n: onp.ToComplex, k: onp.ToInt, exact: onp.ToFalse, extend: _ExtendC) -> _fc8: ...
@overload
def factorialk(n: onp.ToComplexND, k: onp.ToInt, exact: onp.ToFalse, extend: _ExtendC) -> _fc8_nd: ...
@overload
def factorialk(n: onp.ToComplex, k: onp.ToInt, exact: onp.ToFalse = False, *, extend: _ExtendC) -> _fc8: ...
@overload
def factorialk(n: onp.ToComplexND, k: onp.ToInt, exact: onp.ToFalse = False, *, extend: _ExtendC) -> _fc8_nd: ...

#
@overload
def stirling2(N: onp.ToInt, K: onp.ToInt, *, exact: onp.ToTrue) -> int: ...
@overload
def stirling2(N: _ToIntOrND, K: onp.ToIntND, *, exact: onp.ToTrue) -> onp.ArrayND[np.object_]: ...
@overload
def stirling2(N: onp.ToIntND, K: _ToIntOrND, *, exact: onp.ToTrue) -> onp.ArrayND[np.object_]: ...
@overload
def stirling2(N: onp.ToInt, K: onp.ToInt, *, exact: onp.ToFalse = False) -> _f8: ...
@overload
def stirling2(N: _ToIntOrND, K: onp.ToIntND, *, exact: onp.ToFalse = False) -> _f8_nd: ...
@overload
def stirling2(N: onp.ToIntND, K: _ToIntOrND, *, exact: onp.ToFalse = False) -> _f8_nd: ...

#
@overload
def zeta(x: _ToComplexOrND, q: _ToFloatOrND | None, out: _ArrayT) -> _ArrayT: ...
@overload
def zeta(x: _ToComplexOrND, q: _ToFloatOrND | None = None, *, out: _ArrayT) -> _ArrayT: ...
@overload
def zeta(x: onp.ToFloat, q: onp.ToFloat | None = None, out: None = None) -> _f8: ...
@overload
def zeta(x: _ToFloatOrND, q: onp.ToFloatND, out: None = None) -> _f8_nd: ...
@overload
def zeta(x: onp.ToFloatND, q: _ToFloatOrND | None = None, out: None = None) -> _f8_nd: ...
@overload
def zeta(x: onp.ToJustComplex, q: onp.ToFloat | None = None, out: None = None) -> _c8: ...
@overload
def zeta(x: _ToJustComplexOrND, q: onp.ToFloatND, out: None = None) -> _c8_nd: ...
@overload
def zeta(x: onp.ToJustComplexND, q: _ToFloatOrND | None = None, out: None = None) -> _c8_nd: ...
@overload
def zeta(x: onp.ToComplex, q: onp.ToFloat | None = None, out: None = None) -> _fc8: ...
@overload
def zeta(x: _ToComplexOrND, q: onp.ToFloatND, out: None = None) -> _fc8_nd: ...
@overload
def zeta(x: onp.ToComplexND, q: _ToFloatOrND | None = None, out: None = None) -> _fc8_nd: ...

#
@overload
def softplus(x: _ToFloatOrND, *, out: _ArrayT, dtype: None = None, **kwds: Unpack[_KwBase]) -> _ArrayT: ...
@overload
def softplus(x: float | _f8, *, out: None = None, dtype: None = None, **kwds: Unpack[_KwBase]) -> _f8: ...
@overload
def softplus(x: onp.ToInt, *, out: None, dtype: None = None, **kwds: Unpack[_KwBase]) -> _f: ...
@overload
def softplus(x: onp.ToIntND, *, out: None, dtype: None = None, **kwds: Unpack[_KwBase]) -> _f_nd: ...
@overload
def softplus(x: _SCT_f, *, out: None = None, dtype: onp.ToDType[_SCT_f] | None = None, **kwds: Unpack[_KwBase]) -> _SCT_f: ...
@overload
def softplus(x: onp.ToFloat, *, out: None, dtype: onp.ToDType[_SCT_f], **kwds: Unpack[_KwBase]) -> _SCT_f: ...
@overload
def softplus(
    x: onp.ToFloat, *, out: None, dtype: onp.AnyFloatingDType | None = None, **kwds: Unpack[_KwBase]
) -> npc.floating: ...
@overload
def softplus(
    x: onp.ToJustFloat64Strict1D, *, out: None = None, dtype: onp.AnyFloat64DType | None = None, **kwds: Unpack[_KwBase]
) -> _f8_1d: ...
@overload
def softplus(
    x: onp.ToJustFloat64Strict2D, *, out: None = None, dtype: onp.AnyFloat64DType | None = None, **kwds: Unpack[_KwBase]
) -> onp.Array2D[_f8]: ...
@overload
def softplus(
    x: onp.ToJustFloat64Strict3D, *, out: None = None, dtype: onp.AnyFloat64DType | None = None, **kwds: Unpack[_KwBase]
) -> onp.Array3D[_f8]: ...
@overload
def softplus(
    x: onp.ToJustFloat64_ND, *, out: None = None, dtype: onp.AnyFloat64DType | None = None, **kwds: Unpack[_KwBase]
) -> _f8_nd: ...
@overload
def softplus(
    x: onp.CanArrayND[_SCT_f, _ShapeT], *, out: None = None, dtype: onp.ToDType[_SCT_f] | None = None, **kwds: Unpack[_KwBase]
) -> onp.ArrayND[_SCT_f, _ShapeT]: ...
@overload
def softplus(
    x: onp.ToFloatND, *, out: None = None, dtype: onp.ToDType[_SCT_f], **kwds: Unpack[_KwBase]
) -> onp.ArrayND[_SCT_f]: ...
@overload
def softplus(
    x: onp.ToFloatND, *, out: None, dtype: onp.AnyFloatingDType | None = None, **kwds: Unpack[_KwBase]
) -> onp.ArrayND[npc.floating]: ...
