# NOTE(scipy-stubs): This private module should not be used outside of scipy-stubs

import abc
from typing import Any, Generic, Literal, Self, TypeAlias, final, type_check_only
from typing_extensions import TypeVar, TypeVarTuple

__all__ = "Alternative", "BaseBunch", "BunchMixin", "NanPolicy", "PowerDivergenceStatistic"

_Ts = TypeVarTuple("_Ts")
_ValueT = TypeVar("_ValueT")
_TupleT_co = TypeVar("_TupleT_co", bound=tuple[object, ...], default=tuple[Any, ...], covariant=True)

Alternative: TypeAlias = Literal["two-sided", "less", "greater"]
NanPolicy: TypeAlias = Literal["raise", "propagate", "omit"]

PowerDivergenceStatistic: TypeAlias = Literal[
    "pearson",
    "log-likelihood",
    "freeman-tukey",
    "mod-log-likelihood",
    "neyman",
    "cressie-read",
]  # fmt: skip

# A helper mixin for annotating "bunch" result types generated by `scipy._lib.bunch._make_tuple_bunch`.
#
# - Subtypes of `BunchMixin[tuple[*Ts]]` MUST additionally subclass `tuple[*Ts]`
# - Subtypes MUST implement:
#   * `def __new__(_cls, {fields}, *, {extra_fields}) -> Self: ...`
#   * `def __init__(self, /, {fields}, *, {extra_fields}) -> None: ...`
# - The `_cls` parameter in `__new__` must be kept as-is, so not pos-only.
# - Each field in `{fields}` and `{extra_fields}` must be implemented as a (read-only) `@property`
# - The (variadic) generic type parameters coorespond to the types of `{fields}`, **not** `{extra_fields}`
@type_check_only
class BunchMixin(Generic[_TupleT_co]):
    @abc.abstractmethod  # (_cls, {fields}, *, {extra_fields}) -> Self
    def __new__(_cls) -> Self: ...
    @abc.abstractmethod  # (self, /, {fields}, *, {extra_fields}) -> None
    def __init__(self, /) -> None: ...
    @final
    def __getnewargs_ex__(self: BunchMixin[tuple[_ValueT, ...]], /) -> tuple[_TupleT_co, dict[str, _ValueT]]: ...

    # NOTE: `._fields` and `._extra_fields` are mutually exclusive (i.e. disjoint)
    @property
    def _fields(self, /) -> tuple[str, ...]: ...
    @property
    def _extra_fields(self, /) -> tuple[str, ...]: ...

    # NOTE: `._asdict()` includes both `{fields}` and `{extra_fields}`
    def _asdict(self: BunchMixin[tuple[_ValueT, ...]], /) -> dict[str, _ValueT]: ...

@type_check_only
class BaseBunch(tuple[*_Ts], BunchMixin[tuple[*_Ts]], Generic[*_Ts]):
    @abc.abstractmethod
    def __new__(_cls) -> Self: ...
    @abc.abstractmethod
    def __init__(self, /) -> None: ...
