# src/team_digest/_footer.py
from __future__ import annotations
from importlib import metadata

def append_footer(markdown: str, fmt: str = "md") -> str:
    """Append a small generator/version footer to Markdown or JSON-bound content."""
    try:
        dist = metadata.version("team-digest")
    except Exception:
        dist = "unknown"
    footer = f"\n\n---\n_Digest generated by team-digest v{dist} (https://pypi.org/project/team-digest/)_\n"
    return markdown.rstrip() + footer
