import sys
from collections.abc import Collection, Iterator
from typing import Any, Generic, Protocol, TypeVar

from cognite.client import CogniteClient

if sys.version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


class ResourceRequestProtocol(Protocol):
    @classmethod
    def _load(cls, data: dict[str, Any]) -> Self: ...

    def dump(self, camel_case: bool = True) -> dict[str, Any]: ...


class ResourceResponseProtocol(Protocol):
    def as_write(self) -> ResourceRequestProtocol: ...


T_ResourceRequest = TypeVar("T_ResourceRequest", bound=ResourceRequestProtocol)
T_ResourceResponse = TypeVar("T_ResourceResponse", bound=ResourceResponseProtocol)


class ResourceRequestListProtocol(Protocol, Generic[T_ResourceRequest]):
    def __init__(self, collection: Collection[T_ResourceRequest]): ...

    def __getitem__(self, index: int) -> T_ResourceRequest: ...

    def __setitem__(self, index: int, value: T_ResourceRequest) -> None: ...

    def __delitem__(self, index: int) -> None: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[T_ResourceRequest]: ...

    def __contains__(self, value: object) -> bool: ...

    def __reversed__(self) -> Iterator[T_ResourceRequest]: ...

    def insert(self, index: int, value: T_ResourceRequest) -> None: ...

    def append(self, value: T_ResourceRequest) -> None: ...

    def extend(self, values: Collection[T_ResourceRequest]) -> None: ...

    def pop(self, index: int = -1) -> T_ResourceRequest: ...

    def remove(self, value: T_ResourceRequest) -> None: ...

    def clear(self) -> None: ...

    @classmethod
    def load(cls, data: list[dict[str, Any]], cognite_client: CogniteClient | None = None) -> Self: ...


class ResourceResponseListProtocol(Protocol, Generic[T_ResourceResponse]):
    def __init__(self, collection: Collection[T_ResourceResponse]): ...

    def __getitem__(self, index: int) -> T_ResourceResponse: ...

    def __setitem__(self, index: int, value: T_ResourceResponse) -> None: ...

    def __delitem__(self, index: int) -> None: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[T_ResourceResponse]: ...

    def __contains__(self, value: object) -> bool: ...

    def __reversed__(self) -> Iterator[T_ResourceResponse]: ...

    def insert(self, index: int, value: T_ResourceResponse) -> None: ...

    def append(self, value: T_ResourceResponse) -> None: ...

    def extend(self, values: Collection[T_ResourceResponse]) -> None: ...

    def pop(self, index: int = -1) -> T_ResourceResponse: ...

    def remove(self, value: T_ResourceResponse) -> None: ...

    def clear(self) -> None: ...

    def as_write(self) -> ResourceRequestListProtocol: ...

    @classmethod
    def load(cls, data: list[dict[str, Any]], cognite_client: CogniteClient | None = None) -> Self: ...


T_ResourceRequestList = TypeVar("T_ResourceRequestList", bound=ResourceRequestListProtocol)
T_ResourceResponseList = TypeVar("T_ResourceResponseList", bound=ResourceResponseListProtocol)
