# qdown

A Python client for downloading files from QualitegDrive operated by Qualiteg Inc.

[Japanese](README.ja.md)

## Install

```
pip install qdown
```

or

```
pip install git+https://github.com/qualiteg/qdown.git
```

## Usage

```
qdown ID [options]

Options:
  -O FILENAME     Specify output filename
  -o DIR          Specify output directory
  -s SERVER       Specify server URL (default: https://drive.qualiteg.com)
  -q, --quiet     Hide progress display
  --skip-check    Skip file existence check (fastest download)
  --use-head      Use HEAD request (legacy behavior)
  -h, --help      Display help
```

### New Features (v1.1+)

Enhanced support for large files and improved performance:

**New Options:**
- `--skip-check`: Skip file existence verification for fastest download (recommended for large files)
- `--use-head`: Use HEAD request method (default is disabled to prevent timeouts)

**Improvements:**
- HEAD requests are now skipped by default (resolves timeout issues with large files)
- File existence verification via `/file/{id}` endpoint (more reliable)

## Download Examples

### Example 1: Basic Download
```
qdown xxxxxxxxxxxxx -O my_file.txt
```

### Example 2: From Your Original HTTP Server
```
qdown xxxxxxxxxxxxx -O my_file.txt -s http://host.docker.internal:3000
```

### Example 3: Fast Download for Large Files (v1.1+)
```
# Skip all checks for maximum speed
qdown xxxxxxxxxxxxx -O large_file.zip --skip-check

# Silent mode with skip check
qdown xxxxxxxxxxxxx -O huge_file.zip --skip-check -q
```

### Example 4: Legacy Behavior (v1.1+)
```
# Use traditional HEAD request (if needed for compatibility)
qdown xxxxxxxxxxxxx -O file.txt --use-head
```

## Python API

```python
import qdown

# Basic download
file_path = qdown.download("file_id_here")

# Download with output filename
file_path = qdown.download("file_id_here", output_path="my_file.txt")

# Download from custom server
file_path = qdown.download(
    "file_id_here",
    output_path="my_file.txt",
    server_url="http://localhost:3000"
)

# Fast download for large files (v1.1+)
file_path = qdown.download(
    "file_id_here",
    output_path="large_file.zip",
    skip_exists_check=True,  # Skip existence check
    skip_head=True,          # Skip HEAD request (default)
    quiet=True               # Silent mode
)

# Use legacy behavior (v1.1+)
file_path = qdown.download(
    "file_id_here",
    skip_head=False  # Enable HEAD request
)
```

### New Parameters (v1.1+)
- `skip_exists_check`: Skip file existence verification (default: False)
- `skip_head`: Skip HEAD request (default: True)

## Uninstall

```
pip uninstall qdown -y
```