# coding: utf-8

# flake8: noqa

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

__version__ = "1.0.0"

# Define package exports
__all__ = [
    "SlurmApi",
    "SlurmdbApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "Account",
    "AccountShort",
    "Accounting",
    "AccountsAddCond",
    "AcctGatherEnergy",
    "Assoc",
    "AssocRecSet",
    "AssocSharesObjWrap",
    "AssocShort",
    "BfExitFields",
    "ClusterRec",
    "ControllerPing",
    "Coord",
    "CronEntry",
    "Float64NoVal",
    "Instance",
    "Job",
    "JobArrayResponseMsgEntry",
    "JobDescMsg",
    "JobInfo",
    "JobRes",
    "JobSubmitReq",
    "JobSubmitResponseMsg",
    "KillJobsMsg",
    "KillJobsRespJob",
    "License",
    "Node",
    "OpenAPIAccountsAddCondResp",
    "OpenAPIAccountsAddCondRespStr",
    "OpenAPIAccountsRemovedResp",
    "OpenAPIAccountsResp",
    "OpenAPIAssocsRemovedResp",
    "OpenAPIAssocsResp",
    "OpenAPIClustersRemovedResp",
    "OpenAPIClustersResp",
    "OpenAPIDiagResp",
    "OpenAPIError",
    "OpenAPIInstancesResp",
    "OpenAPIJobInfoResp",
    "OpenAPIJobPostResponse",
    "OpenAPIJobSubmitResponse",
    "OpenAPIKillJobsResp",
    "OpenAPILicensesResp",
    "OpenAPIMeta",
    "OpenAPINodesResp",
    "OpenAPIPartitionResp",
    "OpenAPIPingArrayResp",
    "OpenAPIReservationResp",
    "OpenAPIResp",
    "OpenAPISharesResp",
    "OpenAPISlurmdbdConfigResp",
    "OpenAPISlurmdbdJobsResp",
    "OpenAPISlurmdbdQosRemovedResp",
    "OpenAPISlurmdbdQosResp",
    "OpenAPISlurmdbdStatsResp",
    "OpenAPITresResp",
    "OpenAPIUsersAddCondResp",
    "OpenAPIUsersAddCondRespStr",
    "OpenAPIUsersResp",
    "OpenAPIWarning",
    "OpenAPIWckeyRemovedResp",
    "OpenAPIWckeyResp",
    "PartitionInfo",
    "ProcessExitCodeVerbose",
    "Qos",
    "ReservationCoreSpec",
    "ReservationInfo",
    "ScheduleExitFields",
    "SharesFloat128Tres",
    "SharesRespMsg",
    "SharesUint64Tres",
    "StatsMsg",
    "StatsRec",
    "StatsRpc",
    "StatsUser",
    "Step",
    "Tres",
    "Uint16NoVal",
    "Uint32NoVal",
    "Uint64NoVal",
    "UpdateNodeMsg",
    "User",
    "UserShort",
    "UsersAddCond",
    "V0040AccountingAllocated",
    "V0040AssocDefault",
    "V0040AssocMax",
    "V0040AssocMaxJobs",
    "V0040AssocMaxJobsPer",
    "V0040AssocMaxPer",
    "V0040AssocMaxPerAccount",
    "V0040AssocMaxTres",
    "V0040AssocMaxTresGroup",
    "V0040AssocMaxTresMinutes",
    "V0040AssocMaxTresPer",
    "V0040AssocMin",
    "V0040AssocSharesObjWrapFairshare",
    "V0040AssocSharesObjWrapTres",
    "V0040ClusterRecAssociations",
    "V0040ClusterRecController",
    "V0040CronEntryLine",
    "V0040InstanceTime",
    "V0040JobArray",
    "V0040JobArrayLimits",
    "V0040JobArrayLimitsMax",
    "V0040JobArrayLimitsMaxRunning",
    "V0040JobComment",
    "V0040JobDescMsgRlimits",
    "V0040JobHet",
    "V0040JobInfoPower",
    "V0040JobMcs",
    "V0040JobRequired",
    "V0040JobReservation",
    "V0040JobState",
    "V0040JobTime",
    "V0040JobTimeSystem",
    "V0040JobTimeTotal",
    "V0040JobTimeUser",
    "V0040JobTres",
    "V0040KillJobsRespJobError",
    "V0040KillJobsRespJobFederation",
    "V0040OpenapiMetaClient",
    "V0040OpenapiMetaPlugin",
    "V0040OpenapiMetaSlurm",
    "V0040OpenapiMetaSlurmVersion",
    "V0040PartitionInfoAccounts",
    "V0040PartitionInfoCpus",
    "V0040PartitionInfoDefaults",
    "V0040PartitionInfoGroups",
    "V0040PartitionInfoMaximums",
    "V0040PartitionInfoMaximumsOversubscribe",
    "V0040PartitionInfoMinimums",
    "V0040PartitionInfoNodes",
    "V0040PartitionInfoPartition",
    "V0040PartitionInfoPriority",
    "V0040PartitionInfoQos",
    "V0040PartitionInfoTimeouts",
    "V0040PartitionInfoTres",
    "V0040ProcessExitCodeVerboseSignal",
    "V0040QosLimits",
    "V0040QosLimitsMax",
    "V0040QosLimitsMaxActiveJobs",
    "V0040QosLimitsMaxJobs",
    "V0040QosLimitsMaxJobsActiveJobs",
    "V0040QosLimitsMaxJobsActiveJobsPer",
    "V0040QosLimitsMaxTres",
    "V0040QosLimitsMaxTresMinutes",
    "V0040QosLimitsMaxTresMinutesPer",
    "V0040QosLimitsMaxTresPer",
    "V0040QosLimitsMaxWallClock",
    "V0040QosLimitsMaxWallClockPer",
    "V0040QosLimitsMin",
    "V0040QosLimitsMinTres",
    "V0040QosLimitsMinTresPer",
    "V0040QosPreempt",
    "V0040ReservationInfoPurgeCompleted",
    "V0040RollupStatsInner",
    "V0040StatsMsgRpcsByTypeInner",
    "V0040StatsMsgRpcsByUserInner",
    "V0040StatsRpcTime",
    "V0040StepCPU",
    "V0040StepCPURequestedFrequency",
    "V0040StepNodes",
    "V0040StepStatistics",
    "V0040StepStatisticsCPU",
    "V0040StepStatisticsEnergy",
    "V0040StepStep",
    "V0040StepTask",
    "V0040StepTasks",
    "V0040StepTime",
    "V0040StepTimeSystem",
    "V0040StepTimeTotal",
    "V0040StepTimeUser",
    "V0040StepTres",
    "V0040StepTresConsumed",
    "V0040StepTresRequested",
    "V0040UserDefault",
    "Wckey",
    "WckeyTagStruct",
]

# import apis into sdk package
from slurpy.v0040.asyncio.api.slurm_api import SlurmApi as SlurmApi
from slurpy.v0040.asyncio.api.slurmdb_api import SlurmdbApi as SlurmdbApi

# import ApiClient
from slurpy.v0040.asyncio.api_response import ApiResponse as ApiResponse
from slurpy.v0040.asyncio.api_client import ApiClient as ApiClient
from slurpy.v0040.asyncio.configuration import Configuration as Configuration
from slurpy.v0040.asyncio.exceptions import OpenApiException as OpenApiException
from slurpy.v0040.asyncio.exceptions import ApiTypeError as ApiTypeError
from slurpy.v0040.asyncio.exceptions import ApiValueError as ApiValueError
from slurpy.v0040.asyncio.exceptions import ApiKeyError as ApiKeyError
from slurpy.v0040.asyncio.exceptions import ApiAttributeError as ApiAttributeError
from slurpy.v0040.asyncio.exceptions import ApiException as ApiException

# import models into sdk package
from slurpy.v0040.asyncio.models.account import Account as Account
from slurpy.v0040.asyncio.models.account_short import AccountShort as AccountShort
from slurpy.v0040.asyncio.models.accounting import Accounting as Accounting
from slurpy.v0040.asyncio.models.accounts_add_cond import (
    AccountsAddCond as AccountsAddCond,
)
from slurpy.v0040.asyncio.models.acct_gather_energy import (
    AcctGatherEnergy as AcctGatherEnergy,
)
from slurpy.v0040.asyncio.models.assoc import Assoc as Assoc
from slurpy.v0040.asyncio.models.assoc_rec_set import AssocRecSet as AssocRecSet
from slurpy.v0040.asyncio.models.assoc_shares_obj_wrap import (
    AssocSharesObjWrap as AssocSharesObjWrap,
)
from slurpy.v0040.asyncio.models.assoc_short import AssocShort as AssocShort
from slurpy.v0040.asyncio.models.bf_exit_fields import BfExitFields as BfExitFields
from slurpy.v0040.asyncio.models.cluster_rec import ClusterRec as ClusterRec
from slurpy.v0040.asyncio.models.controller_ping import ControllerPing as ControllerPing
from slurpy.v0040.asyncio.models.coord import Coord as Coord
from slurpy.v0040.asyncio.models.cron_entry import CronEntry as CronEntry
from slurpy.v0040.asyncio.models.float64_no_val import Float64NoVal as Float64NoVal
from slurpy.v0040.asyncio.models.instance import Instance as Instance
from slurpy.v0040.asyncio.models.job import Job as Job
from slurpy.v0040.asyncio.models.job_array_response_msg_entry import (
    JobArrayResponseMsgEntry as JobArrayResponseMsgEntry,
)
from slurpy.v0040.asyncio.models.job_desc_msg import JobDescMsg as JobDescMsg
from slurpy.v0040.asyncio.models.job_info import JobInfo as JobInfo
from slurpy.v0040.asyncio.models.job_res import JobRes as JobRes
from slurpy.v0040.asyncio.models.job_submit_req import JobSubmitReq as JobSubmitReq
from slurpy.v0040.asyncio.models.job_submit_response_msg import (
    JobSubmitResponseMsg as JobSubmitResponseMsg,
)
from slurpy.v0040.asyncio.models.kill_jobs_msg import KillJobsMsg as KillJobsMsg
from slurpy.v0040.asyncio.models.kill_jobs_resp_job import (
    KillJobsRespJob as KillJobsRespJob,
)
from slurpy.v0040.asyncio.models.license import License as License
from slurpy.v0040.asyncio.models.node import Node as Node
from slurpy.v0040.asyncio.models.open_api_accounts_add_cond_resp import (
    OpenAPIAccountsAddCondResp as OpenAPIAccountsAddCondResp,
)
from slurpy.v0040.asyncio.models.open_api_accounts_add_cond_resp_str import (
    OpenAPIAccountsAddCondRespStr as OpenAPIAccountsAddCondRespStr,
)
from slurpy.v0040.asyncio.models.open_api_accounts_removed_resp import (
    OpenAPIAccountsRemovedResp as OpenAPIAccountsRemovedResp,
)
from slurpy.v0040.asyncio.models.open_api_accounts_resp import (
    OpenAPIAccountsResp as OpenAPIAccountsResp,
)
from slurpy.v0040.asyncio.models.open_api_assocs_removed_resp import (
    OpenAPIAssocsRemovedResp as OpenAPIAssocsRemovedResp,
)
from slurpy.v0040.asyncio.models.open_api_assocs_resp import (
    OpenAPIAssocsResp as OpenAPIAssocsResp,
)
from slurpy.v0040.asyncio.models.open_api_clusters_removed_resp import (
    OpenAPIClustersRemovedResp as OpenAPIClustersRemovedResp,
)
from slurpy.v0040.asyncio.models.open_api_clusters_resp import (
    OpenAPIClustersResp as OpenAPIClustersResp,
)
from slurpy.v0040.asyncio.models.open_api_diag_resp import (
    OpenAPIDiagResp as OpenAPIDiagResp,
)
from slurpy.v0040.asyncio.models.open_api_error import OpenAPIError as OpenAPIError
from slurpy.v0040.asyncio.models.open_api_instances_resp import (
    OpenAPIInstancesResp as OpenAPIInstancesResp,
)
from slurpy.v0040.asyncio.models.open_api_job_info_resp import (
    OpenAPIJobInfoResp as OpenAPIJobInfoResp,
)
from slurpy.v0040.asyncio.models.open_api_job_post_response import (
    OpenAPIJobPostResponse as OpenAPIJobPostResponse,
)
from slurpy.v0040.asyncio.models.open_api_job_submit_response import (
    OpenAPIJobSubmitResponse as OpenAPIJobSubmitResponse,
)
from slurpy.v0040.asyncio.models.open_api_kill_jobs_resp import (
    OpenAPIKillJobsResp as OpenAPIKillJobsResp,
)
from slurpy.v0040.asyncio.models.open_api_licenses_resp import (
    OpenAPILicensesResp as OpenAPILicensesResp,
)
from slurpy.v0040.asyncio.models.open_api_meta import OpenAPIMeta as OpenAPIMeta
from slurpy.v0040.asyncio.models.open_api_nodes_resp import (
    OpenAPINodesResp as OpenAPINodesResp,
)
from slurpy.v0040.asyncio.models.open_api_partition_resp import (
    OpenAPIPartitionResp as OpenAPIPartitionResp,
)
from slurpy.v0040.asyncio.models.open_api_ping_array_resp import (
    OpenAPIPingArrayResp as OpenAPIPingArrayResp,
)
from slurpy.v0040.asyncio.models.open_api_reservation_resp import (
    OpenAPIReservationResp as OpenAPIReservationResp,
)
from slurpy.v0040.asyncio.models.open_api_resp import OpenAPIResp as OpenAPIResp
from slurpy.v0040.asyncio.models.open_api_shares_resp import (
    OpenAPISharesResp as OpenAPISharesResp,
)
from slurpy.v0040.asyncio.models.open_api_slurmdbd_config_resp import (
    OpenAPISlurmdbdConfigResp as OpenAPISlurmdbdConfigResp,
)
from slurpy.v0040.asyncio.models.open_api_slurmdbd_jobs_resp import (
    OpenAPISlurmdbdJobsResp as OpenAPISlurmdbdJobsResp,
)
from slurpy.v0040.asyncio.models.open_api_slurmdbd_qos_removed_resp import (
    OpenAPISlurmdbdQosRemovedResp as OpenAPISlurmdbdQosRemovedResp,
)
from slurpy.v0040.asyncio.models.open_api_slurmdbd_qos_resp import (
    OpenAPISlurmdbdQosResp as OpenAPISlurmdbdQosResp,
)
from slurpy.v0040.asyncio.models.open_api_slurmdbd_stats_resp import (
    OpenAPISlurmdbdStatsResp as OpenAPISlurmdbdStatsResp,
)
from slurpy.v0040.asyncio.models.open_api_tres_resp import (
    OpenAPITresResp as OpenAPITresResp,
)
from slurpy.v0040.asyncio.models.open_api_users_add_cond_resp import (
    OpenAPIUsersAddCondResp as OpenAPIUsersAddCondResp,
)
from slurpy.v0040.asyncio.models.open_api_users_add_cond_resp_str import (
    OpenAPIUsersAddCondRespStr as OpenAPIUsersAddCondRespStr,
)
from slurpy.v0040.asyncio.models.open_api_users_resp import (
    OpenAPIUsersResp as OpenAPIUsersResp,
)
from slurpy.v0040.asyncio.models.open_api_warning import (
    OpenAPIWarning as OpenAPIWarning,
)
from slurpy.v0040.asyncio.models.open_api_wckey_removed_resp import (
    OpenAPIWckeyRemovedResp as OpenAPIWckeyRemovedResp,
)
from slurpy.v0040.asyncio.models.open_api_wckey_resp import (
    OpenAPIWckeyResp as OpenAPIWckeyResp,
)
from slurpy.v0040.asyncio.models.partition_info import PartitionInfo as PartitionInfo
from slurpy.v0040.asyncio.models.process_exit_code_verbose import (
    ProcessExitCodeVerbose as ProcessExitCodeVerbose,
)
from slurpy.v0040.asyncio.models.qos import Qos as Qos
from slurpy.v0040.asyncio.models.reservation_core_spec import (
    ReservationCoreSpec as ReservationCoreSpec,
)
from slurpy.v0040.asyncio.models.reservation_info import (
    ReservationInfo as ReservationInfo,
)
from slurpy.v0040.asyncio.models.schedule_exit_fields import (
    ScheduleExitFields as ScheduleExitFields,
)
from slurpy.v0040.asyncio.models.shares_float128_tres import (
    SharesFloat128Tres as SharesFloat128Tres,
)
from slurpy.v0040.asyncio.models.shares_resp_msg import SharesRespMsg as SharesRespMsg
from slurpy.v0040.asyncio.models.shares_uint64_tres import (
    SharesUint64Tres as SharesUint64Tres,
)
from slurpy.v0040.asyncio.models.stats_msg import StatsMsg as StatsMsg
from slurpy.v0040.asyncio.models.stats_rec import StatsRec as StatsRec
from slurpy.v0040.asyncio.models.stats_rpc import StatsRpc as StatsRpc
from slurpy.v0040.asyncio.models.stats_user import StatsUser as StatsUser
from slurpy.v0040.asyncio.models.step import Step as Step
from slurpy.v0040.asyncio.models.tres import Tres as Tres
from slurpy.v0040.asyncio.models.uint16_no_val import Uint16NoVal as Uint16NoVal
from slurpy.v0040.asyncio.models.uint32_no_val import Uint32NoVal as Uint32NoVal
from slurpy.v0040.asyncio.models.uint64_no_val import Uint64NoVal as Uint64NoVal
from slurpy.v0040.asyncio.models.update_node_msg import UpdateNodeMsg as UpdateNodeMsg
from slurpy.v0040.asyncio.models.user import User as User
from slurpy.v0040.asyncio.models.user_short import UserShort as UserShort
from slurpy.v0040.asyncio.models.users_add_cond import UsersAddCond as UsersAddCond
from slurpy.v0040.asyncio.models.v0040_accounting_allocated import (
    V0040AccountingAllocated as V0040AccountingAllocated,
)
from slurpy.v0040.asyncio.models.v0040_assoc_default import (
    V0040AssocDefault as V0040AssocDefault,
)
from slurpy.v0040.asyncio.models.v0040_assoc_max import V0040AssocMax as V0040AssocMax
from slurpy.v0040.asyncio.models.v0040_assoc_max_jobs import (
    V0040AssocMaxJobs as V0040AssocMaxJobs,
)
from slurpy.v0040.asyncio.models.v0040_assoc_max_jobs_per import (
    V0040AssocMaxJobsPer as V0040AssocMaxJobsPer,
)
from slurpy.v0040.asyncio.models.v0040_assoc_max_per import (
    V0040AssocMaxPer as V0040AssocMaxPer,
)
from slurpy.v0040.asyncio.models.v0040_assoc_max_per_account import (
    V0040AssocMaxPerAccount as V0040AssocMaxPerAccount,
)
from slurpy.v0040.asyncio.models.v0040_assoc_max_tres import (
    V0040AssocMaxTres as V0040AssocMaxTres,
)
from slurpy.v0040.asyncio.models.v0040_assoc_max_tres_group import (
    V0040AssocMaxTresGroup as V0040AssocMaxTresGroup,
)
from slurpy.v0040.asyncio.models.v0040_assoc_max_tres_minutes import (
    V0040AssocMaxTresMinutes as V0040AssocMaxTresMinutes,
)
from slurpy.v0040.asyncio.models.v0040_assoc_max_tres_per import (
    V0040AssocMaxTresPer as V0040AssocMaxTresPer,
)
from slurpy.v0040.asyncio.models.v0040_assoc_min import V0040AssocMin as V0040AssocMin
from slurpy.v0040.asyncio.models.v0040_assoc_shares_obj_wrap_fairshare import (
    V0040AssocSharesObjWrapFairshare as V0040AssocSharesObjWrapFairshare,
)
from slurpy.v0040.asyncio.models.v0040_assoc_shares_obj_wrap_tres import (
    V0040AssocSharesObjWrapTres as V0040AssocSharesObjWrapTres,
)
from slurpy.v0040.asyncio.models.v0040_cluster_rec_associations import (
    V0040ClusterRecAssociations as V0040ClusterRecAssociations,
)
from slurpy.v0040.asyncio.models.v0040_cluster_rec_controller import (
    V0040ClusterRecController as V0040ClusterRecController,
)
from slurpy.v0040.asyncio.models.v0040_cron_entry_line import (
    V0040CronEntryLine as V0040CronEntryLine,
)
from slurpy.v0040.asyncio.models.v0040_instance_time import (
    V0040InstanceTime as V0040InstanceTime,
)
from slurpy.v0040.asyncio.models.v0040_job_array import V0040JobArray as V0040JobArray
from slurpy.v0040.asyncio.models.v0040_job_array_limits import (
    V0040JobArrayLimits as V0040JobArrayLimits,
)
from slurpy.v0040.asyncio.models.v0040_job_array_limits_max import (
    V0040JobArrayLimitsMax as V0040JobArrayLimitsMax,
)
from slurpy.v0040.asyncio.models.v0040_job_array_limits_max_running import (
    V0040JobArrayLimitsMaxRunning as V0040JobArrayLimitsMaxRunning,
)
from slurpy.v0040.asyncio.models.v0040_job_comment import (
    V0040JobComment as V0040JobComment,
)
from slurpy.v0040.asyncio.models.v0040_job_desc_msg_rlimits import (
    V0040JobDescMsgRlimits as V0040JobDescMsgRlimits,
)
from slurpy.v0040.asyncio.models.v0040_job_het import V0040JobHet as V0040JobHet
from slurpy.v0040.asyncio.models.v0040_job_info_power import (
    V0040JobInfoPower as V0040JobInfoPower,
)
from slurpy.v0040.asyncio.models.v0040_job_mcs import V0040JobMcs as V0040JobMcs
from slurpy.v0040.asyncio.models.v0040_job_required import (
    V0040JobRequired as V0040JobRequired,
)
from slurpy.v0040.asyncio.models.v0040_job_reservation import (
    V0040JobReservation as V0040JobReservation,
)
from slurpy.v0040.asyncio.models.v0040_job_state import V0040JobState as V0040JobState
from slurpy.v0040.asyncio.models.v0040_job_time import V0040JobTime as V0040JobTime
from slurpy.v0040.asyncio.models.v0040_job_time_system import (
    V0040JobTimeSystem as V0040JobTimeSystem,
)
from slurpy.v0040.asyncio.models.v0040_job_time_total import (
    V0040JobTimeTotal as V0040JobTimeTotal,
)
from slurpy.v0040.asyncio.models.v0040_job_time_user import (
    V0040JobTimeUser as V0040JobTimeUser,
)
from slurpy.v0040.asyncio.models.v0040_job_tres import V0040JobTres as V0040JobTres
from slurpy.v0040.asyncio.models.v0040_kill_jobs_resp_job_error import (
    V0040KillJobsRespJobError as V0040KillJobsRespJobError,
)
from slurpy.v0040.asyncio.models.v0040_kill_jobs_resp_job_federation import (
    V0040KillJobsRespJobFederation as V0040KillJobsRespJobFederation,
)
from slurpy.v0040.asyncio.models.v0040_openapi_meta_client import (
    V0040OpenapiMetaClient as V0040OpenapiMetaClient,
)
from slurpy.v0040.asyncio.models.v0040_openapi_meta_plugin import (
    V0040OpenapiMetaPlugin as V0040OpenapiMetaPlugin,
)
from slurpy.v0040.asyncio.models.v0040_openapi_meta_slurm import (
    V0040OpenapiMetaSlurm as V0040OpenapiMetaSlurm,
)
from slurpy.v0040.asyncio.models.v0040_openapi_meta_slurm_version import (
    V0040OpenapiMetaSlurmVersion as V0040OpenapiMetaSlurmVersion,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_accounts import (
    V0040PartitionInfoAccounts as V0040PartitionInfoAccounts,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_cpus import (
    V0040PartitionInfoCpus as V0040PartitionInfoCpus,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_defaults import (
    V0040PartitionInfoDefaults as V0040PartitionInfoDefaults,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_groups import (
    V0040PartitionInfoGroups as V0040PartitionInfoGroups,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_maximums import (
    V0040PartitionInfoMaximums as V0040PartitionInfoMaximums,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_maximums_oversubscribe import (
    V0040PartitionInfoMaximumsOversubscribe as V0040PartitionInfoMaximumsOversubscribe,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_minimums import (
    V0040PartitionInfoMinimums as V0040PartitionInfoMinimums,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_nodes import (
    V0040PartitionInfoNodes as V0040PartitionInfoNodes,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_partition import (
    V0040PartitionInfoPartition as V0040PartitionInfoPartition,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_priority import (
    V0040PartitionInfoPriority as V0040PartitionInfoPriority,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_qos import (
    V0040PartitionInfoQos as V0040PartitionInfoQos,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_timeouts import (
    V0040PartitionInfoTimeouts as V0040PartitionInfoTimeouts,
)
from slurpy.v0040.asyncio.models.v0040_partition_info_tres import (
    V0040PartitionInfoTres as V0040PartitionInfoTres,
)
from slurpy.v0040.asyncio.models.v0040_process_exit_code_verbose_signal import (
    V0040ProcessExitCodeVerboseSignal as V0040ProcessExitCodeVerboseSignal,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits import (
    V0040QosLimits as V0040QosLimits,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max import (
    V0040QosLimitsMax as V0040QosLimitsMax,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_active_jobs import (
    V0040QosLimitsMaxActiveJobs as V0040QosLimitsMaxActiveJobs,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_jobs import (
    V0040QosLimitsMaxJobs as V0040QosLimitsMaxJobs,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_jobs_active_jobs import (
    V0040QosLimitsMaxJobsActiveJobs as V0040QosLimitsMaxJobsActiveJobs,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_jobs_active_jobs_per import (
    V0040QosLimitsMaxJobsActiveJobsPer as V0040QosLimitsMaxJobsActiveJobsPer,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_tres import (
    V0040QosLimitsMaxTres as V0040QosLimitsMaxTres,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_tres_minutes import (
    V0040QosLimitsMaxTresMinutes as V0040QosLimitsMaxTresMinutes,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_tres_minutes_per import (
    V0040QosLimitsMaxTresMinutesPer as V0040QosLimitsMaxTresMinutesPer,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_tres_per import (
    V0040QosLimitsMaxTresPer as V0040QosLimitsMaxTresPer,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_wall_clock import (
    V0040QosLimitsMaxWallClock as V0040QosLimitsMaxWallClock,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_wall_clock_per import (
    V0040QosLimitsMaxWallClockPer as V0040QosLimitsMaxWallClockPer,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_min import (
    V0040QosLimitsMin as V0040QosLimitsMin,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_min_tres import (
    V0040QosLimitsMinTres as V0040QosLimitsMinTres,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_min_tres_per import (
    V0040QosLimitsMinTresPer as V0040QosLimitsMinTresPer,
)
from slurpy.v0040.asyncio.models.v0040_qos_preempt import (
    V0040QosPreempt as V0040QosPreempt,
)
from slurpy.v0040.asyncio.models.v0040_reservation_info_purge_completed import (
    V0040ReservationInfoPurgeCompleted as V0040ReservationInfoPurgeCompleted,
)
from slurpy.v0040.asyncio.models.v0040_rollup_stats_inner import (
    V0040RollupStatsInner as V0040RollupStatsInner,
)
from slurpy.v0040.asyncio.models.v0040_stats_msg_rpcs_by_type_inner import (
    V0040StatsMsgRpcsByTypeInner as V0040StatsMsgRpcsByTypeInner,
)
from slurpy.v0040.asyncio.models.v0040_stats_msg_rpcs_by_user_inner import (
    V0040StatsMsgRpcsByUserInner as V0040StatsMsgRpcsByUserInner,
)
from slurpy.v0040.asyncio.models.v0040_stats_rpc_time import (
    V0040StatsRpcTime as V0040StatsRpcTime,
)
from slurpy.v0040.asyncio.models.v0040_step_cpu import V0040StepCPU as V0040StepCPU
from slurpy.v0040.asyncio.models.v0040_step_cpu_requested_frequency import (
    V0040StepCPURequestedFrequency as V0040StepCPURequestedFrequency,
)
from slurpy.v0040.asyncio.models.v0040_step_nodes import (
    V0040StepNodes as V0040StepNodes,
)
from slurpy.v0040.asyncio.models.v0040_step_statistics import (
    V0040StepStatistics as V0040StepStatistics,
)
from slurpy.v0040.asyncio.models.v0040_step_statistics_cpu import (
    V0040StepStatisticsCPU as V0040StepStatisticsCPU,
)
from slurpy.v0040.asyncio.models.v0040_step_statistics_energy import (
    V0040StepStatisticsEnergy as V0040StepStatisticsEnergy,
)
from slurpy.v0040.asyncio.models.v0040_step_step import V0040StepStep as V0040StepStep
from slurpy.v0040.asyncio.models.v0040_step_task import V0040StepTask as V0040StepTask
from slurpy.v0040.asyncio.models.v0040_step_tasks import (
    V0040StepTasks as V0040StepTasks,
)
from slurpy.v0040.asyncio.models.v0040_step_time import V0040StepTime as V0040StepTime
from slurpy.v0040.asyncio.models.v0040_step_time_system import (
    V0040StepTimeSystem as V0040StepTimeSystem,
)
from slurpy.v0040.asyncio.models.v0040_step_time_total import (
    V0040StepTimeTotal as V0040StepTimeTotal,
)
from slurpy.v0040.asyncio.models.v0040_step_time_user import (
    V0040StepTimeUser as V0040StepTimeUser,
)
from slurpy.v0040.asyncio.models.v0040_step_tres import V0040StepTres as V0040StepTres
from slurpy.v0040.asyncio.models.v0040_step_tres_consumed import (
    V0040StepTresConsumed as V0040StepTresConsumed,
)
from slurpy.v0040.asyncio.models.v0040_step_tres_requested import (
    V0040StepTresRequested as V0040StepTresRequested,
)
from slurpy.v0040.asyncio.models.v0040_user_default import (
    V0040UserDefault as V0040UserDefault,
)
from slurpy.v0040.asyncio.models.wckey import Wckey as Wckey
from slurpy.v0040.asyncio.models.wckey_tag_struct import (
    WckeyTagStruct as WckeyTagStruct,
)
