# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0040.asyncio.models.v0040_instance_time import V0040InstanceTime
from typing import Set
from typing_extensions import Self


class Instance(BaseModel):
    """
    Instance
    """  # noqa: E501

    cluster: Optional[StrictStr] = Field(default=None, description="Cluster name")
    extra: Optional[StrictStr] = Field(
        default=None,
        description="Arbitrary string used for node filtering if extra constraints are enabled",
    )
    instance_id: Optional[StrictStr] = Field(
        default=None, description="Cloud instance ID"
    )
    instance_type: Optional[StrictStr] = Field(
        default=None, description="Cloud instance type"
    )
    node_name: Optional[StrictStr] = Field(default=None, description="NodeName")
    time: Optional[V0040InstanceTime] = None
    __properties: ClassVar[List[str]] = [
        "cluster",
        "extra",
        "instance_id",
        "instance_type",
        "node_name",
        "time",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Instance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict["time"] = self.time.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Instance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "cluster": obj.get("cluster"),
                "extra": obj.get("extra"),
                "instance_id": obj.get("instance_id"),
                "instance_type": obj.get("instance_type"),
                "node_name": obj.get("node_name"),
                "time": V0040InstanceTime.from_dict(obj["time"])
                if obj.get("time") is not None
                else None,
            }
        )
        return _obj
