# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class JobRes(BaseModel):
    """
    JobRes
    """  # noqa: E501

    nodes: Optional[StrictStr] = Field(
        default=None, description="Node(s) allocated to the job"
    )
    allocated_cores: Optional[StrictInt] = Field(
        default=None, description="Number of allocated cores"
    )
    allocated_cpus: Optional[StrictInt] = Field(
        default=None, description="Number of allocated CPUs"
    )
    allocated_hosts: Optional[StrictInt] = Field(
        default=None, description="Number of allocated hosts"
    )
    allocated_nodes: Optional[List[Any]] = Field(
        default=None, description="job node resources"
    )
    __properties: ClassVar[List[str]] = [
        "nodes",
        "allocated_cores",
        "allocated_cpus",
        "allocated_hosts",
        "allocated_nodes",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobRes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobRes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "nodes": obj.get("nodes"),
                "allocated_cores": obj.get("allocated_cores"),
                "allocated_cpus": obj.get("allocated_cpus"),
                "allocated_hosts": obj.get("allocated_hosts"),
                "allocated_nodes": obj.get("allocated_nodes"),
            }
        )
        return _obj
