# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0040.asyncio.models.bf_exit_fields import BfExitFields
from slurpy.v0040.asyncio.models.schedule_exit_fields import ScheduleExitFields
from slurpy.v0040.asyncio.models.uint64_no_val import Uint64NoVal
from slurpy.v0040.asyncio.models.v0040_stats_msg_rpcs_by_type_inner import (
    V0040StatsMsgRpcsByTypeInner,
)
from slurpy.v0040.asyncio.models.v0040_stats_msg_rpcs_by_user_inner import (
    V0040StatsMsgRpcsByUserInner,
)
from typing import Set
from typing_extensions import Self


class StatsMsg(BaseModel):
    """
    StatsMsg
    """  # noqa: E501

    parts_packed: Optional[StrictInt] = Field(
        default=None, description="Zero if only RPC statistic included"
    )
    req_time: Optional[Uint64NoVal] = None
    req_time_start: Optional[Uint64NoVal] = None
    server_thread_count: Optional[StrictInt] = Field(
        default=None, description="Number of current active slurmctld threads"
    )
    agent_queue_size: Optional[StrictInt] = Field(
        default=None,
        description="Number of enqueued outgoing RPC requests in an internal retry list",
    )
    agent_count: Optional[StrictInt] = Field(
        default=None, description="Number of agent threads"
    )
    agent_thread_count: Optional[StrictInt] = Field(
        default=None,
        description="Total number of active threads created by all agent threads",
    )
    dbd_agent_queue_size: Optional[StrictInt] = Field(
        default=None, description="Number of messages for SlurmDBD that are queued"
    )
    gettimeofday_latency: Optional[StrictInt] = Field(
        default=None,
        description="Latency of 1000 calls to the gettimeofday() syscall in microseconds, as measured at controller startup",
    )
    schedule_cycle_max: Optional[StrictInt] = Field(
        default=None,
        description="Max time of any scheduling cycle in microseconds since last reset",
    )
    schedule_cycle_last: Optional[StrictInt] = Field(
        default=None, description="Time in microseconds for last scheduling cycle"
    )
    schedule_cycle_total: Optional[StrictInt] = Field(
        default=None, description="Number of scheduling cycles since last reset"
    )
    schedule_cycle_mean: Optional[StrictInt] = Field(
        default=None,
        description="Mean time in microseconds for all scheduling cycles since last reset",
    )
    schedule_cycle_mean_depth: Optional[StrictInt] = Field(
        default=None,
        description="Mean of the number of jobs processed in a scheduling cycle",
    )
    schedule_cycle_per_minute: Optional[StrictInt] = Field(
        default=None, description="Number of scheduling executions per minute"
    )
    schedule_queue_length: Optional[StrictInt] = Field(
        default=None, description="Number of jobs pending in queue"
    )
    schedule_exit: Optional[ScheduleExitFields] = None
    jobs_submitted: Optional[StrictInt] = Field(
        default=None, description="Number of jobs submitted since last reset"
    )
    jobs_started: Optional[StrictInt] = Field(
        default=None, description="Number of jobs started since last reset"
    )
    jobs_completed: Optional[StrictInt] = Field(
        default=None, description="Number of jobs completed since last reset"
    )
    jobs_canceled: Optional[StrictInt] = Field(
        default=None, description="Number of jobs canceled since the last reset"
    )
    jobs_failed: Optional[StrictInt] = Field(
        default=None,
        description="Number of jobs failed due to slurmd or other internal issues since last reset",
    )
    jobs_pending: Optional[StrictInt] = Field(
        default=None,
        description="Number of jobs pending at the time of listed in job_state_ts",
    )
    jobs_running: Optional[StrictInt] = Field(
        default=None,
        description="Number of jobs running at the time of listed in job_state_ts",
    )
    job_states_ts: Optional[Uint64NoVal] = None
    bf_backfilled_jobs: Optional[StrictInt] = Field(
        default=None,
        description="Number of jobs started through backfilling since last slurm start",
    )
    bf_last_backfilled_jobs: Optional[StrictInt] = Field(
        default=None,
        description="Number of jobs started through backfilling since last reset",
    )
    bf_backfilled_het_jobs: Optional[StrictInt] = Field(
        default=None,
        description="Number of heterogeneous job components started through backfilling since last Slurm start",
    )
    bf_cycle_counter: Optional[StrictInt] = Field(
        default=None,
        description="Number of backfill scheduling cycles since last reset",
    )
    bf_cycle_mean: Optional[StrictInt] = Field(
        default=None,
        description="Mean time in microseconds of backfilling scheduling cycles since last reset",
    )
    bf_depth_mean: Optional[StrictInt] = Field(
        default=None,
        description="Mean number of eligible to run jobs processed during all backfilling scheduling cycles since last reset",
    )
    bf_depth_mean_try: Optional[StrictInt] = Field(
        default=None,
        description="The subset of Depth Mean that the backfill scheduler attempted to schedule",
    )
    bf_cycle_sum: Optional[StrictInt] = Field(
        default=None,
        description="Total time in microseconds of backfilling scheduling cycles since last reset",
    )
    bf_cycle_last: Optional[StrictInt] = Field(
        default=None,
        description="Execution time in microseconds of last backfill scheduling cycle",
    )
    bf_last_depth: Optional[StrictInt] = Field(
        default=None,
        description="Number of processed jobs during last backfilling scheduling cycle",
    )
    bf_last_depth_try: Optional[StrictInt] = Field(
        default=None,
        description="Number of processed jobs during last backfilling scheduling cycle that had a chance to start using available resources",
    )
    bf_depth_sum: Optional[StrictInt] = Field(
        default=None,
        description="Total number of jobs processed during all backfilling scheduling cycles since last reset",
    )
    bf_depth_try_sum: Optional[StrictInt] = Field(
        default=None,
        description="Subset of bf_depth_sum that the backfill scheduler attempted to schedule",
    )
    bf_queue_len: Optional[StrictInt] = Field(
        default=None,
        description="Number of jobs pending to be processed by backfilling algorithm",
    )
    bf_queue_len_mean: Optional[StrictInt] = Field(
        default=None,
        description="Mean number of jobs pending to be processed by backfilling algorithm",
    )
    bf_queue_len_sum: Optional[StrictInt] = Field(
        default=None,
        description="Total number of jobs pending to be processed by backfilling algorithm since last reset",
    )
    bf_table_size: Optional[StrictInt] = Field(
        default=None,
        description="Number of different time slots tested by the backfill scheduler in its last iteration",
    )
    bf_table_size_mean: Optional[StrictInt] = Field(
        default=None,
        description="Mean number of different time slots tested by the backfill scheduler",
    )
    bf_when_last_cycle: Optional[Uint64NoVal] = None
    bf_active: Optional[StrictBool] = Field(
        default=None, description="Backfill scheduler currently running"
    )
    bf_exit: Optional[BfExitFields] = None
    rpcs_by_message_type: Optional[List[V0040StatsMsgRpcsByTypeInner]] = Field(
        default=None, description="RPCs by message type"
    )
    rpcs_by_user: Optional[List[V0040StatsMsgRpcsByUserInner]] = Field(
        default=None, description="RPCs by user"
    )
    __properties: ClassVar[List[str]] = [
        "parts_packed",
        "req_time",
        "req_time_start",
        "server_thread_count",
        "agent_queue_size",
        "agent_count",
        "agent_thread_count",
        "dbd_agent_queue_size",
        "gettimeofday_latency",
        "schedule_cycle_max",
        "schedule_cycle_last",
        "schedule_cycle_total",
        "schedule_cycle_mean",
        "schedule_cycle_mean_depth",
        "schedule_cycle_per_minute",
        "schedule_queue_length",
        "schedule_exit",
        "jobs_submitted",
        "jobs_started",
        "jobs_completed",
        "jobs_canceled",
        "jobs_failed",
        "jobs_pending",
        "jobs_running",
        "job_states_ts",
        "bf_backfilled_jobs",
        "bf_last_backfilled_jobs",
        "bf_backfilled_het_jobs",
        "bf_cycle_counter",
        "bf_cycle_mean",
        "bf_depth_mean",
        "bf_depth_mean_try",
        "bf_cycle_sum",
        "bf_cycle_last",
        "bf_last_depth",
        "bf_last_depth_try",
        "bf_depth_sum",
        "bf_depth_try_sum",
        "bf_queue_len",
        "bf_queue_len_mean",
        "bf_queue_len_sum",
        "bf_table_size",
        "bf_table_size_mean",
        "bf_when_last_cycle",
        "bf_active",
        "bf_exit",
        "rpcs_by_message_type",
        "rpcs_by_user",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StatsMsg from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of req_time
        if self.req_time:
            _dict["req_time"] = self.req_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of req_time_start
        if self.req_time_start:
            _dict["req_time_start"] = self.req_time_start.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schedule_exit
        if self.schedule_exit:
            _dict["schedule_exit"] = self.schedule_exit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of job_states_ts
        if self.job_states_ts:
            _dict["job_states_ts"] = self.job_states_ts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bf_when_last_cycle
        if self.bf_when_last_cycle:
            _dict["bf_when_last_cycle"] = self.bf_when_last_cycle.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bf_exit
        if self.bf_exit:
            _dict["bf_exit"] = self.bf_exit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rpcs_by_message_type (list)
        _items = []
        if self.rpcs_by_message_type:
            for _item_rpcs_by_message_type in self.rpcs_by_message_type:
                if _item_rpcs_by_message_type:
                    _items.append(_item_rpcs_by_message_type.to_dict())
            _dict["rpcs_by_message_type"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in rpcs_by_user (list)
        _items = []
        if self.rpcs_by_user:
            for _item_rpcs_by_user in self.rpcs_by_user:
                if _item_rpcs_by_user:
                    _items.append(_item_rpcs_by_user.to_dict())
            _dict["rpcs_by_user"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StatsMsg from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "parts_packed": obj.get("parts_packed"),
                "req_time": Uint64NoVal.from_dict(obj["req_time"])
                if obj.get("req_time") is not None
                else None,
                "req_time_start": Uint64NoVal.from_dict(obj["req_time_start"])
                if obj.get("req_time_start") is not None
                else None,
                "server_thread_count": obj.get("server_thread_count"),
                "agent_queue_size": obj.get("agent_queue_size"),
                "agent_count": obj.get("agent_count"),
                "agent_thread_count": obj.get("agent_thread_count"),
                "dbd_agent_queue_size": obj.get("dbd_agent_queue_size"),
                "gettimeofday_latency": obj.get("gettimeofday_latency"),
                "schedule_cycle_max": obj.get("schedule_cycle_max"),
                "schedule_cycle_last": obj.get("schedule_cycle_last"),
                "schedule_cycle_total": obj.get("schedule_cycle_total"),
                "schedule_cycle_mean": obj.get("schedule_cycle_mean"),
                "schedule_cycle_mean_depth": obj.get("schedule_cycle_mean_depth"),
                "schedule_cycle_per_minute": obj.get("schedule_cycle_per_minute"),
                "schedule_queue_length": obj.get("schedule_queue_length"),
                "schedule_exit": ScheduleExitFields.from_dict(obj["schedule_exit"])
                if obj.get("schedule_exit") is not None
                else None,
                "jobs_submitted": obj.get("jobs_submitted"),
                "jobs_started": obj.get("jobs_started"),
                "jobs_completed": obj.get("jobs_completed"),
                "jobs_canceled": obj.get("jobs_canceled"),
                "jobs_failed": obj.get("jobs_failed"),
                "jobs_pending": obj.get("jobs_pending"),
                "jobs_running": obj.get("jobs_running"),
                "job_states_ts": Uint64NoVal.from_dict(obj["job_states_ts"])
                if obj.get("job_states_ts") is not None
                else None,
                "bf_backfilled_jobs": obj.get("bf_backfilled_jobs"),
                "bf_last_backfilled_jobs": obj.get("bf_last_backfilled_jobs"),
                "bf_backfilled_het_jobs": obj.get("bf_backfilled_het_jobs"),
                "bf_cycle_counter": obj.get("bf_cycle_counter"),
                "bf_cycle_mean": obj.get("bf_cycle_mean"),
                "bf_depth_mean": obj.get("bf_depth_mean"),
                "bf_depth_mean_try": obj.get("bf_depth_mean_try"),
                "bf_cycle_sum": obj.get("bf_cycle_sum"),
                "bf_cycle_last": obj.get("bf_cycle_last"),
                "bf_last_depth": obj.get("bf_last_depth"),
                "bf_last_depth_try": obj.get("bf_last_depth_try"),
                "bf_depth_sum": obj.get("bf_depth_sum"),
                "bf_depth_try_sum": obj.get("bf_depth_try_sum"),
                "bf_queue_len": obj.get("bf_queue_len"),
                "bf_queue_len_mean": obj.get("bf_queue_len_mean"),
                "bf_queue_len_sum": obj.get("bf_queue_len_sum"),
                "bf_table_size": obj.get("bf_table_size"),
                "bf_table_size_mean": obj.get("bf_table_size_mean"),
                "bf_when_last_cycle": Uint64NoVal.from_dict(obj["bf_when_last_cycle"])
                if obj.get("bf_when_last_cycle") is not None
                else None,
                "bf_active": obj.get("bf_active"),
                "bf_exit": BfExitFields.from_dict(obj["bf_exit"])
                if obj.get("bf_exit") is not None
                else None,
                "rpcs_by_message_type": [
                    V0040StatsMsgRpcsByTypeInner.from_dict(_item)
                    for _item in obj["rpcs_by_message_type"]
                ]
                if obj.get("rpcs_by_message_type") is not None
                else None,
                "rpcs_by_user": [
                    V0040StatsMsgRpcsByUserInner.from_dict(_item)
                    for _item in obj["rpcs_by_user"]
                ]
                if obj.get("rpcs_by_user") is not None
                else None,
            }
        )
        return _obj
