# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0040.asyncio.models.uint32_no_val import Uint32NoVal
from slurpy.v0040.asyncio.models.uint64_no_val import Uint64NoVal
from typing import Set
from typing_extensions import Self


class V0040PartitionInfoDefaults(BaseModel):
    """
    V0040PartitionInfoDefaults
    """  # noqa: E501

    memory_per_cpu: Optional[StrictInt] = Field(
        default=None, description="DefMemPerCPU or DefMemPerNode"
    )
    partition_memory_per_cpu: Optional[Uint64NoVal] = None
    partition_memory_per_node: Optional[Uint64NoVal] = None
    time: Optional[Uint32NoVal] = None
    job: Optional[StrictStr] = Field(default=None, description="JobDefaults")
    __properties: ClassVar[List[str]] = [
        "memory_per_cpu",
        "partition_memory_per_cpu",
        "partition_memory_per_node",
        "time",
        "job",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V0040PartitionInfoDefaults from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of partition_memory_per_cpu
        if self.partition_memory_per_cpu:
            _dict["partition_memory_per_cpu"] = self.partition_memory_per_cpu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of partition_memory_per_node
        if self.partition_memory_per_node:
            _dict["partition_memory_per_node"] = (
                self.partition_memory_per_node.to_dict()
            )
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict["time"] = self.time.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V0040PartitionInfoDefaults from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "memory_per_cpu": obj.get("memory_per_cpu"),
                "partition_memory_per_cpu": Uint64NoVal.from_dict(
                    obj["partition_memory_per_cpu"]
                )
                if obj.get("partition_memory_per_cpu") is not None
                else None,
                "partition_memory_per_node": Uint64NoVal.from_dict(
                    obj["partition_memory_per_node"]
                )
                if obj.get("partition_memory_per_node") is not None
                else None,
                "time": Uint32NoVal.from_dict(obj["time"])
                if obj.get("time") is not None
                else None,
                "job": obj.get("job"),
            }
        )
        return _obj
