# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_active_jobs import (
    V0040QosLimitsMaxActiveJobs,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_jobs import V0040QosLimitsMaxJobs
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_jobs_active_jobs import (
    V0040QosLimitsMaxJobsActiveJobs,
)
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_tres import V0040QosLimitsMaxTres
from slurpy.v0040.asyncio.models.v0040_qos_limits_max_wall_clock import (
    V0040QosLimitsMaxWallClock,
)
from typing import Set
from typing_extensions import Self


class V0040QosLimitsMax(BaseModel):
    """
    V0040QosLimitsMax
    """  # noqa: E501

    active_jobs: Optional[V0040QosLimitsMaxActiveJobs] = None
    tres: Optional[V0040QosLimitsMaxTres] = None
    wall_clock: Optional[V0040QosLimitsMaxWallClock] = None
    jobs: Optional[V0040QosLimitsMaxJobs] = None
    accruing: Optional[V0040QosLimitsMaxJobsActiveJobs] = None
    __properties: ClassVar[List[str]] = [
        "active_jobs",
        "tres",
        "wall_clock",
        "jobs",
        "accruing",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V0040QosLimitsMax from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of active_jobs
        if self.active_jobs:
            _dict["active_jobs"] = self.active_jobs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tres
        if self.tres:
            _dict["tres"] = self.tres.to_dict()
        # override the default output from pydantic by calling `to_dict()` of wall_clock
        if self.wall_clock:
            _dict["wall_clock"] = self.wall_clock.to_dict()
        # override the default output from pydantic by calling `to_dict()` of jobs
        if self.jobs:
            _dict["jobs"] = self.jobs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of accruing
        if self.accruing:
            _dict["accruing"] = self.accruing.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V0040QosLimitsMax from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "active_jobs": V0040QosLimitsMaxActiveJobs.from_dict(obj["active_jobs"])
                if obj.get("active_jobs") is not None
                else None,
                "tres": V0040QosLimitsMaxTres.from_dict(obj["tres"])
                if obj.get("tres") is not None
                else None,
                "wall_clock": V0040QosLimitsMaxWallClock.from_dict(obj["wall_clock"])
                if obj.get("wall_clock") is not None
                else None,
                "jobs": V0040QosLimitsMaxJobs.from_dict(obj["jobs"])
                if obj.get("jobs") is not None
                else None,
                "accruing": V0040QosLimitsMaxJobsActiveJobs.from_dict(obj["accruing"])
                if obj.get("accruing") is not None
                else None,
            }
        )
        return _obj
