# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictInt,
    StrictStr,
    field_validator,
)
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0040.models.assoc_short import AssocShort
from slurpy.v0040.models.process_exit_code_verbose import ProcessExitCodeVerbose
from slurpy.v0040.models.step import Step
from slurpy.v0040.models.uint32_no_val import Uint32NoVal
from slurpy.v0040.models.v0040_job_array import V0040JobArray
from slurpy.v0040.models.v0040_job_comment import V0040JobComment
from slurpy.v0040.models.v0040_job_het import V0040JobHet
from slurpy.v0040.models.v0040_job_mcs import V0040JobMcs
from slurpy.v0040.models.v0040_job_required import V0040JobRequired
from slurpy.v0040.models.v0040_job_reservation import V0040JobReservation
from slurpy.v0040.models.v0040_job_state import V0040JobState
from slurpy.v0040.models.v0040_job_time import V0040JobTime
from slurpy.v0040.models.v0040_job_tres import V0040JobTres
from slurpy.v0040.models.wckey_tag_struct import WckeyTagStruct
from typing import Set
from typing_extensions import Self


class Job(BaseModel):
    """
    Job
    """  # noqa: E501

    account: Optional[StrictStr] = Field(
        default=None, description="Account the job ran under"
    )
    comment: Optional[V0040JobComment] = None
    allocation_nodes: Optional[StrictInt] = Field(
        default=None, description="List of nodes allocated to the job"
    )
    array: Optional[V0040JobArray] = None
    association: Optional[AssocShort] = None
    block: Optional[StrictStr] = Field(
        default=None,
        description="The name of the block to be used (used with Blue Gene systems)",
    )
    cluster: Optional[StrictStr] = Field(default=None, description="Cluster name")
    constraints: Optional[StrictStr] = Field(
        default=None, description="Feature(s) the job requested as a constraint"
    )
    container: Optional[StrictStr] = Field(
        default=None, description="Absolute path to OCI container bundle"
    )
    derived_exit_code: Optional[ProcessExitCodeVerbose] = None
    time: Optional[V0040JobTime] = None
    exit_code: Optional[ProcessExitCodeVerbose] = None
    extra: Optional[StrictStr] = Field(
        default=None,
        description="Arbitrary string used for node filtering if extra constraints are enabled",
    )
    failed_node: Optional[StrictStr] = Field(
        default=None, description="Name of node that caused job failure"
    )
    flags: Optional[List[StrictStr]] = None
    group: Optional[StrictStr] = Field(
        default=None, description="Group ID of the user that owns the job"
    )
    het: Optional[V0040JobHet] = None
    job_id: Optional[StrictInt] = Field(default=None, description="Job ID")
    name: Optional[StrictStr] = Field(default=None, description="Job name")
    licenses: Optional[StrictStr] = Field(
        default=None, description="License(s) required by the job"
    )
    mcs: Optional[V0040JobMcs] = None
    nodes: Optional[StrictStr] = Field(
        default=None, description="Node(s) allocated to the job"
    )
    partition: Optional[StrictStr] = Field(
        default=None, description="Partition assigned to the job"
    )
    hold: Optional[StrictBool] = Field(default=None, description="Job held")
    priority: Optional[Uint32NoVal] = None
    qos: Optional[StrictStr] = Field(
        default=None, description="Quality of Service assigned to the job"
    )
    required: Optional[V0040JobRequired] = None
    kill_request_user: Optional[StrictStr] = Field(
        default=None, description="User ID that requested termination of the job"
    )
    reservation: Optional[V0040JobReservation] = None
    script: Optional[StrictStr] = Field(
        default=None,
        description="Job batch script; only the first component in a HetJob is populated or honored",
    )
    state: Optional[V0040JobState] = None
    steps: Optional[List[Step]] = None
    submit_line: Optional[StrictStr] = Field(
        default=None, description="Command used to submit the job"
    )
    tres: Optional[V0040JobTres] = None
    used_gres: Optional[StrictStr] = Field(
        default=None, description="Generic resources used by job"
    )
    user: Optional[StrictStr] = Field(
        default=None, description="User that owns the job"
    )
    wckey: Optional[WckeyTagStruct] = None
    working_directory: Optional[StrictStr] = Field(
        default=None, description="Path to current working directory"
    )
    __properties: ClassVar[List[str]] = [
        "account",
        "comment",
        "allocation_nodes",
        "array",
        "association",
        "block",
        "cluster",
        "constraints",
        "container",
        "derived_exit_code",
        "time",
        "exit_code",
        "extra",
        "failed_node",
        "flags",
        "group",
        "het",
        "job_id",
        "name",
        "licenses",
        "mcs",
        "nodes",
        "partition",
        "hold",
        "priority",
        "qos",
        "required",
        "kill_request_user",
        "reservation",
        "script",
        "state",
        "steps",
        "submit_line",
        "tres",
        "used_gres",
        "user",
        "wckey",
        "working_directory",
    ]

    @field_validator("flags")
    def flags_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(
                [
                    "NONE",
                    "CLEAR_SCHEDULING",
                    "NOT_SET",
                    "STARTED_ON_SUBMIT",
                    "STARTED_ON_SCHEDULE",
                    "STARTED_ON_BACKFILL",
                    "START_RECEIVED",
                ]
            ):
                raise ValueError(
                    "each list item must be one of ('NONE', 'CLEAR_SCHEDULING', 'NOT_SET', 'STARTED_ON_SUBMIT', 'STARTED_ON_SCHEDULE', 'STARTED_ON_BACKFILL', 'START_RECEIVED')"
                )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Job from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of comment
        if self.comment:
            _dict["comment"] = self.comment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of array
        if self.array:
            _dict["array"] = self.array.to_dict()
        # override the default output from pydantic by calling `to_dict()` of association
        if self.association:
            _dict["association"] = self.association.to_dict()
        # override the default output from pydantic by calling `to_dict()` of derived_exit_code
        if self.derived_exit_code:
            _dict["derived_exit_code"] = self.derived_exit_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict["time"] = self.time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of exit_code
        if self.exit_code:
            _dict["exit_code"] = self.exit_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of het
        if self.het:
            _dict["het"] = self.het.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mcs
        if self.mcs:
            _dict["mcs"] = self.mcs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of priority
        if self.priority:
            _dict["priority"] = self.priority.to_dict()
        # override the default output from pydantic by calling `to_dict()` of required
        if self.required:
            _dict["required"] = self.required.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reservation
        if self.reservation:
            _dict["reservation"] = self.reservation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict["state"] = self.state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item_steps in self.steps:
                if _item_steps:
                    _items.append(_item_steps.to_dict())
            _dict["steps"] = _items
        # override the default output from pydantic by calling `to_dict()` of tres
        if self.tres:
            _dict["tres"] = self.tres.to_dict()
        # override the default output from pydantic by calling `to_dict()` of wckey
        if self.wckey:
            _dict["wckey"] = self.wckey.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Job from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "account": obj.get("account"),
                "comment": V0040JobComment.from_dict(obj["comment"])
                if obj.get("comment") is not None
                else None,
                "allocation_nodes": obj.get("allocation_nodes"),
                "array": V0040JobArray.from_dict(obj["array"])
                if obj.get("array") is not None
                else None,
                "association": AssocShort.from_dict(obj["association"])
                if obj.get("association") is not None
                else None,
                "block": obj.get("block"),
                "cluster": obj.get("cluster"),
                "constraints": obj.get("constraints"),
                "container": obj.get("container"),
                "derived_exit_code": ProcessExitCodeVerbose.from_dict(
                    obj["derived_exit_code"]
                )
                if obj.get("derived_exit_code") is not None
                else None,
                "time": V0040JobTime.from_dict(obj["time"])
                if obj.get("time") is not None
                else None,
                "exit_code": ProcessExitCodeVerbose.from_dict(obj["exit_code"])
                if obj.get("exit_code") is not None
                else None,
                "extra": obj.get("extra"),
                "failed_node": obj.get("failed_node"),
                "flags": obj.get("flags"),
                "group": obj.get("group"),
                "het": V0040JobHet.from_dict(obj["het"])
                if obj.get("het") is not None
                else None,
                "job_id": obj.get("job_id"),
                "name": obj.get("name"),
                "licenses": obj.get("licenses"),
                "mcs": V0040JobMcs.from_dict(obj["mcs"])
                if obj.get("mcs") is not None
                else None,
                "nodes": obj.get("nodes"),
                "partition": obj.get("partition"),
                "hold": obj.get("hold"),
                "priority": Uint32NoVal.from_dict(obj["priority"])
                if obj.get("priority") is not None
                else None,
                "qos": obj.get("qos"),
                "required": V0040JobRequired.from_dict(obj["required"])
                if obj.get("required") is not None
                else None,
                "kill_request_user": obj.get("kill_request_user"),
                "reservation": V0040JobReservation.from_dict(obj["reservation"])
                if obj.get("reservation") is not None
                else None,
                "script": obj.get("script"),
                "state": V0040JobState.from_dict(obj["state"])
                if obj.get("state") is not None
                else None,
                "steps": [Step.from_dict(_item) for _item in obj["steps"]]
                if obj.get("steps") is not None
                else None,
                "submit_line": obj.get("submit_line"),
                "tres": V0040JobTres.from_dict(obj["tres"])
                if obj.get("tres") is not None
                else None,
                "used_gres": obj.get("used_gres"),
                "user": obj.get("user"),
                "wckey": WckeyTagStruct.from_dict(obj["wckey"])
                if obj.get("wckey") is not None
                else None,
                "working_directory": obj.get("working_directory"),
            }
        )
        return _obj
