# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0040.models.uint32_no_val import Uint32NoVal
from slurpy.v0040.models.v0040_kill_jobs_resp_job_error import V0040KillJobsRespJobError
from slurpy.v0040.models.v0040_kill_jobs_resp_job_federation import (
    V0040KillJobsRespJobFederation,
)
from typing import Set
from typing_extensions import Self


class KillJobsRespJob(BaseModel):
    """
    KillJobsRespJob
    """  # noqa: E501

    error: Optional[V0040KillJobsRespJobError] = None
    step_id: StrictStr = Field(description="Job or Step ID that signaling failed")
    job_id: Uint32NoVal
    federation: Optional[V0040KillJobsRespJobFederation] = None
    __properties: ClassVar[List[str]] = ["error", "step_id", "job_id", "federation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KillJobsRespJob from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict["error"] = self.error.to_dict()
        # override the default output from pydantic by calling `to_dict()` of job_id
        if self.job_id:
            _dict["job_id"] = self.job_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of federation
        if self.federation:
            _dict["federation"] = self.federation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KillJobsRespJob from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "error": V0040KillJobsRespJobError.from_dict(obj["error"])
                if obj.get("error") is not None
                else None,
                "step_id": obj.get("step_id"),
                "job_id": Uint32NoVal.from_dict(obj["job_id"])
                if obj.get("job_id") is not None
                else None,
                "federation": V0040KillJobsRespJobFederation.from_dict(
                    obj["federation"]
                )
                if obj.get("federation") is not None
                else None,
            }
        )
        return _obj
