# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0040.models.account import Account
from slurpy.v0040.models.assoc import Assoc
from slurpy.v0040.models.cluster_rec import ClusterRec
from slurpy.v0040.models.instance import Instance
from slurpy.v0040.models.open_api_error import OpenAPIError
from slurpy.v0040.models.open_api_meta import OpenAPIMeta
from slurpy.v0040.models.open_api_warning import OpenAPIWarning
from slurpy.v0040.models.qos import Qos
from slurpy.v0040.models.tres import Tres
from slurpy.v0040.models.user import User
from slurpy.v0040.models.wckey import Wckey
from typing import Set
from typing_extensions import Self


class OpenAPISlurmdbdConfigResp(BaseModel):
    """
    OpenAPISlurmdbdConfigResp
    """  # noqa: E501

    clusters: Optional[List[ClusterRec]] = None
    tres: Optional[List[Tres]] = None
    accounts: Optional[List[Account]] = None
    users: Optional[List[User]] = None
    qos: Optional[List[Qos]] = None
    wckeys: Optional[List[Wckey]] = None
    associations: Optional[List[Assoc]] = None
    instances: Optional[List[Instance]] = None
    meta: Optional[OpenAPIMeta] = None
    errors: Optional[List[OpenAPIError]] = None
    warnings: Optional[List[OpenAPIWarning]] = None
    __properties: ClassVar[List[str]] = [
        "clusters",
        "tres",
        "accounts",
        "users",
        "qos",
        "wckeys",
        "associations",
        "instances",
        "meta",
        "errors",
        "warnings",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OpenAPISlurmdbdConfigResp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in clusters (list)
        _items = []
        if self.clusters:
            for _item_clusters in self.clusters:
                if _item_clusters:
                    _items.append(_item_clusters.to_dict())
            _dict["clusters"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tres (list)
        _items = []
        if self.tres:
            for _item_tres in self.tres:
                if _item_tres:
                    _items.append(_item_tres.to_dict())
            _dict["tres"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in accounts (list)
        _items = []
        if self.accounts:
            for _item_accounts in self.accounts:
                if _item_accounts:
                    _items.append(_item_accounts.to_dict())
            _dict["accounts"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item_users in self.users:
                if _item_users:
                    _items.append(_item_users.to_dict())
            _dict["users"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in qos (list)
        _items = []
        if self.qos:
            for _item_qos in self.qos:
                if _item_qos:
                    _items.append(_item_qos.to_dict())
            _dict["qos"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in wckeys (list)
        _items = []
        if self.wckeys:
            for _item_wckeys in self.wckeys:
                if _item_wckeys:
                    _items.append(_item_wckeys.to_dict())
            _dict["wckeys"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in associations (list)
        _items = []
        if self.associations:
            for _item_associations in self.associations:
                if _item_associations:
                    _items.append(_item_associations.to_dict())
            _dict["associations"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in instances (list)
        _items = []
        if self.instances:
            for _item_instances in self.instances:
                if _item_instances:
                    _items.append(_item_instances.to_dict())
            _dict["instances"] = _items
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict["meta"] = self.meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict["errors"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in warnings (list)
        _items = []
        if self.warnings:
            for _item_warnings in self.warnings:
                if _item_warnings:
                    _items.append(_item_warnings.to_dict())
            _dict["warnings"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OpenAPISlurmdbdConfigResp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "clusters": [ClusterRec.from_dict(_item) for _item in obj["clusters"]]
                if obj.get("clusters") is not None
                else None,
                "tres": [Tres.from_dict(_item) for _item in obj["tres"]]
                if obj.get("tres") is not None
                else None,
                "accounts": [Account.from_dict(_item) for _item in obj["accounts"]]
                if obj.get("accounts") is not None
                else None,
                "users": [User.from_dict(_item) for _item in obj["users"]]
                if obj.get("users") is not None
                else None,
                "qos": [Qos.from_dict(_item) for _item in obj["qos"]]
                if obj.get("qos") is not None
                else None,
                "wckeys": [Wckey.from_dict(_item) for _item in obj["wckeys"]]
                if obj.get("wckeys") is not None
                else None,
                "associations": [
                    Assoc.from_dict(_item) for _item in obj["associations"]
                ]
                if obj.get("associations") is not None
                else None,
                "instances": [Instance.from_dict(_item) for _item in obj["instances"]]
                if obj.get("instances") is not None
                else None,
                "meta": OpenAPIMeta.from_dict(obj["meta"])
                if obj.get("meta") is not None
                else None,
                "errors": [OpenAPIError.from_dict(_item) for _item in obj["errors"]]
                if obj.get("errors") is not None
                else None,
                "warnings": [
                    OpenAPIWarning.from_dict(_item) for _item in obj["warnings"]
                ]
                if obj.get("warnings") is not None
                else None,
            }
        )
        return _obj
