# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0040.models.uint64_no_val import Uint64NoVal
from typing import Set
from typing_extensions import Self


class V0040JobDescMsgRlimits(BaseModel):
    """
    V0040JobDescMsgRlimits
    """  # noqa: E501

    cpu: Optional[Uint64NoVal] = None
    fsize: Optional[Uint64NoVal] = None
    data: Optional[Uint64NoVal] = None
    stack: Optional[Uint64NoVal] = None
    core: Optional[Uint64NoVal] = None
    rss: Optional[Uint64NoVal] = None
    nproc: Optional[Uint64NoVal] = None
    nofile: Optional[Uint64NoVal] = None
    memlock: Optional[Uint64NoVal] = None
    var_as: Optional[Uint64NoVal] = Field(default=None, alias="as")
    __properties: ClassVar[List[str]] = [
        "cpu",
        "fsize",
        "data",
        "stack",
        "core",
        "rss",
        "nproc",
        "nofile",
        "memlock",
        "as",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V0040JobDescMsgRlimits from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cpu
        if self.cpu:
            _dict["cpu"] = self.cpu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fsize
        if self.fsize:
            _dict["fsize"] = self.fsize.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict["data"] = self.data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stack
        if self.stack:
            _dict["stack"] = self.stack.to_dict()
        # override the default output from pydantic by calling `to_dict()` of core
        if self.core:
            _dict["core"] = self.core.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rss
        if self.rss:
            _dict["rss"] = self.rss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nproc
        if self.nproc:
            _dict["nproc"] = self.nproc.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nofile
        if self.nofile:
            _dict["nofile"] = self.nofile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of memlock
        if self.memlock:
            _dict["memlock"] = self.memlock.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_as
        if self.var_as:
            _dict["as"] = self.var_as.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V0040JobDescMsgRlimits from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "cpu": Uint64NoVal.from_dict(obj["cpu"])
                if obj.get("cpu") is not None
                else None,
                "fsize": Uint64NoVal.from_dict(obj["fsize"])
                if obj.get("fsize") is not None
                else None,
                "data": Uint64NoVal.from_dict(obj["data"])
                if obj.get("data") is not None
                else None,
                "stack": Uint64NoVal.from_dict(obj["stack"])
                if obj.get("stack") is not None
                else None,
                "core": Uint64NoVal.from_dict(obj["core"])
                if obj.get("core") is not None
                else None,
                "rss": Uint64NoVal.from_dict(obj["rss"])
                if obj.get("rss") is not None
                else None,
                "nproc": Uint64NoVal.from_dict(obj["nproc"])
                if obj.get("nproc") is not None
                else None,
                "nofile": Uint64NoVal.from_dict(obj["nofile"])
                if obj.get("nofile") is not None
                else None,
                "memlock": Uint64NoVal.from_dict(obj["memlock"])
                if obj.get("memlock") is not None
                else None,
                "as": Uint64NoVal.from_dict(obj["as"])
                if obj.get("as") is not None
                else None,
            }
        )
        return _obj
