# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class V0040RollupStatsInner(BaseModel):
    """
    recorded rollup statistics
    """  # noqa: E501

    type: Optional[StrictStr] = Field(default=None, description="type")
    last_run: Optional[StrictInt] = Field(
        default=None,
        description="Last time rollup ran (UNIX timestamp)",
        alias="last run",
    )
    max_cycle: Optional[StrictInt] = Field(
        default=None, description="longest rollup time (seconds)"
    )
    total_time: Optional[StrictInt] = Field(
        default=None, description="total time spent doing rollups (seconds)"
    )
    total_cycles: Optional[StrictInt] = Field(
        default=None, description="number of rollups since last_run"
    )
    mean_cycles: Optional[StrictInt] = Field(
        default=None, description="average time for rollup (seconds)"
    )
    __properties: ClassVar[List[str]] = [
        "type",
        "last run",
        "max_cycle",
        "total_time",
        "total_cycles",
        "mean_cycles",
    ]

    @field_validator("type")
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["internal", "user", "unknown"]):
            raise ValueError(
                "must be one of enum values ('internal', 'user', 'unknown')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V0040RollupStatsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V0040RollupStatsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "last run": obj.get("last run"),
                "max_cycle": obj.get("max_cycle"),
                "total_time": obj.get("total_time"),
                "total_cycles": obj.get("total_cycles"),
                "mean_cycles": obj.get("mean_cycles"),
            }
        )
        return _obj
