# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from slurpy.v0041.asyncio.models.open_api_accounts_add_cond_resp import (
    OpenAPIAccountsAddCondResp,
)
from slurpy.v0041.asyncio.models.open_api_accounts_add_cond_resp_str import (
    OpenAPIAccountsAddCondRespStr,
)
from slurpy.v0041.asyncio.models.open_api_accounts_removed_resp import (
    OpenAPIAccountsRemovedResp,
)
from slurpy.v0041.asyncio.models.open_api_accounts_resp import OpenAPIAccountsResp
from slurpy.v0041.asyncio.models.open_api_assocs_removed_resp import (
    OpenAPIAssocsRemovedResp,
)
from slurpy.v0041.asyncio.models.open_api_assocs_resp import OpenAPIAssocsResp
from slurpy.v0041.asyncio.models.open_api_clusters_removed_resp import (
    OpenAPIClustersRemovedResp,
)
from slurpy.v0041.asyncio.models.open_api_clusters_resp import OpenAPIClustersResp
from slurpy.v0041.asyncio.models.open_api_instances_resp import OpenAPIInstancesResp
from slurpy.v0041.asyncio.models.open_api_resp import OpenAPIResp
from slurpy.v0041.asyncio.models.open_api_slurmdbd_config_resp import (
    OpenAPISlurmdbdConfigResp,
)
from slurpy.v0041.asyncio.models.open_api_slurmdbd_jobs_resp import (
    OpenAPISlurmdbdJobsResp,
)
from slurpy.v0041.asyncio.models.open_api_slurmdbd_qos_removed_resp import (
    OpenAPISlurmdbdQosRemovedResp,
)
from slurpy.v0041.asyncio.models.open_api_slurmdbd_qos_resp import (
    OpenAPISlurmdbdQosResp,
)
from slurpy.v0041.asyncio.models.open_api_slurmdbd_stats_resp import (
    OpenAPISlurmdbdStatsResp,
)
from slurpy.v0041.asyncio.models.open_api_tres_resp import OpenAPITresResp
from slurpy.v0041.asyncio.models.open_api_users_add_cond_resp import (
    OpenAPIUsersAddCondResp,
)
from slurpy.v0041.asyncio.models.open_api_users_add_cond_resp_str import (
    OpenAPIUsersAddCondRespStr,
)
from slurpy.v0041.asyncio.models.open_api_users_resp import OpenAPIUsersResp
from slurpy.v0041.asyncio.models.open_api_wckey_removed_resp import (
    OpenAPIWckeyRemovedResp,
)
from slurpy.v0041.asyncio.models.open_api_wckey_resp import OpenAPIWckeyResp

from slurpy.v0041.asyncio.api_client import ApiClient, RequestSerialized
from slurpy.v0041.asyncio.api_response import ApiResponse
from slurpy.v0041.asyncio.rest import RESTResponseType


class SlurmdbApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    async def delete_account(
        self,
        account_name: Annotated[StrictStr, Field(description="Account name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIAccountsRemovedResp:
        """Delete account


        :param account_name: Account name (required)
        :type account_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_account_serialize(
            account_name=account_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def delete_account_with_http_info(
        self,
        account_name: Annotated[StrictStr, Field(description="Account name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIAccountsRemovedResp]:
        """Delete account


        :param account_name: Account name (required)
        :type account_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_account_serialize(
            account_name=account_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def delete_account_without_preload_content(
        self,
        account_name: Annotated[StrictStr, Field(description="Account name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete account


        :param account_name: Account name (required)
        :type account_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_account_serialize(
            account_name=account_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_account_serialize(
        self,
        account_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_name is not None:
            _path_params["account_name"] = account_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/slurmdb/v0.0.41/account/{account_name}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def delete_association(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIAssocsRemovedResp:
        """Delete association


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_association_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def delete_association_with_http_info(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIAssocsRemovedResp]:
        """Delete association


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_association_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def delete_association_without_preload_content(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete association


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_association_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_association_serialize(
        self,
        account,
        cluster,
        default_qos,
        format,
        id,
        only_defaults,
        parent_account,
        partition,
        qos,
        usage_end,
        usage_start,
        user,
        with_usage,
        with_deleted,
        with_raw_qos,
        with_sub_accts,
        without_parent_info,
        without_parent_limits,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if account is not None:
            _query_params.append(("account", account))

        if cluster is not None:
            _query_params.append(("cluster", cluster))

        if default_qos is not None:
            _query_params.append(("default_qos", default_qos))

        if format is not None:
            _query_params.append(("format", format))

        if id is not None:
            _query_params.append(("id", id))

        if only_defaults is not None:
            _query_params.append(("only_defaults", only_defaults))

        if parent_account is not None:
            _query_params.append(("parent_account", parent_account))

        if partition is not None:
            _query_params.append(("partition", partition))

        if qos is not None:
            _query_params.append(("qos", qos))

        if usage_end is not None:
            _query_params.append(("usage_end", usage_end))

        if usage_start is not None:
            _query_params.append(("usage_start", usage_start))

        if user is not None:
            _query_params.append(("user", user))

        if with_usage is not None:
            _query_params.append(("with_usage", with_usage))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        if with_raw_qos is not None:
            _query_params.append(("with_raw_qos", with_raw_qos))

        if with_sub_accts is not None:
            _query_params.append(("with_sub_accts", with_sub_accts))

        if without_parent_info is not None:
            _query_params.append(("without_parent_info", without_parent_info))

        if without_parent_limits is not None:
            _query_params.append(("without_parent_limits", without_parent_limits))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/slurmdb/v0.0.41/association/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def delete_associations(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIAssocsRemovedResp:
        """Delete associations


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_associations_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def delete_associations_with_http_info(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIAssocsRemovedResp]:
        """Delete associations


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_associations_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def delete_associations_without_preload_content(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete associations


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_associations_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_associations_serialize(
        self,
        account,
        cluster,
        default_qos,
        format,
        id,
        only_defaults,
        parent_account,
        partition,
        qos,
        usage_end,
        usage_start,
        user,
        with_usage,
        with_deleted,
        with_raw_qos,
        with_sub_accts,
        without_parent_info,
        without_parent_limits,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if account is not None:
            _query_params.append(("account", account))

        if cluster is not None:
            _query_params.append(("cluster", cluster))

        if default_qos is not None:
            _query_params.append(("default_qos", default_qos))

        if format is not None:
            _query_params.append(("format", format))

        if id is not None:
            _query_params.append(("id", id))

        if only_defaults is not None:
            _query_params.append(("only_defaults", only_defaults))

        if parent_account is not None:
            _query_params.append(("parent_account", parent_account))

        if partition is not None:
            _query_params.append(("partition", partition))

        if qos is not None:
            _query_params.append(("qos", qos))

        if usage_end is not None:
            _query_params.append(("usage_end", usage_end))

        if usage_start is not None:
            _query_params.append(("usage_start", usage_start))

        if user is not None:
            _query_params.append(("user", user))

        if with_usage is not None:
            _query_params.append(("with_usage", with_usage))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        if with_raw_qos is not None:
            _query_params.append(("with_raw_qos", with_raw_qos))

        if with_sub_accts is not None:
            _query_params.append(("with_sub_accts", with_sub_accts))

        if without_parent_info is not None:
            _query_params.append(("without_parent_info", without_parent_info))

        if without_parent_limits is not None:
            _query_params.append(("without_parent_limits", without_parent_limits))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/slurmdb/v0.0.41/associations/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def delete_cluster(
        self,
        cluster_name: Annotated[StrictStr, Field(description="Cluster name")],
        classification: Annotated[
            Optional[StrictStr], Field(description="Type of machine")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster list")
        ] = None,
        federation: Annotated[
            Optional[StrictStr], Field(description="CSV federation list")
        ] = None,
        flags: Annotated[Optional[StrictStr], Field(description="Query flags")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        rpc_version: Annotated[
            Optional[StrictStr], Field(description="CSV RPC version list")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted clusters")
        ] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIClustersRemovedResp:
        """Delete cluster


        :param cluster_name: Cluster name (required)
        :type cluster_name: str
        :param classification: Type of machine
        :type classification: str
        :param cluster: CSV cluster list
        :type cluster: str
        :param federation: CSV federation list
        :type federation: str
        :param flags: Query flags
        :type flags: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param rpc_version: CSV RPC version list
        :type rpc_version: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param with_deleted: Include deleted clusters
        :type with_deleted: str
        :param with_usage: Include usage
        :type with_usage: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_cluster_serialize(
            cluster_name=cluster_name,
            classification=classification,
            cluster=cluster,
            federation=federation,
            flags=flags,
            format=format,
            rpc_version=rpc_version,
            usage_end=usage_end,
            usage_start=usage_start,
            with_deleted=with_deleted,
            with_usage=with_usage,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIClustersRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def delete_cluster_with_http_info(
        self,
        cluster_name: Annotated[StrictStr, Field(description="Cluster name")],
        classification: Annotated[
            Optional[StrictStr], Field(description="Type of machine")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster list")
        ] = None,
        federation: Annotated[
            Optional[StrictStr], Field(description="CSV federation list")
        ] = None,
        flags: Annotated[Optional[StrictStr], Field(description="Query flags")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        rpc_version: Annotated[
            Optional[StrictStr], Field(description="CSV RPC version list")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted clusters")
        ] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIClustersRemovedResp]:
        """Delete cluster


        :param cluster_name: Cluster name (required)
        :type cluster_name: str
        :param classification: Type of machine
        :type classification: str
        :param cluster: CSV cluster list
        :type cluster: str
        :param federation: CSV federation list
        :type federation: str
        :param flags: Query flags
        :type flags: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param rpc_version: CSV RPC version list
        :type rpc_version: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param with_deleted: Include deleted clusters
        :type with_deleted: str
        :param with_usage: Include usage
        :type with_usage: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_cluster_serialize(
            cluster_name=cluster_name,
            classification=classification,
            cluster=cluster,
            federation=federation,
            flags=flags,
            format=format,
            rpc_version=rpc_version,
            usage_end=usage_end,
            usage_start=usage_start,
            with_deleted=with_deleted,
            with_usage=with_usage,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIClustersRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def delete_cluster_without_preload_content(
        self,
        cluster_name: Annotated[StrictStr, Field(description="Cluster name")],
        classification: Annotated[
            Optional[StrictStr], Field(description="Type of machine")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster list")
        ] = None,
        federation: Annotated[
            Optional[StrictStr], Field(description="CSV federation list")
        ] = None,
        flags: Annotated[Optional[StrictStr], Field(description="Query flags")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        rpc_version: Annotated[
            Optional[StrictStr], Field(description="CSV RPC version list")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted clusters")
        ] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete cluster


        :param cluster_name: Cluster name (required)
        :type cluster_name: str
        :param classification: Type of machine
        :type classification: str
        :param cluster: CSV cluster list
        :type cluster: str
        :param federation: CSV federation list
        :type federation: str
        :param flags: Query flags
        :type flags: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param rpc_version: CSV RPC version list
        :type rpc_version: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param with_deleted: Include deleted clusters
        :type with_deleted: str
        :param with_usage: Include usage
        :type with_usage: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_cluster_serialize(
            cluster_name=cluster_name,
            classification=classification,
            cluster=cluster,
            federation=federation,
            flags=flags,
            format=format,
            rpc_version=rpc_version,
            usage_end=usage_end,
            usage_start=usage_start,
            with_deleted=with_deleted,
            with_usage=with_usage,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIClustersRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_cluster_serialize(
        self,
        cluster_name,
        classification,
        cluster,
        federation,
        flags,
        format,
        rpc_version,
        usage_end,
        usage_start,
        with_deleted,
        with_usage,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cluster_name is not None:
            _path_params["cluster_name"] = cluster_name
        # process the query parameters
        if classification is not None:
            _query_params.append(("classification", classification))

        if cluster is not None:
            _query_params.append(("cluster", cluster))

        if federation is not None:
            _query_params.append(("federation", federation))

        if flags is not None:
            _query_params.append(("flags", flags))

        if format is not None:
            _query_params.append(("format", format))

        if rpc_version is not None:
            _query_params.append(("rpc_version", rpc_version))

        if usage_end is not None:
            _query_params.append(("usage_end", usage_end))

        if usage_start is not None:
            _query_params.append(("usage_start", usage_start))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        if with_usage is not None:
            _query_params.append(("with_usage", with_usage))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/slurmdb/v0.0.41/cluster/{cluster_name}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def delete_single_qos(
        self,
        qos: Annotated[StrictStr, Field(description="QOS name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPISlurmdbdQosRemovedResp:
        """Delete QOS


        :param qos: QOS name (required)
        :type qos: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_single_qos_serialize(
            qos=qos,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdQosRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def delete_single_qos_with_http_info(
        self,
        qos: Annotated[StrictStr, Field(description="QOS name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPISlurmdbdQosRemovedResp]:
        """Delete QOS


        :param qos: QOS name (required)
        :type qos: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_single_qos_serialize(
            qos=qos,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdQosRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def delete_single_qos_without_preload_content(
        self,
        qos: Annotated[StrictStr, Field(description="QOS name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete QOS


        :param qos: QOS name (required)
        :type qos: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_single_qos_serialize(
            qos=qos,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdQosRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_single_qos_serialize(
        self,
        qos,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if qos is not None:
            _path_params["qos"] = qos
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/slurmdb/v0.0.41/qos/{qos}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def delete_user(
        self,
        name: Annotated[StrictStr, Field(description="User name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIResp:
        """Delete user


        :param name: User name (required)
        :type name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_user_serialize(
            name=name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def delete_user_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="User name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIResp]:
        """Delete user


        :param name: User name (required)
        :type name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_user_serialize(
            name=name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def delete_user_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="User name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete user


        :param name: User name (required)
        :type name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_user_serialize(
            name=name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_user_serialize(
        self,
        name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params["name"] = name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/slurmdb/v0.0.41/user/{name}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def delete_wckey(
        self,
        id: Annotated[StrictStr, Field(description="wckey id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIWckeyRemovedResp:
        """Delete wckey


        :param id: wckey id (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_wckey_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIWckeyRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def delete_wckey_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="wckey id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIWckeyRemovedResp]:
        """Delete wckey


        :param id: wckey id (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_wckey_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIWckeyRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def delete_wckey_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="wckey id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete wckey


        :param id: wckey id (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_wckey_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIWckeyRemovedResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_wckey_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/slurmdb/v0.0.41/wckey/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_account(
        self,
        account_name: Annotated[StrictStr, Field(description="Account name")],
        with_assocs: Annotated[
            Optional[StrictStr], Field(description="Include associations")
        ] = None,
        with_coords: Annotated[
            Optional[StrictStr], Field(description="Include coordinators")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIAccountsResp:
        """Get account info


        :param account_name: Account name (required)
        :type account_name: str
        :param with_assocs: Include associations
        :type with_assocs: str
        :param with_coords: Include coordinators
        :type with_coords: str
        :param with_deleted: Include deleted
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_account_serialize(
            account_name=account_name,
            with_assocs=with_assocs,
            with_coords=with_coords,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_account_with_http_info(
        self,
        account_name: Annotated[StrictStr, Field(description="Account name")],
        with_assocs: Annotated[
            Optional[StrictStr], Field(description="Include associations")
        ] = None,
        with_coords: Annotated[
            Optional[StrictStr], Field(description="Include coordinators")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIAccountsResp]:
        """Get account info


        :param account_name: Account name (required)
        :type account_name: str
        :param with_assocs: Include associations
        :type with_assocs: str
        :param with_coords: Include coordinators
        :type with_coords: str
        :param with_deleted: Include deleted
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_account_serialize(
            account_name=account_name,
            with_assocs=with_assocs,
            with_coords=with_coords,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_account_without_preload_content(
        self,
        account_name: Annotated[StrictStr, Field(description="Account name")],
        with_assocs: Annotated[
            Optional[StrictStr], Field(description="Include associations")
        ] = None,
        with_coords: Annotated[
            Optional[StrictStr], Field(description="Include coordinators")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get account info


        :param account_name: Account name (required)
        :type account_name: str
        :param with_assocs: Include associations
        :type with_assocs: str
        :param with_coords: Include coordinators
        :type with_coords: str
        :param with_deleted: Include deleted
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_account_serialize(
            account_name=account_name,
            with_assocs=with_assocs,
            with_coords=with_coords,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_account_serialize(
        self,
        account_name,
        with_assocs,
        with_coords,
        with_deleted,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if account_name is not None:
            _path_params["account_name"] = account_name
        # process the query parameters
        if with_assocs is not None:
            _query_params.append(("with_assocs", with_assocs))

        if with_coords is not None:
            _query_params.append(("with_coords", with_coords))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/account/{account_name}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_accounts(
        self,
        description: Annotated[
            Optional[StrictStr], Field(description="CSV description list")
        ] = None,
        deleted: Annotated[
            Optional[StrictStr], Field(description="include deleted associations")
        ] = None,
        with_associations: Annotated[
            Optional[StrictStr], Field(description="query includes associations")
        ] = None,
        with_coordinators: Annotated[
            Optional[StrictStr], Field(description="query includes coordinators")
        ] = None,
        no_users_are_coords: Annotated[
            Optional[StrictStr], Field(description="remove users as coordinators")
        ] = None,
        users_are_coords: Annotated[
            Optional[StrictStr], Field(description="users are coordinators")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIAccountsResp:
        """Get account list


        :param description: CSV description list
        :type description: str
        :param deleted: include deleted associations
        :type deleted: str
        :param with_associations: query includes associations
        :type with_associations: str
        :param with_coordinators: query includes coordinators
        :type with_coordinators: str
        :param no_users_are_coords: remove users as coordinators
        :type no_users_are_coords: str
        :param users_are_coords: users are coordinators
        :type users_are_coords: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_accounts_serialize(
            description=description,
            deleted=deleted,
            with_associations=with_associations,
            with_coordinators=with_coordinators,
            no_users_are_coords=no_users_are_coords,
            users_are_coords=users_are_coords,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_accounts_with_http_info(
        self,
        description: Annotated[
            Optional[StrictStr], Field(description="CSV description list")
        ] = None,
        deleted: Annotated[
            Optional[StrictStr], Field(description="include deleted associations")
        ] = None,
        with_associations: Annotated[
            Optional[StrictStr], Field(description="query includes associations")
        ] = None,
        with_coordinators: Annotated[
            Optional[StrictStr], Field(description="query includes coordinators")
        ] = None,
        no_users_are_coords: Annotated[
            Optional[StrictStr], Field(description="remove users as coordinators")
        ] = None,
        users_are_coords: Annotated[
            Optional[StrictStr], Field(description="users are coordinators")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIAccountsResp]:
        """Get account list


        :param description: CSV description list
        :type description: str
        :param deleted: include deleted associations
        :type deleted: str
        :param with_associations: query includes associations
        :type with_associations: str
        :param with_coordinators: query includes coordinators
        :type with_coordinators: str
        :param no_users_are_coords: remove users as coordinators
        :type no_users_are_coords: str
        :param users_are_coords: users are coordinators
        :type users_are_coords: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_accounts_serialize(
            description=description,
            deleted=deleted,
            with_associations=with_associations,
            with_coordinators=with_coordinators,
            no_users_are_coords=no_users_are_coords,
            users_are_coords=users_are_coords,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_accounts_without_preload_content(
        self,
        description: Annotated[
            Optional[StrictStr], Field(description="CSV description list")
        ] = None,
        deleted: Annotated[
            Optional[StrictStr], Field(description="include deleted associations")
        ] = None,
        with_associations: Annotated[
            Optional[StrictStr], Field(description="query includes associations")
        ] = None,
        with_coordinators: Annotated[
            Optional[StrictStr], Field(description="query includes coordinators")
        ] = None,
        no_users_are_coords: Annotated[
            Optional[StrictStr], Field(description="remove users as coordinators")
        ] = None,
        users_are_coords: Annotated[
            Optional[StrictStr], Field(description="users are coordinators")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get account list


        :param description: CSV description list
        :type description: str
        :param deleted: include deleted associations
        :type deleted: str
        :param with_associations: query includes associations
        :type with_associations: str
        :param with_coordinators: query includes coordinators
        :type with_coordinators: str
        :param no_users_are_coords: remove users as coordinators
        :type no_users_are_coords: str
        :param users_are_coords: users are coordinators
        :type users_are_coords: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_accounts_serialize(
            description=description,
            deleted=deleted,
            with_associations=with_associations,
            with_coordinators=with_coordinators,
            no_users_are_coords=no_users_are_coords,
            users_are_coords=users_are_coords,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_accounts_serialize(
        self,
        description,
        deleted,
        with_associations,
        with_coordinators,
        no_users_are_coords,
        users_are_coords,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if description is not None:
            _query_params.append(("description", description))

        if deleted is not None:
            _query_params.append(("DELETED", deleted))

        if with_associations is not None:
            _query_params.append(("WithAssociations", with_associations))

        if with_coordinators is not None:
            _query_params.append(("WithCoordinators", with_coordinators))

        if no_users_are_coords is not None:
            _query_params.append(("NoUsersAreCoords", no_users_are_coords))

        if users_are_coords is not None:
            _query_params.append(("UsersAreCoords", users_are_coords))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/accounts/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_association(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIAssocsResp:
        """Get association info


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_association_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_association_with_http_info(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIAssocsResp]:
        """Get association info


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_association_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_association_without_preload_content(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get association info


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_association_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_association_serialize(
        self,
        account,
        cluster,
        default_qos,
        format,
        id,
        only_defaults,
        parent_account,
        partition,
        qos,
        usage_end,
        usage_start,
        user,
        with_usage,
        with_deleted,
        with_raw_qos,
        with_sub_accts,
        without_parent_info,
        without_parent_limits,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if account is not None:
            _query_params.append(("account", account))

        if cluster is not None:
            _query_params.append(("cluster", cluster))

        if default_qos is not None:
            _query_params.append(("default_qos", default_qos))

        if format is not None:
            _query_params.append(("format", format))

        if id is not None:
            _query_params.append(("id", id))

        if only_defaults is not None:
            _query_params.append(("only_defaults", only_defaults))

        if parent_account is not None:
            _query_params.append(("parent_account", parent_account))

        if partition is not None:
            _query_params.append(("partition", partition))

        if qos is not None:
            _query_params.append(("qos", qos))

        if usage_end is not None:
            _query_params.append(("usage_end", usage_end))

        if usage_start is not None:
            _query_params.append(("usage_start", usage_start))

        if user is not None:
            _query_params.append(("user", user))

        if with_usage is not None:
            _query_params.append(("with_usage", with_usage))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        if with_raw_qos is not None:
            _query_params.append(("with_raw_qos", with_raw_qos))

        if with_sub_accts is not None:
            _query_params.append(("with_sub_accts", with_sub_accts))

        if without_parent_info is not None:
            _query_params.append(("without_parent_info", without_parent_info))

        if without_parent_limits is not None:
            _query_params.append(("without_parent_limits", without_parent_limits))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/association/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_associations(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIAssocsResp:
        """Get association list


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_associations_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_associations_with_http_info(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIAssocsResp]:
        """Get association list


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_associations_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_associations_without_preload_content(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV accounts list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        default_qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Filter to only defaults")
        ] = None,
        parent_account: Annotated[
            Optional[StrictStr], Field(description="CSV names of parent account")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[Optional[StrictStr], Field(description="CSV QOS list")] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted associations")
        ] = None,
        with_raw_qos: Annotated[
            Optional[StrictStr], Field(description="Include a raw qos or delta_qos")
        ] = None,
        with_sub_accts: Annotated[
            Optional[StrictStr], Field(description="Include sub acct information")
        ] = None,
        without_parent_info: Annotated[
            Optional[StrictStr], Field(description="Exclude parent id/name")
        ] = None,
        without_parent_limits: Annotated[
            Optional[StrictStr], Field(description="Exclude limits from parents")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get association list


        :param account: CSV accounts list
        :type account: str
        :param cluster: CSV clusters list
        :type cluster: str
        :param default_qos: CSV QOS list
        :type default_qos: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param only_defaults: Filter to only defaults
        :type only_defaults: str
        :param parent_account: CSV names of parent account
        :type parent_account: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS list
        :type qos: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted associations
        :type with_deleted: str
        :param with_raw_qos: Include a raw qos or delta_qos
        :type with_raw_qos: str
        :param with_sub_accts: Include sub acct information
        :type with_sub_accts: str
        :param without_parent_info: Exclude parent id/name
        :type without_parent_info: str
        :param without_parent_limits: Exclude limits from parents
        :type without_parent_limits: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_associations_serialize(
            account=account,
            cluster=cluster,
            default_qos=default_qos,
            format=format,
            id=id,
            only_defaults=only_defaults,
            parent_account=parent_account,
            partition=partition,
            qos=qos,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            with_raw_qos=with_raw_qos,
            with_sub_accts=with_sub_accts,
            without_parent_info=without_parent_info,
            without_parent_limits=without_parent_limits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAssocsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_associations_serialize(
        self,
        account,
        cluster,
        default_qos,
        format,
        id,
        only_defaults,
        parent_account,
        partition,
        qos,
        usage_end,
        usage_start,
        user,
        with_usage,
        with_deleted,
        with_raw_qos,
        with_sub_accts,
        without_parent_info,
        without_parent_limits,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if account is not None:
            _query_params.append(("account", account))

        if cluster is not None:
            _query_params.append(("cluster", cluster))

        if default_qos is not None:
            _query_params.append(("default_qos", default_qos))

        if format is not None:
            _query_params.append(("format", format))

        if id is not None:
            _query_params.append(("id", id))

        if only_defaults is not None:
            _query_params.append(("only_defaults", only_defaults))

        if parent_account is not None:
            _query_params.append(("parent_account", parent_account))

        if partition is not None:
            _query_params.append(("partition", partition))

        if qos is not None:
            _query_params.append(("qos", qos))

        if usage_end is not None:
            _query_params.append(("usage_end", usage_end))

        if usage_start is not None:
            _query_params.append(("usage_start", usage_start))

        if user is not None:
            _query_params.append(("user", user))

        if with_usage is not None:
            _query_params.append(("with_usage", with_usage))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        if with_raw_qos is not None:
            _query_params.append(("with_raw_qos", with_raw_qos))

        if with_sub_accts is not None:
            _query_params.append(("with_sub_accts", with_sub_accts))

        if without_parent_info is not None:
            _query_params.append(("without_parent_info", without_parent_info))

        if without_parent_limits is not None:
            _query_params.append(("without_parent_limits", without_parent_limits))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/associations/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_cluster(
        self,
        cluster_name: Annotated[StrictStr, Field(description="Cluster name")],
        classification: Annotated[
            Optional[StrictStr], Field(description="Type of machine")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster list")
        ] = None,
        federation: Annotated[
            Optional[StrictStr], Field(description="CSV federation list")
        ] = None,
        flags: Annotated[Optional[StrictStr], Field(description="Query flags")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        rpc_version: Annotated[
            Optional[StrictStr], Field(description="CSV RPC version list")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted clusters")
        ] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIClustersResp:
        """Get cluster info


        :param cluster_name: Cluster name (required)
        :type cluster_name: str
        :param classification: Type of machine
        :type classification: str
        :param cluster: CSV cluster list
        :type cluster: str
        :param federation: CSV federation list
        :type federation: str
        :param flags: Query flags
        :type flags: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param rpc_version: CSV RPC version list
        :type rpc_version: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param with_deleted: Include deleted clusters
        :type with_deleted: str
        :param with_usage: Include usage
        :type with_usage: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_cluster_serialize(
            cluster_name=cluster_name,
            classification=classification,
            cluster=cluster,
            federation=federation,
            flags=flags,
            format=format,
            rpc_version=rpc_version,
            usage_end=usage_end,
            usage_start=usage_start,
            with_deleted=with_deleted,
            with_usage=with_usage,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIClustersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_cluster_with_http_info(
        self,
        cluster_name: Annotated[StrictStr, Field(description="Cluster name")],
        classification: Annotated[
            Optional[StrictStr], Field(description="Type of machine")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster list")
        ] = None,
        federation: Annotated[
            Optional[StrictStr], Field(description="CSV federation list")
        ] = None,
        flags: Annotated[Optional[StrictStr], Field(description="Query flags")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        rpc_version: Annotated[
            Optional[StrictStr], Field(description="CSV RPC version list")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted clusters")
        ] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIClustersResp]:
        """Get cluster info


        :param cluster_name: Cluster name (required)
        :type cluster_name: str
        :param classification: Type of machine
        :type classification: str
        :param cluster: CSV cluster list
        :type cluster: str
        :param federation: CSV federation list
        :type federation: str
        :param flags: Query flags
        :type flags: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param rpc_version: CSV RPC version list
        :type rpc_version: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param with_deleted: Include deleted clusters
        :type with_deleted: str
        :param with_usage: Include usage
        :type with_usage: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_cluster_serialize(
            cluster_name=cluster_name,
            classification=classification,
            cluster=cluster,
            federation=federation,
            flags=flags,
            format=format,
            rpc_version=rpc_version,
            usage_end=usage_end,
            usage_start=usage_start,
            with_deleted=with_deleted,
            with_usage=with_usage,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIClustersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_cluster_without_preload_content(
        self,
        cluster_name: Annotated[StrictStr, Field(description="Cluster name")],
        classification: Annotated[
            Optional[StrictStr], Field(description="Type of machine")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster list")
        ] = None,
        federation: Annotated[
            Optional[StrictStr], Field(description="CSV federation list")
        ] = None,
        flags: Annotated[Optional[StrictStr], Field(description="Query flags")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        rpc_version: Annotated[
            Optional[StrictStr], Field(description="CSV RPC version list")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted clusters")
        ] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get cluster info


        :param cluster_name: Cluster name (required)
        :type cluster_name: str
        :param classification: Type of machine
        :type classification: str
        :param cluster: CSV cluster list
        :type cluster: str
        :param federation: CSV federation list
        :type federation: str
        :param flags: Query flags
        :type flags: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param rpc_version: CSV RPC version list
        :type rpc_version: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param with_deleted: Include deleted clusters
        :type with_deleted: str
        :param with_usage: Include usage
        :type with_usage: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_cluster_serialize(
            cluster_name=cluster_name,
            classification=classification,
            cluster=cluster,
            federation=federation,
            flags=flags,
            format=format,
            rpc_version=rpc_version,
            usage_end=usage_end,
            usage_start=usage_start,
            with_deleted=with_deleted,
            with_usage=with_usage,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIClustersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_cluster_serialize(
        self,
        cluster_name,
        classification,
        cluster,
        federation,
        flags,
        format,
        rpc_version,
        usage_end,
        usage_start,
        with_deleted,
        with_usage,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cluster_name is not None:
            _path_params["cluster_name"] = cluster_name
        # process the query parameters
        if classification is not None:
            _query_params.append(("classification", classification))

        if cluster is not None:
            _query_params.append(("cluster", cluster))

        if federation is not None:
            _query_params.append(("federation", federation))

        if flags is not None:
            _query_params.append(("flags", flags))

        if format is not None:
            _query_params.append(("format", format))

        if rpc_version is not None:
            _query_params.append(("rpc_version", rpc_version))

        if usage_end is not None:
            _query_params.append(("usage_end", usage_end))

        if usage_start is not None:
            _query_params.append(("usage_start", usage_start))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        if with_usage is not None:
            _query_params.append(("with_usage", with_usage))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/cluster/{cluster_name}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_clusters(
        self,
        update_time: Annotated[
            Optional[StrictStr],
            Field(description="Filter reservations since update timestamp"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIClustersResp:
        """Get cluster list


        :param update_time: Filter reservations since update timestamp
        :type update_time: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_clusters_serialize(
            update_time=update_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIClustersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_clusters_with_http_info(
        self,
        update_time: Annotated[
            Optional[StrictStr],
            Field(description="Filter reservations since update timestamp"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIClustersResp]:
        """Get cluster list


        :param update_time: Filter reservations since update timestamp
        :type update_time: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_clusters_serialize(
            update_time=update_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIClustersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_clusters_without_preload_content(
        self,
        update_time: Annotated[
            Optional[StrictStr],
            Field(description="Filter reservations since update timestamp"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get cluster list


        :param update_time: Filter reservations since update timestamp
        :type update_time: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_clusters_serialize(
            update_time=update_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIClustersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_clusters_serialize(
        self,
        update_time,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if update_time is not None:
            _query_params.append(("update_time", update_time))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/clusters/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_config(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPISlurmdbdConfigResp:
        """Dump all configuration information


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_config_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdConfigResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_config_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPISlurmdbdConfigResp]:
        """Dump all configuration information


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_config_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdConfigResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_config_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Dump all configuration information


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_config_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdConfigResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_config_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/config",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_diag(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPISlurmdbdStatsResp:
        """Get slurmdb diagnostics


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_diag_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdStatsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_diag_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPISlurmdbdStatsResp]:
        """Get slurmdb diagnostics


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_diag_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdStatsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_diag_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get slurmdb diagnostics


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_diag_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdStatsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_diag_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/diag/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_instance(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        extra: Annotated[
            Optional[StrictStr], Field(description="CSV extra list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        instance_id: Annotated[
            Optional[StrictStr], Field(description="CSV instance_id list")
        ] = None,
        instance_type: Annotated[
            Optional[StrictStr], Field(description="CSV instance_type list")
        ] = None,
        node_list: Annotated[
            Optional[StrictStr], Field(description="Ranged node string")
        ] = None,
        time_end: Annotated[
            Optional[StrictStr], Field(description="Time end (UNIX timestamp)")
        ] = None,
        time_start: Annotated[
            Optional[StrictStr], Field(description="Time start (UNIX timestamp)")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIInstancesResp:
        """Get instance info


        :param cluster: CSV clusters list
        :type cluster: str
        :param extra: CSV extra list
        :type extra: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param instance_id: CSV instance_id list
        :type instance_id: str
        :param instance_type: CSV instance_type list
        :type instance_type: str
        :param node_list: Ranged node string
        :type node_list: str
        :param time_end: Time end (UNIX timestamp)
        :type time_end: str
        :param time_start: Time start (UNIX timestamp)
        :type time_start: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_instance_serialize(
            cluster=cluster,
            extra=extra,
            format=format,
            instance_id=instance_id,
            instance_type=instance_type,
            node_list=node_list,
            time_end=time_end,
            time_start=time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIInstancesResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_instance_with_http_info(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        extra: Annotated[
            Optional[StrictStr], Field(description="CSV extra list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        instance_id: Annotated[
            Optional[StrictStr], Field(description="CSV instance_id list")
        ] = None,
        instance_type: Annotated[
            Optional[StrictStr], Field(description="CSV instance_type list")
        ] = None,
        node_list: Annotated[
            Optional[StrictStr], Field(description="Ranged node string")
        ] = None,
        time_end: Annotated[
            Optional[StrictStr], Field(description="Time end (UNIX timestamp)")
        ] = None,
        time_start: Annotated[
            Optional[StrictStr], Field(description="Time start (UNIX timestamp)")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIInstancesResp]:
        """Get instance info


        :param cluster: CSV clusters list
        :type cluster: str
        :param extra: CSV extra list
        :type extra: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param instance_id: CSV instance_id list
        :type instance_id: str
        :param instance_type: CSV instance_type list
        :type instance_type: str
        :param node_list: Ranged node string
        :type node_list: str
        :param time_end: Time end (UNIX timestamp)
        :type time_end: str
        :param time_start: Time start (UNIX timestamp)
        :type time_start: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_instance_serialize(
            cluster=cluster,
            extra=extra,
            format=format,
            instance_id=instance_id,
            instance_type=instance_type,
            node_list=node_list,
            time_end=time_end,
            time_start=time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIInstancesResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_instance_without_preload_content(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        extra: Annotated[
            Optional[StrictStr], Field(description="CSV extra list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        instance_id: Annotated[
            Optional[StrictStr], Field(description="CSV instance_id list")
        ] = None,
        instance_type: Annotated[
            Optional[StrictStr], Field(description="CSV instance_type list")
        ] = None,
        node_list: Annotated[
            Optional[StrictStr], Field(description="Ranged node string")
        ] = None,
        time_end: Annotated[
            Optional[StrictStr], Field(description="Time end (UNIX timestamp)")
        ] = None,
        time_start: Annotated[
            Optional[StrictStr], Field(description="Time start (UNIX timestamp)")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get instance info


        :param cluster: CSV clusters list
        :type cluster: str
        :param extra: CSV extra list
        :type extra: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param instance_id: CSV instance_id list
        :type instance_id: str
        :param instance_type: CSV instance_type list
        :type instance_type: str
        :param node_list: Ranged node string
        :type node_list: str
        :param time_end: Time end (UNIX timestamp)
        :type time_end: str
        :param time_start: Time start (UNIX timestamp)
        :type time_start: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_instance_serialize(
            cluster=cluster,
            extra=extra,
            format=format,
            instance_id=instance_id,
            instance_type=instance_type,
            node_list=node_list,
            time_end=time_end,
            time_start=time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIInstancesResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_instance_serialize(
        self,
        cluster,
        extra,
        format,
        instance_id,
        instance_type,
        node_list,
        time_end,
        time_start,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if cluster is not None:
            _query_params.append(("cluster", cluster))

        if extra is not None:
            _query_params.append(("extra", extra))

        if format is not None:
            _query_params.append(("format", format))

        if instance_id is not None:
            _query_params.append(("instance_id", instance_id))

        if instance_type is not None:
            _query_params.append(("instance_type", instance_type))

        if node_list is not None:
            _query_params.append(("node_list", node_list))

        if time_end is not None:
            _query_params.append(("time_end", time_end))

        if time_start is not None:
            _query_params.append(("time_start", time_start))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/instance/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_instances(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        extra: Annotated[
            Optional[StrictStr], Field(description="CSV extra list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        instance_id: Annotated[
            Optional[StrictStr], Field(description="CSV instance_id list")
        ] = None,
        instance_type: Annotated[
            Optional[StrictStr], Field(description="CSV instance_type list")
        ] = None,
        node_list: Annotated[
            Optional[StrictStr], Field(description="Ranged node string")
        ] = None,
        time_end: Annotated[
            Optional[StrictStr], Field(description="Time end (UNIX timestamp)")
        ] = None,
        time_start: Annotated[
            Optional[StrictStr], Field(description="Time start (UNIX timestamp)")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIInstancesResp:
        """Get instance list


        :param cluster: CSV clusters list
        :type cluster: str
        :param extra: CSV extra list
        :type extra: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param instance_id: CSV instance_id list
        :type instance_id: str
        :param instance_type: CSV instance_type list
        :type instance_type: str
        :param node_list: Ranged node string
        :type node_list: str
        :param time_end: Time end (UNIX timestamp)
        :type time_end: str
        :param time_start: Time start (UNIX timestamp)
        :type time_start: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_instances_serialize(
            cluster=cluster,
            extra=extra,
            format=format,
            instance_id=instance_id,
            instance_type=instance_type,
            node_list=node_list,
            time_end=time_end,
            time_start=time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIInstancesResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_instances_with_http_info(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        extra: Annotated[
            Optional[StrictStr], Field(description="CSV extra list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        instance_id: Annotated[
            Optional[StrictStr], Field(description="CSV instance_id list")
        ] = None,
        instance_type: Annotated[
            Optional[StrictStr], Field(description="CSV instance_type list")
        ] = None,
        node_list: Annotated[
            Optional[StrictStr], Field(description="Ranged node string")
        ] = None,
        time_end: Annotated[
            Optional[StrictStr], Field(description="Time end (UNIX timestamp)")
        ] = None,
        time_start: Annotated[
            Optional[StrictStr], Field(description="Time start (UNIX timestamp)")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIInstancesResp]:
        """Get instance list


        :param cluster: CSV clusters list
        :type cluster: str
        :param extra: CSV extra list
        :type extra: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param instance_id: CSV instance_id list
        :type instance_id: str
        :param instance_type: CSV instance_type list
        :type instance_type: str
        :param node_list: Ranged node string
        :type node_list: str
        :param time_end: Time end (UNIX timestamp)
        :type time_end: str
        :param time_start: Time start (UNIX timestamp)
        :type time_start: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_instances_serialize(
            cluster=cluster,
            extra=extra,
            format=format,
            instance_id=instance_id,
            instance_type=instance_type,
            node_list=node_list,
            time_end=time_end,
            time_start=time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIInstancesResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_instances_without_preload_content(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV clusters list")
        ] = None,
        extra: Annotated[
            Optional[StrictStr], Field(description="CSV extra list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        instance_id: Annotated[
            Optional[StrictStr], Field(description="CSV instance_id list")
        ] = None,
        instance_type: Annotated[
            Optional[StrictStr], Field(description="CSV instance_type list")
        ] = None,
        node_list: Annotated[
            Optional[StrictStr], Field(description="Ranged node string")
        ] = None,
        time_end: Annotated[
            Optional[StrictStr], Field(description="Time end (UNIX timestamp)")
        ] = None,
        time_start: Annotated[
            Optional[StrictStr], Field(description="Time start (UNIX timestamp)")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get instance list


        :param cluster: CSV clusters list
        :type cluster: str
        :param extra: CSV extra list
        :type extra: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param instance_id: CSV instance_id list
        :type instance_id: str
        :param instance_type: CSV instance_type list
        :type instance_type: str
        :param node_list: Ranged node string
        :type node_list: str
        :param time_end: Time end (UNIX timestamp)
        :type time_end: str
        :param time_start: Time start (UNIX timestamp)
        :type time_start: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_instances_serialize(
            cluster=cluster,
            extra=extra,
            format=format,
            instance_id=instance_id,
            instance_type=instance_type,
            node_list=node_list,
            time_end=time_end,
            time_start=time_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIInstancesResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_instances_serialize(
        self,
        cluster,
        extra,
        format,
        instance_id,
        instance_type,
        node_list,
        time_end,
        time_start,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if cluster is not None:
            _query_params.append(("cluster", cluster))

        if extra is not None:
            _query_params.append(("extra", extra))

        if format is not None:
            _query_params.append(("format", format))

        if instance_id is not None:
            _query_params.append(("instance_id", instance_id))

        if instance_type is not None:
            _query_params.append(("instance_type", instance_type))

        if node_list is not None:
            _query_params.append(("node_list", node_list))

        if time_end is not None:
            _query_params.append(("time_end", time_end))

        if time_start is not None:
            _query_params.append(("time_start", time_start))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/instances/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_job(
        self,
        job_id: Annotated[StrictStr, Field(description="Job id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPISlurmdbdJobsResp:
        """Get job info

        This endpoint may return multiple job entries since job_id is not a unique key - only the tuple (cluster, job_id, start_time) is unique. If the requested job_id is a component of a heterogeneous job all components are returned.

        :param job_id: Job id (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_job_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdJobsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_job_with_http_info(
        self,
        job_id: Annotated[StrictStr, Field(description="Job id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPISlurmdbdJobsResp]:
        """Get job info

        This endpoint may return multiple job entries since job_id is not a unique key - only the tuple (cluster, job_id, start_time) is unique. If the requested job_id is a component of a heterogeneous job all components are returned.

        :param job_id: Job id (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_job_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdJobsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_job_without_preload_content(
        self,
        job_id: Annotated[StrictStr, Field(description="Job id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get job info

        This endpoint may return multiple job entries since job_id is not a unique key - only the tuple (cluster, job_id, start_time) is unique. If the requested job_id is a component of a heterogeneous job all components are returned.

        :param job_id: Job id (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_job_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdJobsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_job_serialize(
        self,
        job_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params["job_id"] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/job/{job_id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_jobs(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV account list")
        ] = None,
        association: Annotated[
            Optional[StrictStr], Field(description="CSV association list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster list")
        ] = None,
        constraints: Annotated[
            Optional[StrictStr], Field(description="CSV constraint list")
        ] = None,
        scheduler_unset: Annotated[
            Optional[StrictStr], Field(description="Schedule bits not set")
        ] = None,
        scheduled_on_submit: Annotated[
            Optional[StrictStr], Field(description="Job was started on submit")
        ] = None,
        scheduled_by_main: Annotated[
            Optional[StrictStr],
            Field(description="Job was started from main scheduler"),
        ] = None,
        scheduled_by_backfill: Annotated[
            Optional[StrictStr], Field(description="Job was started from backfill")
        ] = None,
        job_started: Annotated[
            Optional[StrictStr], Field(description="Job start RPC was received")
        ] = None,
        exit_code: Annotated[
            Optional[StrictStr], Field(description="Job exit code (numeric)")
        ] = None,
        show_duplicates: Annotated[
            Optional[StrictStr], Field(description="Include duplicate job entries")
        ] = None,
        skip_steps: Annotated[
            Optional[StrictStr], Field(description="Exclude job step details")
        ] = None,
        disable_truncate_usage_time: Annotated[
            Optional[StrictStr],
            Field(description="Do not truncate the time to usage_start and usage_end"),
        ] = None,
        whole_hetjob: Annotated[
            Optional[StrictStr],
            Field(description="Include details on all hetjob components"),
        ] = None,
        disable_whole_hetjob: Annotated[
            Optional[StrictStr],
            Field(description="Only show details on specified hetjob components"),
        ] = None,
        disable_wait_for_result: Annotated[
            Optional[StrictStr],
            Field(description="Tell dbd not to wait for the result"),
        ] = None,
        usage_time_as_submit_time: Annotated[
            Optional[StrictStr],
            Field(description="Use usage_time as the submit_time of the job"),
        ] = None,
        show_batch_script: Annotated[
            Optional[StrictStr], Field(description="Include job script")
        ] = None,
        show_job_environment: Annotated[
            Optional[StrictStr], Field(description="Include job environment")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        groups: Annotated[
            Optional[StrictStr], Field(description="CSV group list")
        ] = None,
        job_name: Annotated[
            Optional[StrictStr], Field(description="CSV job name list")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS name list")
        ] = None,
        reason: Annotated[
            Optional[StrictStr], Field(description="CSV reason list")
        ] = None,
        reservation: Annotated[
            Optional[StrictStr], Field(description="CSV reservation name list")
        ] = None,
        reservation_id: Annotated[
            Optional[StrictStr], Field(description="CSV reservation ID list")
        ] = None,
        state: Annotated[
            Optional[StrictStr], Field(description="CSV state list")
        ] = None,
        step: Annotated[
            Optional[StrictStr], Field(description="CSV step id list")
        ] = None,
        end_time: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        start_time: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        node: Annotated[
            Optional[StrictStr], Field(description="Ranged node string where jobs ran")
        ] = None,
        users: Annotated[
            Optional[StrictStr], Field(description="CSV user name list")
        ] = None,
        wckey: Annotated[
            Optional[StrictStr], Field(description="CSV wckey list")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPISlurmdbdJobsResp:
        """Get job list


        :param account: CSV account list
        :type account: str
        :param association: CSV association list
        :type association: str
        :param cluster: CSV cluster list
        :type cluster: str
        :param constraints: CSV constraint list
        :type constraints: str
        :param scheduler_unset: Schedule bits not set
        :type scheduler_unset: str
        :param scheduled_on_submit: Job was started on submit
        :type scheduled_on_submit: str
        :param scheduled_by_main: Job was started from main scheduler
        :type scheduled_by_main: str
        :param scheduled_by_backfill: Job was started from backfill
        :type scheduled_by_backfill: str
        :param job_started: Job start RPC was received
        :type job_started: str
        :param exit_code: Job exit code (numeric)
        :type exit_code: str
        :param show_duplicates: Include duplicate job entries
        :type show_duplicates: str
        :param skip_steps: Exclude job step details
        :type skip_steps: str
        :param disable_truncate_usage_time: Do not truncate the time to usage_start and usage_end
        :type disable_truncate_usage_time: str
        :param whole_hetjob: Include details on all hetjob components
        :type whole_hetjob: str
        :param disable_whole_hetjob: Only show details on specified hetjob components
        :type disable_whole_hetjob: str
        :param disable_wait_for_result: Tell dbd not to wait for the result
        :type disable_wait_for_result: str
        :param usage_time_as_submit_time: Use usage_time as the submit_time of the job
        :type usage_time_as_submit_time: str
        :param show_batch_script: Include job script
        :type show_batch_script: str
        :param show_job_environment: Include job environment
        :type show_job_environment: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param groups: CSV group list
        :type groups: str
        :param job_name: CSV job name list
        :type job_name: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS name list
        :type qos: str
        :param reason: CSV reason list
        :type reason: str
        :param reservation: CSV reservation name list
        :type reservation: str
        :param reservation_id: CSV reservation ID list
        :type reservation_id: str
        :param state: CSV state list
        :type state: str
        :param step: CSV step id list
        :type step: str
        :param end_time: Usage end (UNIX timestamp)
        :type end_time: str
        :param start_time: Usage start (UNIX timestamp)
        :type start_time: str
        :param node: Ranged node string where jobs ran
        :type node: str
        :param users: CSV user name list
        :type users: str
        :param wckey: CSV wckey list
        :type wckey: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_jobs_serialize(
            account=account,
            association=association,
            cluster=cluster,
            constraints=constraints,
            scheduler_unset=scheduler_unset,
            scheduled_on_submit=scheduled_on_submit,
            scheduled_by_main=scheduled_by_main,
            scheduled_by_backfill=scheduled_by_backfill,
            job_started=job_started,
            exit_code=exit_code,
            show_duplicates=show_duplicates,
            skip_steps=skip_steps,
            disable_truncate_usage_time=disable_truncate_usage_time,
            whole_hetjob=whole_hetjob,
            disable_whole_hetjob=disable_whole_hetjob,
            disable_wait_for_result=disable_wait_for_result,
            usage_time_as_submit_time=usage_time_as_submit_time,
            show_batch_script=show_batch_script,
            show_job_environment=show_job_environment,
            format=format,
            groups=groups,
            job_name=job_name,
            partition=partition,
            qos=qos,
            reason=reason,
            reservation=reservation,
            reservation_id=reservation_id,
            state=state,
            step=step,
            end_time=end_time,
            start_time=start_time,
            node=node,
            users=users,
            wckey=wckey,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdJobsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_jobs_with_http_info(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV account list")
        ] = None,
        association: Annotated[
            Optional[StrictStr], Field(description="CSV association list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster list")
        ] = None,
        constraints: Annotated[
            Optional[StrictStr], Field(description="CSV constraint list")
        ] = None,
        scheduler_unset: Annotated[
            Optional[StrictStr], Field(description="Schedule bits not set")
        ] = None,
        scheduled_on_submit: Annotated[
            Optional[StrictStr], Field(description="Job was started on submit")
        ] = None,
        scheduled_by_main: Annotated[
            Optional[StrictStr],
            Field(description="Job was started from main scheduler"),
        ] = None,
        scheduled_by_backfill: Annotated[
            Optional[StrictStr], Field(description="Job was started from backfill")
        ] = None,
        job_started: Annotated[
            Optional[StrictStr], Field(description="Job start RPC was received")
        ] = None,
        exit_code: Annotated[
            Optional[StrictStr], Field(description="Job exit code (numeric)")
        ] = None,
        show_duplicates: Annotated[
            Optional[StrictStr], Field(description="Include duplicate job entries")
        ] = None,
        skip_steps: Annotated[
            Optional[StrictStr], Field(description="Exclude job step details")
        ] = None,
        disable_truncate_usage_time: Annotated[
            Optional[StrictStr],
            Field(description="Do not truncate the time to usage_start and usage_end"),
        ] = None,
        whole_hetjob: Annotated[
            Optional[StrictStr],
            Field(description="Include details on all hetjob components"),
        ] = None,
        disable_whole_hetjob: Annotated[
            Optional[StrictStr],
            Field(description="Only show details on specified hetjob components"),
        ] = None,
        disable_wait_for_result: Annotated[
            Optional[StrictStr],
            Field(description="Tell dbd not to wait for the result"),
        ] = None,
        usage_time_as_submit_time: Annotated[
            Optional[StrictStr],
            Field(description="Use usage_time as the submit_time of the job"),
        ] = None,
        show_batch_script: Annotated[
            Optional[StrictStr], Field(description="Include job script")
        ] = None,
        show_job_environment: Annotated[
            Optional[StrictStr], Field(description="Include job environment")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        groups: Annotated[
            Optional[StrictStr], Field(description="CSV group list")
        ] = None,
        job_name: Annotated[
            Optional[StrictStr], Field(description="CSV job name list")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS name list")
        ] = None,
        reason: Annotated[
            Optional[StrictStr], Field(description="CSV reason list")
        ] = None,
        reservation: Annotated[
            Optional[StrictStr], Field(description="CSV reservation name list")
        ] = None,
        reservation_id: Annotated[
            Optional[StrictStr], Field(description="CSV reservation ID list")
        ] = None,
        state: Annotated[
            Optional[StrictStr], Field(description="CSV state list")
        ] = None,
        step: Annotated[
            Optional[StrictStr], Field(description="CSV step id list")
        ] = None,
        end_time: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        start_time: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        node: Annotated[
            Optional[StrictStr], Field(description="Ranged node string where jobs ran")
        ] = None,
        users: Annotated[
            Optional[StrictStr], Field(description="CSV user name list")
        ] = None,
        wckey: Annotated[
            Optional[StrictStr], Field(description="CSV wckey list")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPISlurmdbdJobsResp]:
        """Get job list


        :param account: CSV account list
        :type account: str
        :param association: CSV association list
        :type association: str
        :param cluster: CSV cluster list
        :type cluster: str
        :param constraints: CSV constraint list
        :type constraints: str
        :param scheduler_unset: Schedule bits not set
        :type scheduler_unset: str
        :param scheduled_on_submit: Job was started on submit
        :type scheduled_on_submit: str
        :param scheduled_by_main: Job was started from main scheduler
        :type scheduled_by_main: str
        :param scheduled_by_backfill: Job was started from backfill
        :type scheduled_by_backfill: str
        :param job_started: Job start RPC was received
        :type job_started: str
        :param exit_code: Job exit code (numeric)
        :type exit_code: str
        :param show_duplicates: Include duplicate job entries
        :type show_duplicates: str
        :param skip_steps: Exclude job step details
        :type skip_steps: str
        :param disable_truncate_usage_time: Do not truncate the time to usage_start and usage_end
        :type disable_truncate_usage_time: str
        :param whole_hetjob: Include details on all hetjob components
        :type whole_hetjob: str
        :param disable_whole_hetjob: Only show details on specified hetjob components
        :type disable_whole_hetjob: str
        :param disable_wait_for_result: Tell dbd not to wait for the result
        :type disable_wait_for_result: str
        :param usage_time_as_submit_time: Use usage_time as the submit_time of the job
        :type usage_time_as_submit_time: str
        :param show_batch_script: Include job script
        :type show_batch_script: str
        :param show_job_environment: Include job environment
        :type show_job_environment: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param groups: CSV group list
        :type groups: str
        :param job_name: CSV job name list
        :type job_name: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS name list
        :type qos: str
        :param reason: CSV reason list
        :type reason: str
        :param reservation: CSV reservation name list
        :type reservation: str
        :param reservation_id: CSV reservation ID list
        :type reservation_id: str
        :param state: CSV state list
        :type state: str
        :param step: CSV step id list
        :type step: str
        :param end_time: Usage end (UNIX timestamp)
        :type end_time: str
        :param start_time: Usage start (UNIX timestamp)
        :type start_time: str
        :param node: Ranged node string where jobs ran
        :type node: str
        :param users: CSV user name list
        :type users: str
        :param wckey: CSV wckey list
        :type wckey: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_jobs_serialize(
            account=account,
            association=association,
            cluster=cluster,
            constraints=constraints,
            scheduler_unset=scheduler_unset,
            scheduled_on_submit=scheduled_on_submit,
            scheduled_by_main=scheduled_by_main,
            scheduled_by_backfill=scheduled_by_backfill,
            job_started=job_started,
            exit_code=exit_code,
            show_duplicates=show_duplicates,
            skip_steps=skip_steps,
            disable_truncate_usage_time=disable_truncate_usage_time,
            whole_hetjob=whole_hetjob,
            disable_whole_hetjob=disable_whole_hetjob,
            disable_wait_for_result=disable_wait_for_result,
            usage_time_as_submit_time=usage_time_as_submit_time,
            show_batch_script=show_batch_script,
            show_job_environment=show_job_environment,
            format=format,
            groups=groups,
            job_name=job_name,
            partition=partition,
            qos=qos,
            reason=reason,
            reservation=reservation,
            reservation_id=reservation_id,
            state=state,
            step=step,
            end_time=end_time,
            start_time=start_time,
            node=node,
            users=users,
            wckey=wckey,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdJobsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_jobs_without_preload_content(
        self,
        account: Annotated[
            Optional[StrictStr], Field(description="CSV account list")
        ] = None,
        association: Annotated[
            Optional[StrictStr], Field(description="CSV association list")
        ] = None,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster list")
        ] = None,
        constraints: Annotated[
            Optional[StrictStr], Field(description="CSV constraint list")
        ] = None,
        scheduler_unset: Annotated[
            Optional[StrictStr], Field(description="Schedule bits not set")
        ] = None,
        scheduled_on_submit: Annotated[
            Optional[StrictStr], Field(description="Job was started on submit")
        ] = None,
        scheduled_by_main: Annotated[
            Optional[StrictStr],
            Field(description="Job was started from main scheduler"),
        ] = None,
        scheduled_by_backfill: Annotated[
            Optional[StrictStr], Field(description="Job was started from backfill")
        ] = None,
        job_started: Annotated[
            Optional[StrictStr], Field(description="Job start RPC was received")
        ] = None,
        exit_code: Annotated[
            Optional[StrictStr], Field(description="Job exit code (numeric)")
        ] = None,
        show_duplicates: Annotated[
            Optional[StrictStr], Field(description="Include duplicate job entries")
        ] = None,
        skip_steps: Annotated[
            Optional[StrictStr], Field(description="Exclude job step details")
        ] = None,
        disable_truncate_usage_time: Annotated[
            Optional[StrictStr],
            Field(description="Do not truncate the time to usage_start and usage_end"),
        ] = None,
        whole_hetjob: Annotated[
            Optional[StrictStr],
            Field(description="Include details on all hetjob components"),
        ] = None,
        disable_whole_hetjob: Annotated[
            Optional[StrictStr],
            Field(description="Only show details on specified hetjob components"),
        ] = None,
        disable_wait_for_result: Annotated[
            Optional[StrictStr],
            Field(description="Tell dbd not to wait for the result"),
        ] = None,
        usage_time_as_submit_time: Annotated[
            Optional[StrictStr],
            Field(description="Use usage_time as the submit_time of the job"),
        ] = None,
        show_batch_script: Annotated[
            Optional[StrictStr], Field(description="Include job script")
        ] = None,
        show_job_environment: Annotated[
            Optional[StrictStr], Field(description="Include job environment")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        groups: Annotated[
            Optional[StrictStr], Field(description="CSV group list")
        ] = None,
        job_name: Annotated[
            Optional[StrictStr], Field(description="CSV job name list")
        ] = None,
        partition: Annotated[
            Optional[StrictStr], Field(description="CSV partition name list")
        ] = None,
        qos: Annotated[
            Optional[StrictStr], Field(description="CSV QOS name list")
        ] = None,
        reason: Annotated[
            Optional[StrictStr], Field(description="CSV reason list")
        ] = None,
        reservation: Annotated[
            Optional[StrictStr], Field(description="CSV reservation name list")
        ] = None,
        reservation_id: Annotated[
            Optional[StrictStr], Field(description="CSV reservation ID list")
        ] = None,
        state: Annotated[
            Optional[StrictStr], Field(description="CSV state list")
        ] = None,
        step: Annotated[
            Optional[StrictStr], Field(description="CSV step id list")
        ] = None,
        end_time: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        start_time: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        node: Annotated[
            Optional[StrictStr], Field(description="Ranged node string where jobs ran")
        ] = None,
        users: Annotated[
            Optional[StrictStr], Field(description="CSV user name list")
        ] = None,
        wckey: Annotated[
            Optional[StrictStr], Field(description="CSV wckey list")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get job list


        :param account: CSV account list
        :type account: str
        :param association: CSV association list
        :type association: str
        :param cluster: CSV cluster list
        :type cluster: str
        :param constraints: CSV constraint list
        :type constraints: str
        :param scheduler_unset: Schedule bits not set
        :type scheduler_unset: str
        :param scheduled_on_submit: Job was started on submit
        :type scheduled_on_submit: str
        :param scheduled_by_main: Job was started from main scheduler
        :type scheduled_by_main: str
        :param scheduled_by_backfill: Job was started from backfill
        :type scheduled_by_backfill: str
        :param job_started: Job start RPC was received
        :type job_started: str
        :param exit_code: Job exit code (numeric)
        :type exit_code: str
        :param show_duplicates: Include duplicate job entries
        :type show_duplicates: str
        :param skip_steps: Exclude job step details
        :type skip_steps: str
        :param disable_truncate_usage_time: Do not truncate the time to usage_start and usage_end
        :type disable_truncate_usage_time: str
        :param whole_hetjob: Include details on all hetjob components
        :type whole_hetjob: str
        :param disable_whole_hetjob: Only show details on specified hetjob components
        :type disable_whole_hetjob: str
        :param disable_wait_for_result: Tell dbd not to wait for the result
        :type disable_wait_for_result: str
        :param usage_time_as_submit_time: Use usage_time as the submit_time of the job
        :type usage_time_as_submit_time: str
        :param show_batch_script: Include job script
        :type show_batch_script: str
        :param show_job_environment: Include job environment
        :type show_job_environment: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param groups: CSV group list
        :type groups: str
        :param job_name: CSV job name list
        :type job_name: str
        :param partition: CSV partition name list
        :type partition: str
        :param qos: CSV QOS name list
        :type qos: str
        :param reason: CSV reason list
        :type reason: str
        :param reservation: CSV reservation name list
        :type reservation: str
        :param reservation_id: CSV reservation ID list
        :type reservation_id: str
        :param state: CSV state list
        :type state: str
        :param step: CSV step id list
        :type step: str
        :param end_time: Usage end (UNIX timestamp)
        :type end_time: str
        :param start_time: Usage start (UNIX timestamp)
        :type start_time: str
        :param node: Ranged node string where jobs ran
        :type node: str
        :param users: CSV user name list
        :type users: str
        :param wckey: CSV wckey list
        :type wckey: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_jobs_serialize(
            account=account,
            association=association,
            cluster=cluster,
            constraints=constraints,
            scheduler_unset=scheduler_unset,
            scheduled_on_submit=scheduled_on_submit,
            scheduled_by_main=scheduled_by_main,
            scheduled_by_backfill=scheduled_by_backfill,
            job_started=job_started,
            exit_code=exit_code,
            show_duplicates=show_duplicates,
            skip_steps=skip_steps,
            disable_truncate_usage_time=disable_truncate_usage_time,
            whole_hetjob=whole_hetjob,
            disable_whole_hetjob=disable_whole_hetjob,
            disable_wait_for_result=disable_wait_for_result,
            usage_time_as_submit_time=usage_time_as_submit_time,
            show_batch_script=show_batch_script,
            show_job_environment=show_job_environment,
            format=format,
            groups=groups,
            job_name=job_name,
            partition=partition,
            qos=qos,
            reason=reason,
            reservation=reservation,
            reservation_id=reservation_id,
            state=state,
            step=step,
            end_time=end_time,
            start_time=start_time,
            node=node,
            users=users,
            wckey=wckey,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdJobsResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_jobs_serialize(
        self,
        account,
        association,
        cluster,
        constraints,
        scheduler_unset,
        scheduled_on_submit,
        scheduled_by_main,
        scheduled_by_backfill,
        job_started,
        exit_code,
        show_duplicates,
        skip_steps,
        disable_truncate_usage_time,
        whole_hetjob,
        disable_whole_hetjob,
        disable_wait_for_result,
        usage_time_as_submit_time,
        show_batch_script,
        show_job_environment,
        format,
        groups,
        job_name,
        partition,
        qos,
        reason,
        reservation,
        reservation_id,
        state,
        step,
        end_time,
        start_time,
        node,
        users,
        wckey,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if account is not None:
            _query_params.append(("account", account))

        if association is not None:
            _query_params.append(("association", association))

        if cluster is not None:
            _query_params.append(("cluster", cluster))

        if constraints is not None:
            _query_params.append(("constraints", constraints))

        if scheduler_unset is not None:
            _query_params.append(("scheduler_unset", scheduler_unset))

        if scheduled_on_submit is not None:
            _query_params.append(("scheduled_on_submit", scheduled_on_submit))

        if scheduled_by_main is not None:
            _query_params.append(("scheduled_by_main", scheduled_by_main))

        if scheduled_by_backfill is not None:
            _query_params.append(("scheduled_by_backfill", scheduled_by_backfill))

        if job_started is not None:
            _query_params.append(("job_started", job_started))

        if exit_code is not None:
            _query_params.append(("exit_code", exit_code))

        if show_duplicates is not None:
            _query_params.append(("show_duplicates", show_duplicates))

        if skip_steps is not None:
            _query_params.append(("skip_steps", skip_steps))

        if disable_truncate_usage_time is not None:
            _query_params.append(
                ("disable_truncate_usage_time", disable_truncate_usage_time)
            )

        if whole_hetjob is not None:
            _query_params.append(("whole_hetjob", whole_hetjob))

        if disable_whole_hetjob is not None:
            _query_params.append(("disable_whole_hetjob", disable_whole_hetjob))

        if disable_wait_for_result is not None:
            _query_params.append(("disable_wait_for_result", disable_wait_for_result))

        if usage_time_as_submit_time is not None:
            _query_params.append(
                ("usage_time_as_submit_time", usage_time_as_submit_time)
            )

        if show_batch_script is not None:
            _query_params.append(("show_batch_script", show_batch_script))

        if show_job_environment is not None:
            _query_params.append(("show_job_environment", show_job_environment))

        if format is not None:
            _query_params.append(("format", format))

        if groups is not None:
            _query_params.append(("groups", groups))

        if job_name is not None:
            _query_params.append(("job_name", job_name))

        if partition is not None:
            _query_params.append(("partition", partition))

        if qos is not None:
            _query_params.append(("qos", qos))

        if reason is not None:
            _query_params.append(("reason", reason))

        if reservation is not None:
            _query_params.append(("reservation", reservation))

        if reservation_id is not None:
            _query_params.append(("reservation_id", reservation_id))

        if state is not None:
            _query_params.append(("state", state))

        if step is not None:
            _query_params.append(("step", step))

        if end_time is not None:
            _query_params.append(("end_time", end_time))

        if start_time is not None:
            _query_params.append(("start_time", start_time))

        if node is not None:
            _query_params.append(("node", node))

        if users is not None:
            _query_params.append(("users", users))

        if wckey is not None:
            _query_params.append(("wckey", wckey))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/jobs/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_qos(
        self,
        description: Annotated[
            Optional[StrictStr], Field(description="CSV description list")
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV QOS id list")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        name: Annotated[
            Optional[StrictStr], Field(description="CSV QOS name list")
        ] = None,
        preempt_mode: Annotated[
            Optional[StrictStr],
            Field(description="PreemptMode used when jobs in this QOS are preempted"),
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted QOS")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPISlurmdbdQosResp:
        """Get QOS list


        :param description: CSV description list
        :type description: str
        :param id: CSV QOS id list
        :type id: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param name: CSV QOS name list
        :type name: str
        :param preempt_mode: PreemptMode used when jobs in this QOS are preempted
        :type preempt_mode: str
        :param with_deleted: Include deleted QOS
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_qos_serialize(
            description=description,
            id=id,
            format=format,
            name=name,
            preempt_mode=preempt_mode,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdQosResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_qos_with_http_info(
        self,
        description: Annotated[
            Optional[StrictStr], Field(description="CSV description list")
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV QOS id list")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        name: Annotated[
            Optional[StrictStr], Field(description="CSV QOS name list")
        ] = None,
        preempt_mode: Annotated[
            Optional[StrictStr],
            Field(description="PreemptMode used when jobs in this QOS are preempted"),
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted QOS")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPISlurmdbdQosResp]:
        """Get QOS list


        :param description: CSV description list
        :type description: str
        :param id: CSV QOS id list
        :type id: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param name: CSV QOS name list
        :type name: str
        :param preempt_mode: PreemptMode used when jobs in this QOS are preempted
        :type preempt_mode: str
        :param with_deleted: Include deleted QOS
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_qos_serialize(
            description=description,
            id=id,
            format=format,
            name=name,
            preempt_mode=preempt_mode,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdQosResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_qos_without_preload_content(
        self,
        description: Annotated[
            Optional[StrictStr], Field(description="CSV description list")
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV QOS id list")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        name: Annotated[
            Optional[StrictStr], Field(description="CSV QOS name list")
        ] = None,
        preempt_mode: Annotated[
            Optional[StrictStr],
            Field(description="PreemptMode used when jobs in this QOS are preempted"),
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted QOS")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get QOS list


        :param description: CSV description list
        :type description: str
        :param id: CSV QOS id list
        :type id: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param name: CSV QOS name list
        :type name: str
        :param preempt_mode: PreemptMode used when jobs in this QOS are preempted
        :type preempt_mode: str
        :param with_deleted: Include deleted QOS
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_qos_serialize(
            description=description,
            id=id,
            format=format,
            name=name,
            preempt_mode=preempt_mode,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdQosResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_qos_serialize(
        self,
        description,
        id,
        format,
        name,
        preempt_mode,
        with_deleted,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if description is not None:
            _query_params.append(("description", description))

        if id is not None:
            _query_params.append(("id", id))

        if format is not None:
            _query_params.append(("format", format))

        if name is not None:
            _query_params.append(("name", name))

        if preempt_mode is not None:
            _query_params.append(("preempt_mode", preempt_mode))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/qos/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_single_qos(
        self,
        qos: Annotated[StrictStr, Field(description="QOS name")],
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Query includes deleted QOS")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPISlurmdbdQosResp:
        """Get QOS info


        :param qos: QOS name (required)
        :type qos: str
        :param with_deleted: Query includes deleted QOS
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_single_qos_serialize(
            qos=qos,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdQosResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_single_qos_with_http_info(
        self,
        qos: Annotated[StrictStr, Field(description="QOS name")],
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Query includes deleted QOS")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPISlurmdbdQosResp]:
        """Get QOS info


        :param qos: QOS name (required)
        :type qos: str
        :param with_deleted: Query includes deleted QOS
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_single_qos_serialize(
            qos=qos,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdQosResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_single_qos_without_preload_content(
        self,
        qos: Annotated[StrictStr, Field(description="QOS name")],
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Query includes deleted QOS")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get QOS info


        :param qos: QOS name (required)
        :type qos: str
        :param with_deleted: Query includes deleted QOS
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_single_qos_serialize(
            qos=qos,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPISlurmdbdQosResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_single_qos_serialize(
        self,
        qos,
        with_deleted,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if qos is not None:
            _path_params["qos"] = qos
        # process the query parameters
        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/qos/{qos}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_tres(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPITresResp:
        """Get TRES info


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_tres_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPITresResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_tres_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPITresResp]:
        """Get TRES info


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_tres_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPITresResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_tres_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get TRES info


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_tres_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPITresResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_tres_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/tres/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_user(
        self,
        name: Annotated[StrictStr, Field(description="User name")],
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted users")
        ] = None,
        with_assocs: Annotated[
            Optional[StrictStr], Field(description="Include associations")
        ] = None,
        with_coords: Annotated[
            Optional[StrictStr], Field(description="Include coordinators")
        ] = None,
        with_wckeys: Annotated[
            Optional[StrictStr], Field(description="Include wckeys")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIUsersResp:
        """Get user info


        :param name: User name (required)
        :type name: str
        :param with_deleted: Include deleted users
        :type with_deleted: str
        :param with_assocs: Include associations
        :type with_assocs: str
        :param with_coords: Include coordinators
        :type with_coords: str
        :param with_wckeys: Include wckeys
        :type with_wckeys: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_user_serialize(
            name=name,
            with_deleted=with_deleted,
            with_assocs=with_assocs,
            with_coords=with_coords,
            with_wckeys=with_wckeys,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIUsersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_user_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="User name")],
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted users")
        ] = None,
        with_assocs: Annotated[
            Optional[StrictStr], Field(description="Include associations")
        ] = None,
        with_coords: Annotated[
            Optional[StrictStr], Field(description="Include coordinators")
        ] = None,
        with_wckeys: Annotated[
            Optional[StrictStr], Field(description="Include wckeys")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIUsersResp]:
        """Get user info


        :param name: User name (required)
        :type name: str
        :param with_deleted: Include deleted users
        :type with_deleted: str
        :param with_assocs: Include associations
        :type with_assocs: str
        :param with_coords: Include coordinators
        :type with_coords: str
        :param with_wckeys: Include wckeys
        :type with_wckeys: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_user_serialize(
            name=name,
            with_deleted=with_deleted,
            with_assocs=with_assocs,
            with_coords=with_coords,
            with_wckeys=with_wckeys,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIUsersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_user_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="User name")],
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted users")
        ] = None,
        with_assocs: Annotated[
            Optional[StrictStr], Field(description="Include associations")
        ] = None,
        with_coords: Annotated[
            Optional[StrictStr], Field(description="Include coordinators")
        ] = None,
        with_wckeys: Annotated[
            Optional[StrictStr], Field(description="Include wckeys")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get user info


        :param name: User name (required)
        :type name: str
        :param with_deleted: Include deleted users
        :type with_deleted: str
        :param with_assocs: Include associations
        :type with_assocs: str
        :param with_coords: Include coordinators
        :type with_coords: str
        :param with_wckeys: Include wckeys
        :type with_wckeys: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_user_serialize(
            name=name,
            with_deleted=with_deleted,
            with_assocs=with_assocs,
            with_coords=with_coords,
            with_wckeys=with_wckeys,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIUsersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_user_serialize(
        self,
        name,
        with_deleted,
        with_assocs,
        with_coords,
        with_wckeys,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params["name"] = name
        # process the query parameters
        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        if with_assocs is not None:
            _query_params.append(("with_assocs", with_assocs))

        if with_coords is not None:
            _query_params.append(("with_coords", with_coords))

        if with_wckeys is not None:
            _query_params.append(("with_wckeys", with_wckeys))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/user/{name}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_users(
        self,
        admin_level: Annotated[
            Optional[StrictStr], Field(description="Administrator level")
        ] = None,
        default_account: Annotated[
            Optional[StrictStr], Field(description="CSV default account list")
        ] = None,
        default_wckey: Annotated[
            Optional[StrictStr], Field(description="CSV default wckey list")
        ] = None,
        with_assocs: Annotated[
            Optional[StrictStr], Field(description="With associations")
        ] = None,
        with_coords: Annotated[
            Optional[StrictStr], Field(description="With coordinators")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="With deleted")
        ] = None,
        with_wckeys: Annotated[
            Optional[StrictStr], Field(description="With wckeys")
        ] = None,
        without_defaults: Annotated[
            Optional[StrictStr], Field(description="Exclude defaults")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIUsersResp:
        """Get user list


        :param admin_level: Administrator level
        :type admin_level: str
        :param default_account: CSV default account list
        :type default_account: str
        :param default_wckey: CSV default wckey list
        :type default_wckey: str
        :param with_assocs: With associations
        :type with_assocs: str
        :param with_coords: With coordinators
        :type with_coords: str
        :param with_deleted: With deleted
        :type with_deleted: str
        :param with_wckeys: With wckeys
        :type with_wckeys: str
        :param without_defaults: Exclude defaults
        :type without_defaults: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_users_serialize(
            admin_level=admin_level,
            default_account=default_account,
            default_wckey=default_wckey,
            with_assocs=with_assocs,
            with_coords=with_coords,
            with_deleted=with_deleted,
            with_wckeys=with_wckeys,
            without_defaults=without_defaults,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIUsersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_users_with_http_info(
        self,
        admin_level: Annotated[
            Optional[StrictStr], Field(description="Administrator level")
        ] = None,
        default_account: Annotated[
            Optional[StrictStr], Field(description="CSV default account list")
        ] = None,
        default_wckey: Annotated[
            Optional[StrictStr], Field(description="CSV default wckey list")
        ] = None,
        with_assocs: Annotated[
            Optional[StrictStr], Field(description="With associations")
        ] = None,
        with_coords: Annotated[
            Optional[StrictStr], Field(description="With coordinators")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="With deleted")
        ] = None,
        with_wckeys: Annotated[
            Optional[StrictStr], Field(description="With wckeys")
        ] = None,
        without_defaults: Annotated[
            Optional[StrictStr], Field(description="Exclude defaults")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIUsersResp]:
        """Get user list


        :param admin_level: Administrator level
        :type admin_level: str
        :param default_account: CSV default account list
        :type default_account: str
        :param default_wckey: CSV default wckey list
        :type default_wckey: str
        :param with_assocs: With associations
        :type with_assocs: str
        :param with_coords: With coordinators
        :type with_coords: str
        :param with_deleted: With deleted
        :type with_deleted: str
        :param with_wckeys: With wckeys
        :type with_wckeys: str
        :param without_defaults: Exclude defaults
        :type without_defaults: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_users_serialize(
            admin_level=admin_level,
            default_account=default_account,
            default_wckey=default_wckey,
            with_assocs=with_assocs,
            with_coords=with_coords,
            with_deleted=with_deleted,
            with_wckeys=with_wckeys,
            without_defaults=without_defaults,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIUsersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_users_without_preload_content(
        self,
        admin_level: Annotated[
            Optional[StrictStr], Field(description="Administrator level")
        ] = None,
        default_account: Annotated[
            Optional[StrictStr], Field(description="CSV default account list")
        ] = None,
        default_wckey: Annotated[
            Optional[StrictStr], Field(description="CSV default wckey list")
        ] = None,
        with_assocs: Annotated[
            Optional[StrictStr], Field(description="With associations")
        ] = None,
        with_coords: Annotated[
            Optional[StrictStr], Field(description="With coordinators")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="With deleted")
        ] = None,
        with_wckeys: Annotated[
            Optional[StrictStr], Field(description="With wckeys")
        ] = None,
        without_defaults: Annotated[
            Optional[StrictStr], Field(description="Exclude defaults")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get user list


        :param admin_level: Administrator level
        :type admin_level: str
        :param default_account: CSV default account list
        :type default_account: str
        :param default_wckey: CSV default wckey list
        :type default_wckey: str
        :param with_assocs: With associations
        :type with_assocs: str
        :param with_coords: With coordinators
        :type with_coords: str
        :param with_deleted: With deleted
        :type with_deleted: str
        :param with_wckeys: With wckeys
        :type with_wckeys: str
        :param without_defaults: Exclude defaults
        :type without_defaults: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_users_serialize(
            admin_level=admin_level,
            default_account=default_account,
            default_wckey=default_wckey,
            with_assocs=with_assocs,
            with_coords=with_coords,
            with_deleted=with_deleted,
            with_wckeys=with_wckeys,
            without_defaults=without_defaults,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIUsersResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_users_serialize(
        self,
        admin_level,
        default_account,
        default_wckey,
        with_assocs,
        with_coords,
        with_deleted,
        with_wckeys,
        without_defaults,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if admin_level is not None:
            _query_params.append(("admin_level", admin_level))

        if default_account is not None:
            _query_params.append(("default_account", default_account))

        if default_wckey is not None:
            _query_params.append(("default_wckey", default_wckey))

        if with_assocs is not None:
            _query_params.append(("with_assocs", with_assocs))

        if with_coords is not None:
            _query_params.append(("with_coords", with_coords))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        if with_wckeys is not None:
            _query_params.append(("with_wckeys", with_wckeys))

        if without_defaults is not None:
            _query_params.append(("without_defaults", without_defaults))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/users/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_wckey(
        self,
        id: Annotated[StrictStr, Field(description="wckey id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIWckeyResp:
        """Get wckey info


        :param id: wckey id (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_wckey_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIWckeyResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_wckey_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="wckey id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIWckeyResp]:
        """Get wckey info


        :param id: wckey id (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_wckey_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIWckeyResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_wckey_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="wckey id")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get wckey info


        :param id: wckey id (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_wckey_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIWckeyResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_wckey_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/wckey/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def get_wckeys(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster name list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        name: Annotated[Optional[StrictStr], Field(description="CSV name list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Only query defaults")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted wckeys")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIWckeyResp:
        """Get wckey list


        :param cluster: CSV cluster name list
        :type cluster: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param name: CSV name list
        :type name: str
        :param only_defaults: Only query defaults
        :type only_defaults: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted wckeys
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_wckeys_serialize(
            cluster=cluster,
            format=format,
            id=id,
            name=name,
            only_defaults=only_defaults,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIWckeyResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def get_wckeys_with_http_info(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster name list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        name: Annotated[Optional[StrictStr], Field(description="CSV name list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Only query defaults")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted wckeys")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIWckeyResp]:
        """Get wckey list


        :param cluster: CSV cluster name list
        :type cluster: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param name: CSV name list
        :type name: str
        :param only_defaults: Only query defaults
        :type only_defaults: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted wckeys
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_wckeys_serialize(
            cluster=cluster,
            format=format,
            id=id,
            name=name,
            only_defaults=only_defaults,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIWckeyResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def get_wckeys_without_preload_content(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster name list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        name: Annotated[Optional[StrictStr], Field(description="CSV name list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Only query defaults")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted wckeys")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get wckey list


        :param cluster: CSV cluster name list
        :type cluster: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param name: CSV name list
        :type name: str
        :param only_defaults: Only query defaults
        :type only_defaults: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted wckeys
        :type with_deleted: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_wckeys_serialize(
            cluster=cluster,
            format=format,
            id=id,
            name=name,
            only_defaults=only_defaults,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIWckeyResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_wckeys_serialize(
        self,
        cluster,
        format,
        id,
        name,
        only_defaults,
        usage_end,
        usage_start,
        user,
        with_usage,
        with_deleted,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if cluster is not None:
            _query_params.append(("cluster", cluster))

        if format is not None:
            _query_params.append(("format", format))

        if id is not None:
            _query_params.append(("id", id))

        if name is not None:
            _query_params.append(("name", name))

        if only_defaults is not None:
            _query_params.append(("only_defaults", only_defaults))

        if usage_end is not None:
            _query_params.append(("usage_end", usage_end))

        if usage_start is not None:
            _query_params.append(("usage_start", usage_start))

        if user is not None:
            _query_params.append(("user", user))

        if with_usage is not None:
            _query_params.append(("with_usage", with_usage))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/slurmdb/v0.0.41/wckeys/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def post_accounts(
        self,
        open_api_accounts_resp: Annotated[
            Optional[OpenAPIAccountsResp],
            Field(description="Description of accounts to update/create"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIResp:
        """Add/update list of accounts


        :param open_api_accounts_resp: Description of accounts to update/create
        :type open_api_accounts_resp: OpenAPIAccountsResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_accounts_serialize(
            open_api_accounts_resp=open_api_accounts_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def post_accounts_with_http_info(
        self,
        open_api_accounts_resp: Annotated[
            Optional[OpenAPIAccountsResp],
            Field(description="Description of accounts to update/create"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIResp]:
        """Add/update list of accounts


        :param open_api_accounts_resp: Description of accounts to update/create
        :type open_api_accounts_resp: OpenAPIAccountsResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_accounts_serialize(
            open_api_accounts_resp=open_api_accounts_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def post_accounts_without_preload_content(
        self,
        open_api_accounts_resp: Annotated[
            Optional[OpenAPIAccountsResp],
            Field(description="Description of accounts to update/create"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add/update list of accounts


        :param open_api_accounts_resp: Description of accounts to update/create
        :type open_api_accounts_resp: OpenAPIAccountsResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_accounts_serialize(
            open_api_accounts_resp=open_api_accounts_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _post_accounts_serialize(
        self,
        open_api_accounts_resp,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if open_api_accounts_resp is not None:
            _body_params = open_api_accounts_resp

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/yaml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/slurmdb/v0.0.41/accounts/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def post_accounts_association(
        self,
        open_api_accounts_add_cond_resp: Annotated[
            Optional[OpenAPIAccountsAddCondResp],
            Field(description="Add list of accounts with conditional association"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIAccountsAddCondRespStr:
        """Add accounts with conditional association


        :param open_api_accounts_add_cond_resp: Add list of accounts with conditional association
        :type open_api_accounts_add_cond_resp: OpenAPIAccountsAddCondResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_accounts_association_serialize(
            open_api_accounts_add_cond_resp=open_api_accounts_add_cond_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsAddCondRespStr",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def post_accounts_association_with_http_info(
        self,
        open_api_accounts_add_cond_resp: Annotated[
            Optional[OpenAPIAccountsAddCondResp],
            Field(description="Add list of accounts with conditional association"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIAccountsAddCondRespStr]:
        """Add accounts with conditional association


        :param open_api_accounts_add_cond_resp: Add list of accounts with conditional association
        :type open_api_accounts_add_cond_resp: OpenAPIAccountsAddCondResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_accounts_association_serialize(
            open_api_accounts_add_cond_resp=open_api_accounts_add_cond_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsAddCondRespStr",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def post_accounts_association_without_preload_content(
        self,
        open_api_accounts_add_cond_resp: Annotated[
            Optional[OpenAPIAccountsAddCondResp],
            Field(description="Add list of accounts with conditional association"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add accounts with conditional association


        :param open_api_accounts_add_cond_resp: Add list of accounts with conditional association
        :type open_api_accounts_add_cond_resp: OpenAPIAccountsAddCondResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_accounts_association_serialize(
            open_api_accounts_add_cond_resp=open_api_accounts_add_cond_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIAccountsAddCondRespStr",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _post_accounts_association_serialize(
        self,
        open_api_accounts_add_cond_resp,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if open_api_accounts_add_cond_resp is not None:
            _body_params = open_api_accounts_add_cond_resp

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/yaml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/slurmdb/v0.0.41/accounts_association/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def post_associations(
        self,
        open_api_assocs_resp: Annotated[
            Optional[OpenAPIAssocsResp], Field(description="Job description")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIResp:
        """Set associations info


        :param open_api_assocs_resp: Job description
        :type open_api_assocs_resp: OpenAPIAssocsResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_associations_serialize(
            open_api_assocs_resp=open_api_assocs_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def post_associations_with_http_info(
        self,
        open_api_assocs_resp: Annotated[
            Optional[OpenAPIAssocsResp], Field(description="Job description")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIResp]:
        """Set associations info


        :param open_api_assocs_resp: Job description
        :type open_api_assocs_resp: OpenAPIAssocsResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_associations_serialize(
            open_api_assocs_resp=open_api_assocs_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def post_associations_without_preload_content(
        self,
        open_api_assocs_resp: Annotated[
            Optional[OpenAPIAssocsResp], Field(description="Job description")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set associations info


        :param open_api_assocs_resp: Job description
        :type open_api_assocs_resp: OpenAPIAssocsResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_associations_serialize(
            open_api_assocs_resp=open_api_assocs_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _post_associations_serialize(
        self,
        open_api_assocs_resp,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if open_api_assocs_resp is not None:
            _body_params = open_api_assocs_resp

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/yaml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/slurmdb/v0.0.41/associations/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def post_clusters(
        self,
        update_time: Annotated[
            Optional[StrictStr],
            Field(description="Filter reservations since update timestamp"),
        ] = None,
        open_api_clusters_resp: Annotated[
            Optional[OpenAPIClustersResp],
            Field(description="Cluster add or update descriptions"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIResp:
        """Get cluster list


        :param update_time: Filter reservations since update timestamp
        :type update_time: str
        :param open_api_clusters_resp: Cluster add or update descriptions
        :type open_api_clusters_resp: OpenAPIClustersResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_clusters_serialize(
            update_time=update_time,
            open_api_clusters_resp=open_api_clusters_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def post_clusters_with_http_info(
        self,
        update_time: Annotated[
            Optional[StrictStr],
            Field(description="Filter reservations since update timestamp"),
        ] = None,
        open_api_clusters_resp: Annotated[
            Optional[OpenAPIClustersResp],
            Field(description="Cluster add or update descriptions"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIResp]:
        """Get cluster list


        :param update_time: Filter reservations since update timestamp
        :type update_time: str
        :param open_api_clusters_resp: Cluster add or update descriptions
        :type open_api_clusters_resp: OpenAPIClustersResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_clusters_serialize(
            update_time=update_time,
            open_api_clusters_resp=open_api_clusters_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def post_clusters_without_preload_content(
        self,
        update_time: Annotated[
            Optional[StrictStr],
            Field(description="Filter reservations since update timestamp"),
        ] = None,
        open_api_clusters_resp: Annotated[
            Optional[OpenAPIClustersResp],
            Field(description="Cluster add or update descriptions"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get cluster list


        :param update_time: Filter reservations since update timestamp
        :type update_time: str
        :param open_api_clusters_resp: Cluster add or update descriptions
        :type open_api_clusters_resp: OpenAPIClustersResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_clusters_serialize(
            update_time=update_time,
            open_api_clusters_resp=open_api_clusters_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _post_clusters_serialize(
        self,
        update_time,
        open_api_clusters_resp,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if update_time is not None:
            _query_params.append(("update_time", update_time))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if open_api_clusters_resp is not None:
            _body_params = open_api_clusters_resp

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/yaml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/slurmdb/v0.0.41/clusters/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def post_config(
        self,
        open_api_slurmdbd_config_resp: Annotated[
            Optional[OpenAPISlurmdbdConfigResp],
            Field(description="Add or update config"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIResp:
        """Load all configuration information


        :param open_api_slurmdbd_config_resp: Add or update config
        :type open_api_slurmdbd_config_resp: OpenAPISlurmdbdConfigResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_config_serialize(
            open_api_slurmdbd_config_resp=open_api_slurmdbd_config_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def post_config_with_http_info(
        self,
        open_api_slurmdbd_config_resp: Annotated[
            Optional[OpenAPISlurmdbdConfigResp],
            Field(description="Add or update config"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIResp]:
        """Load all configuration information


        :param open_api_slurmdbd_config_resp: Add or update config
        :type open_api_slurmdbd_config_resp: OpenAPISlurmdbdConfigResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_config_serialize(
            open_api_slurmdbd_config_resp=open_api_slurmdbd_config_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def post_config_without_preload_content(
        self,
        open_api_slurmdbd_config_resp: Annotated[
            Optional[OpenAPISlurmdbdConfigResp],
            Field(description="Add or update config"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Load all configuration information


        :param open_api_slurmdbd_config_resp: Add or update config
        :type open_api_slurmdbd_config_resp: OpenAPISlurmdbdConfigResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_config_serialize(
            open_api_slurmdbd_config_resp=open_api_slurmdbd_config_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _post_config_serialize(
        self,
        open_api_slurmdbd_config_resp,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if open_api_slurmdbd_config_resp is not None:
            _body_params = open_api_slurmdbd_config_resp

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/yaml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/slurmdb/v0.0.41/config",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def post_qos(
        self,
        description: Annotated[
            Optional[StrictStr], Field(description="CSV description list")
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV QOS id list")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        name: Annotated[
            Optional[StrictStr], Field(description="CSV QOS name list")
        ] = None,
        preempt_mode: Annotated[
            Optional[StrictStr],
            Field(description="PreemptMode used when jobs in this QOS are preempted"),
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted QOS")
        ] = None,
        open_api_slurmdbd_qos_resp: Annotated[
            Optional[OpenAPISlurmdbdQosResp],
            Field(description="Description of QOS to add or update"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIResp:
        """Add or update QOSs


        :param description: CSV description list
        :type description: str
        :param id: CSV QOS id list
        :type id: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param name: CSV QOS name list
        :type name: str
        :param preempt_mode: PreemptMode used when jobs in this QOS are preempted
        :type preempt_mode: str
        :param with_deleted: Include deleted QOS
        :type with_deleted: str
        :param open_api_slurmdbd_qos_resp: Description of QOS to add or update
        :type open_api_slurmdbd_qos_resp: OpenAPISlurmdbdQosResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_qos_serialize(
            description=description,
            id=id,
            format=format,
            name=name,
            preempt_mode=preempt_mode,
            with_deleted=with_deleted,
            open_api_slurmdbd_qos_resp=open_api_slurmdbd_qos_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def post_qos_with_http_info(
        self,
        description: Annotated[
            Optional[StrictStr], Field(description="CSV description list")
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV QOS id list")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        name: Annotated[
            Optional[StrictStr], Field(description="CSV QOS name list")
        ] = None,
        preempt_mode: Annotated[
            Optional[StrictStr],
            Field(description="PreemptMode used when jobs in this QOS are preempted"),
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted QOS")
        ] = None,
        open_api_slurmdbd_qos_resp: Annotated[
            Optional[OpenAPISlurmdbdQosResp],
            Field(description="Description of QOS to add or update"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIResp]:
        """Add or update QOSs


        :param description: CSV description list
        :type description: str
        :param id: CSV QOS id list
        :type id: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param name: CSV QOS name list
        :type name: str
        :param preempt_mode: PreemptMode used when jobs in this QOS are preempted
        :type preempt_mode: str
        :param with_deleted: Include deleted QOS
        :type with_deleted: str
        :param open_api_slurmdbd_qos_resp: Description of QOS to add or update
        :type open_api_slurmdbd_qos_resp: OpenAPISlurmdbdQosResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_qos_serialize(
            description=description,
            id=id,
            format=format,
            name=name,
            preempt_mode=preempt_mode,
            with_deleted=with_deleted,
            open_api_slurmdbd_qos_resp=open_api_slurmdbd_qos_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def post_qos_without_preload_content(
        self,
        description: Annotated[
            Optional[StrictStr], Field(description="CSV description list")
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV QOS id list")] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        name: Annotated[
            Optional[StrictStr], Field(description="CSV QOS name list")
        ] = None,
        preempt_mode: Annotated[
            Optional[StrictStr],
            Field(description="PreemptMode used when jobs in this QOS are preempted"),
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted QOS")
        ] = None,
        open_api_slurmdbd_qos_resp: Annotated[
            Optional[OpenAPISlurmdbdQosResp],
            Field(description="Description of QOS to add or update"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add or update QOSs


        :param description: CSV description list
        :type description: str
        :param id: CSV QOS id list
        :type id: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param name: CSV QOS name list
        :type name: str
        :param preempt_mode: PreemptMode used when jobs in this QOS are preempted
        :type preempt_mode: str
        :param with_deleted: Include deleted QOS
        :type with_deleted: str
        :param open_api_slurmdbd_qos_resp: Description of QOS to add or update
        :type open_api_slurmdbd_qos_resp: OpenAPISlurmdbdQosResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_qos_serialize(
            description=description,
            id=id,
            format=format,
            name=name,
            preempt_mode=preempt_mode,
            with_deleted=with_deleted,
            open_api_slurmdbd_qos_resp=open_api_slurmdbd_qos_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _post_qos_serialize(
        self,
        description,
        id,
        format,
        name,
        preempt_mode,
        with_deleted,
        open_api_slurmdbd_qos_resp,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if description is not None:
            _query_params.append(("description", description))

        if id is not None:
            _query_params.append(("id", id))

        if format is not None:
            _query_params.append(("format", format))

        if name is not None:
            _query_params.append(("name", name))

        if preempt_mode is not None:
            _query_params.append(("preempt_mode", preempt_mode))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if open_api_slurmdbd_qos_resp is not None:
            _body_params = open_api_slurmdbd_qos_resp

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/yaml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/slurmdb/v0.0.41/qos/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def post_tres(
        self,
        open_api_tres_resp: Annotated[
            Optional[OpenAPITresResp],
            Field(description="TRES descriptions. Only works in developer mode."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIResp:
        """Add TRES


        :param open_api_tres_resp: TRES descriptions. Only works in developer mode.
        :type open_api_tres_resp: OpenAPITresResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_tres_serialize(
            open_api_tres_resp=open_api_tres_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def post_tres_with_http_info(
        self,
        open_api_tres_resp: Annotated[
            Optional[OpenAPITresResp],
            Field(description="TRES descriptions. Only works in developer mode."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIResp]:
        """Add TRES


        :param open_api_tres_resp: TRES descriptions. Only works in developer mode.
        :type open_api_tres_resp: OpenAPITresResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_tres_serialize(
            open_api_tres_resp=open_api_tres_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def post_tres_without_preload_content(
        self,
        open_api_tres_resp: Annotated[
            Optional[OpenAPITresResp],
            Field(description="TRES descriptions. Only works in developer mode."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add TRES


        :param open_api_tres_resp: TRES descriptions. Only works in developer mode.
        :type open_api_tres_resp: OpenAPITresResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_tres_serialize(
            open_api_tres_resp=open_api_tres_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _post_tres_serialize(
        self,
        open_api_tres_resp,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if open_api_tres_resp is not None:
            _body_params = open_api_tres_resp

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/yaml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/slurmdb/v0.0.41/tres/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def post_users(
        self,
        open_api_users_resp: Annotated[
            Optional[OpenAPIUsersResp], Field(description="add or update user")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIResp:
        """Update users


        :param open_api_users_resp: add or update user
        :type open_api_users_resp: OpenAPIUsersResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_users_serialize(
            open_api_users_resp=open_api_users_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def post_users_with_http_info(
        self,
        open_api_users_resp: Annotated[
            Optional[OpenAPIUsersResp], Field(description="add or update user")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIResp]:
        """Update users


        :param open_api_users_resp: add or update user
        :type open_api_users_resp: OpenAPIUsersResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_users_serialize(
            open_api_users_resp=open_api_users_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def post_users_without_preload_content(
        self,
        open_api_users_resp: Annotated[
            Optional[OpenAPIUsersResp], Field(description="add or update user")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update users


        :param open_api_users_resp: add or update user
        :type open_api_users_resp: OpenAPIUsersResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_users_serialize(
            open_api_users_resp=open_api_users_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _post_users_serialize(
        self,
        open_api_users_resp,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if open_api_users_resp is not None:
            _body_params = open_api_users_resp

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/yaml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/slurmdb/v0.0.41/users/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def post_users_association(
        self,
        update_time: Annotated[
            Optional[StrictStr],
            Field(description="Filter partitions since update timestamp"),
        ] = None,
        flags: Annotated[Optional[StrictStr], Field(description="Query flags")] = None,
        open_api_users_add_cond_resp: Annotated[
            Optional[OpenAPIUsersAddCondResp],
            Field(description="Create users with conditional association"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIUsersAddCondRespStr:
        """Add users with conditional association


        :param update_time: Filter partitions since update timestamp
        :type update_time: str
        :param flags: Query flags
        :type flags: str
        :param open_api_users_add_cond_resp: Create users with conditional association
        :type open_api_users_add_cond_resp: OpenAPIUsersAddCondResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_users_association_serialize(
            update_time=update_time,
            flags=flags,
            open_api_users_add_cond_resp=open_api_users_add_cond_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIUsersAddCondRespStr",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def post_users_association_with_http_info(
        self,
        update_time: Annotated[
            Optional[StrictStr],
            Field(description="Filter partitions since update timestamp"),
        ] = None,
        flags: Annotated[Optional[StrictStr], Field(description="Query flags")] = None,
        open_api_users_add_cond_resp: Annotated[
            Optional[OpenAPIUsersAddCondResp],
            Field(description="Create users with conditional association"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIUsersAddCondRespStr]:
        """Add users with conditional association


        :param update_time: Filter partitions since update timestamp
        :type update_time: str
        :param flags: Query flags
        :type flags: str
        :param open_api_users_add_cond_resp: Create users with conditional association
        :type open_api_users_add_cond_resp: OpenAPIUsersAddCondResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_users_association_serialize(
            update_time=update_time,
            flags=flags,
            open_api_users_add_cond_resp=open_api_users_add_cond_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIUsersAddCondRespStr",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def post_users_association_without_preload_content(
        self,
        update_time: Annotated[
            Optional[StrictStr],
            Field(description="Filter partitions since update timestamp"),
        ] = None,
        flags: Annotated[Optional[StrictStr], Field(description="Query flags")] = None,
        open_api_users_add_cond_resp: Annotated[
            Optional[OpenAPIUsersAddCondResp],
            Field(description="Create users with conditional association"),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add users with conditional association


        :param update_time: Filter partitions since update timestamp
        :type update_time: str
        :param flags: Query flags
        :type flags: str
        :param open_api_users_add_cond_resp: Create users with conditional association
        :type open_api_users_add_cond_resp: OpenAPIUsersAddCondResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_users_association_serialize(
            update_time=update_time,
            flags=flags,
            open_api_users_add_cond_resp=open_api_users_add_cond_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIUsersAddCondRespStr",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _post_users_association_serialize(
        self,
        update_time,
        flags,
        open_api_users_add_cond_resp,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if update_time is not None:
            _query_params.append(("update_time", update_time))

        if flags is not None:
            _query_params.append(("flags", flags))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if open_api_users_add_cond_resp is not None:
            _body_params = open_api_users_add_cond_resp

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/yaml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/slurmdb/v0.0.41/users_association/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    async def post_wckeys(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster name list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        name: Annotated[Optional[StrictStr], Field(description="CSV name list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Only query defaults")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted wckeys")
        ] = None,
        open_api_wckey_resp: Annotated[
            Optional[OpenAPIWckeyResp], Field(description="wckeys description")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenAPIResp:
        """Add or update wckeys


        :param cluster: CSV cluster name list
        :type cluster: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param name: CSV name list
        :type name: str
        :param only_defaults: Only query defaults
        :type only_defaults: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted wckeys
        :type with_deleted: str
        :param open_api_wckey_resp: wckeys description
        :type open_api_wckey_resp: OpenAPIWckeyResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_wckeys_serialize(
            cluster=cluster,
            format=format,
            id=id,
            name=name,
            only_defaults=only_defaults,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            open_api_wckey_resp=open_api_wckey_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    async def post_wckeys_with_http_info(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster name list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        name: Annotated[Optional[StrictStr], Field(description="CSV name list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Only query defaults")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted wckeys")
        ] = None,
        open_api_wckey_resp: Annotated[
            Optional[OpenAPIWckeyResp], Field(description="wckeys description")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenAPIResp]:
        """Add or update wckeys


        :param cluster: CSV cluster name list
        :type cluster: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param name: CSV name list
        :type name: str
        :param only_defaults: Only query defaults
        :type only_defaults: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted wckeys
        :type with_deleted: str
        :param open_api_wckey_resp: wckeys description
        :type open_api_wckey_resp: OpenAPIWckeyResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_wckeys_serialize(
            cluster=cluster,
            format=format,
            id=id,
            name=name,
            only_defaults=only_defaults,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            open_api_wckey_resp=open_api_wckey_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    async def post_wckeys_without_preload_content(
        self,
        cluster: Annotated[
            Optional[StrictStr], Field(description="CSV cluster name list")
        ] = None,
        format: Annotated[
            Optional[StrictStr],
            Field(
                description="Ignored; process JSON manually to control output format"
            ),
        ] = None,
        id: Annotated[Optional[StrictStr], Field(description="CSV id list")] = None,
        name: Annotated[Optional[StrictStr], Field(description="CSV name list")] = None,
        only_defaults: Annotated[
            Optional[StrictStr], Field(description="Only query defaults")
        ] = None,
        usage_end: Annotated[
            Optional[StrictStr], Field(description="Usage end (UNIX timestamp)")
        ] = None,
        usage_start: Annotated[
            Optional[StrictStr], Field(description="Usage start (UNIX timestamp)")
        ] = None,
        user: Annotated[Optional[StrictStr], Field(description="CSV user list")] = None,
        with_usage: Annotated[
            Optional[StrictStr], Field(description="Include usage")
        ] = None,
        with_deleted: Annotated[
            Optional[StrictStr], Field(description="Include deleted wckeys")
        ] = None,
        open_api_wckey_resp: Annotated[
            Optional[OpenAPIWckeyResp], Field(description="wckeys description")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add or update wckeys


        :param cluster: CSV cluster name list
        :type cluster: str
        :param format: Ignored; process JSON manually to control output format
        :type format: str
        :param id: CSV id list
        :type id: str
        :param name: CSV name list
        :type name: str
        :param only_defaults: Only query defaults
        :type only_defaults: str
        :param usage_end: Usage end (UNIX timestamp)
        :type usage_end: str
        :param usage_start: Usage start (UNIX timestamp)
        :type usage_start: str
        :param user: CSV user list
        :type user: str
        :param with_usage: Include usage
        :type with_usage: str
        :param with_deleted: Include deleted wckeys
        :type with_deleted: str
        :param open_api_wckey_resp: wckeys description
        :type open_api_wckey_resp: OpenAPIWckeyResp
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._post_wckeys_serialize(
            cluster=cluster,
            format=format,
            id=id,
            name=name,
            only_defaults=only_defaults,
            usage_end=usage_end,
            usage_start=usage_start,
            user=user,
            with_usage=with_usage,
            with_deleted=with_deleted,
            open_api_wckey_resp=open_api_wckey_resp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "OpenAPIResp",
        }
        response_data = await self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _post_wckeys_serialize(
        self,
        cluster,
        format,
        id,
        name,
        only_defaults,
        usage_end,
        usage_start,
        user,
        with_usage,
        with_deleted,
        open_api_wckey_resp,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if cluster is not None:
            _query_params.append(("cluster", cluster))

        if format is not None:
            _query_params.append(("format", format))

        if id is not None:
            _query_params.append(("id", id))

        if name is not None:
            _query_params.append(("name", name))

        if only_defaults is not None:
            _query_params.append(("only_defaults", only_defaults))

        if usage_end is not None:
            _query_params.append(("usage_end", usage_end))

        if usage_start is not None:
            _query_params.append(("usage_start", usage_start))

        if user is not None:
            _query_params.append(("user", user))

        if with_usage is not None:
            _query_params.append(("with_usage", with_usage))

        if with_deleted is not None:
            _query_params.append(("with_deleted", with_deleted))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if open_api_wckey_resp is not None:
            _body_params = open_api_wckey_resp

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/yaml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/yaml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["user", "bearerAuth", "token"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/slurmdb/v0.0.41/wckeys/",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
