# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0041.asyncio.models.job_desc_msg import JobDescMsg
from typing import Set
from typing_extensions import Self


class JobAllocReq(BaseModel):
    """
    JobAllocReq
    """  # noqa: E501

    hetjob: Optional[List[JobDescMsg]] = Field(
        default=None, description="HetJob description"
    )
    job: Optional[JobDescMsg] = None
    __properties: ClassVar[List[str]] = ["hetjob", "job"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobAllocReq from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in hetjob (list)
        _items = []
        if self.hetjob:
            for _item_hetjob in self.hetjob:
                if _item_hetjob:
                    _items.append(_item_hetjob.to_dict())
            _dict["hetjob"] = _items
        # override the default output from pydantic by calling `to_dict()` of job
        if self.job:
            _dict["job"] = self.job.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobAllocReq from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "hetjob": [JobDescMsg.from_dict(_item) for _item in obj["hetjob"]]
                if obj.get("hetjob") is not None
                else None,
                "job": JobDescMsg.from_dict(obj["job"])
                if obj.get("job") is not None
                else None,
            }
        )
        return _obj
