# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictInt,
    StrictStr,
    field_validator,
)
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0041.asyncio.models.v0041_job_desc_msg_priority import (
    V0041JobDescMsgPriority,
)
from slurpy.v0041.asyncio.models.v0041_openapi_job_info_resp_jobs_inner_derived_exit_code import (
    V0041OpenapiJobInfoRespJobsInnerDerivedExitCode,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_array import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerArray,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_association import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerAssociation,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_comment import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerComment,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_exit_code import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerExitCode,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_het import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerHet,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_mcs import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerMcs,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_required import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerRequired,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_reservation import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerReservation,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_state import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerState,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_steps_inner import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInner,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_time import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerTime,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_tres import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerTres,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_wckey import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerWckey,
)
from typing import Set
from typing_extensions import Self


class V0041OpenapiSlurmdbdJobsRespJobsInner(BaseModel):
    """
    V0041OpenapiSlurmdbdJobsRespJobsInner
    """  # noqa: E501

    account: Optional[StrictStr] = Field(
        default=None, description="Account the job ran under"
    )
    comment: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerComment] = None
    allocation_nodes: Optional[StrictInt] = Field(
        default=None, description="List of nodes allocated to the job"
    )
    array: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerArray] = None
    association: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerAssociation] = None
    block: Optional[StrictStr] = Field(
        default=None,
        description="The name of the block to be used (used with Blue Gene systems)",
    )
    cluster: Optional[StrictStr] = Field(default=None, description="Cluster name")
    constraints: Optional[StrictStr] = Field(
        default=None, description="Feature(s) the job requested as a constraint"
    )
    container: Optional[StrictStr] = Field(
        default=None, description="Absolute path to OCI container bundle"
    )
    derived_exit_code: Optional[V0041OpenapiJobInfoRespJobsInnerDerivedExitCode] = None
    time: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerTime] = None
    exit_code: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerExitCode] = None
    extra: Optional[StrictStr] = Field(
        default=None,
        description="Arbitrary string used for node filtering if extra constraints are enabled",
    )
    failed_node: Optional[StrictStr] = Field(
        default=None, description="Name of node that caused job failure"
    )
    flags: Optional[List[StrictStr]] = Field(
        default=None, description="Flags associated with the job"
    )
    group: Optional[StrictStr] = Field(
        default=None, description="Group ID of the user that owns the job"
    )
    het: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerHet] = None
    job_id: Optional[StrictInt] = Field(default=None, description="Job ID")
    name: Optional[StrictStr] = Field(default=None, description="Job name")
    licenses: Optional[StrictStr] = Field(
        default=None, description="License(s) required by the job"
    )
    mcs: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerMcs] = None
    nodes: Optional[StrictStr] = Field(
        default=None, description="Node(s) allocated to the job"
    )
    partition: Optional[StrictStr] = Field(
        default=None, description="Partition assigned to the job"
    )
    hold: Optional[StrictBool] = Field(
        default=None, description="Hold (true) or release (false) job"
    )
    priority: Optional[V0041JobDescMsgPriority] = None
    qos: Optional[StrictStr] = Field(
        default=None, description="Quality of Service assigned to the job"
    )
    required: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerRequired] = None
    kill_request_user: Optional[StrictStr] = Field(
        default=None, description="User ID that requested termination of the job"
    )
    reservation: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerReservation] = None
    script: Optional[StrictStr] = Field(
        default=None,
        description="Job batch script; only the first component in a HetJob is populated or honored",
    )
    stdin_expanded: Optional[StrictStr] = Field(
        default=None, description="Job stdin with expanded fields"
    )
    stdout_expanded: Optional[StrictStr] = Field(
        default=None, description="Job stdout with expanded fields"
    )
    stderr_expanded: Optional[StrictStr] = Field(
        default=None, description="Job stderr with expanded fields"
    )
    stdout: Optional[StrictStr] = Field(default=None, description="Path to stdout file")
    stderr: Optional[StrictStr] = Field(default=None, description="Path to stderr file")
    stdin: Optional[StrictStr] = Field(default=None, description="Path to stdin file")
    state: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerState] = None
    steps: Optional[List[V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInner]] = Field(
        default=None, description="Individual steps in the job"
    )
    submit_line: Optional[StrictStr] = Field(
        default=None, description="Command used to submit the job"
    )
    tres: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerTres] = None
    used_gres: Optional[StrictStr] = Field(
        default=None, description="Generic resources used by job"
    )
    user: Optional[StrictStr] = Field(
        default=None, description="User that owns the job"
    )
    wckey: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerWckey] = None
    working_directory: Optional[StrictStr] = Field(
        default=None, description="Path to current working directory"
    )
    __properties: ClassVar[List[str]] = [
        "account",
        "comment",
        "allocation_nodes",
        "array",
        "association",
        "block",
        "cluster",
        "constraints",
        "container",
        "derived_exit_code",
        "time",
        "exit_code",
        "extra",
        "failed_node",
        "flags",
        "group",
        "het",
        "job_id",
        "name",
        "licenses",
        "mcs",
        "nodes",
        "partition",
        "hold",
        "priority",
        "qos",
        "required",
        "kill_request_user",
        "reservation",
        "script",
        "stdin_expanded",
        "stdout_expanded",
        "stderr_expanded",
        "stdout",
        "stderr",
        "stdin",
        "state",
        "steps",
        "submit_line",
        "tres",
        "used_gres",
        "user",
        "wckey",
        "working_directory",
    ]

    @field_validator("flags")
    def flags_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(
                [
                    "NONE",
                    "CLEAR_SCHEDULING",
                    "NOT_SET",
                    "STARTED_ON_SUBMIT",
                    "STARTED_ON_SCHEDULE",
                    "STARTED_ON_BACKFILL",
                    "START_RECEIVED",
                ]
            ):
                raise ValueError(
                    "each list item must be one of ('NONE', 'CLEAR_SCHEDULING', 'NOT_SET', 'STARTED_ON_SUBMIT', 'STARTED_ON_SCHEDULE', 'STARTED_ON_BACKFILL', 'START_RECEIVED')"
                )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V0041OpenapiSlurmdbdJobsRespJobsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of comment
        if self.comment:
            _dict["comment"] = self.comment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of array
        if self.array:
            _dict["array"] = self.array.to_dict()
        # override the default output from pydantic by calling `to_dict()` of association
        if self.association:
            _dict["association"] = self.association.to_dict()
        # override the default output from pydantic by calling `to_dict()` of derived_exit_code
        if self.derived_exit_code:
            _dict["derived_exit_code"] = self.derived_exit_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict["time"] = self.time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of exit_code
        if self.exit_code:
            _dict["exit_code"] = self.exit_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of het
        if self.het:
            _dict["het"] = self.het.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mcs
        if self.mcs:
            _dict["mcs"] = self.mcs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of priority
        if self.priority:
            _dict["priority"] = self.priority.to_dict()
        # override the default output from pydantic by calling `to_dict()` of required
        if self.required:
            _dict["required"] = self.required.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reservation
        if self.reservation:
            _dict["reservation"] = self.reservation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict["state"] = self.state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item_steps in self.steps:
                if _item_steps:
                    _items.append(_item_steps.to_dict())
            _dict["steps"] = _items
        # override the default output from pydantic by calling `to_dict()` of tres
        if self.tres:
            _dict["tres"] = self.tres.to_dict()
        # override the default output from pydantic by calling `to_dict()` of wckey
        if self.wckey:
            _dict["wckey"] = self.wckey.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V0041OpenapiSlurmdbdJobsRespJobsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "account": obj.get("account"),
                "comment": V0041OpenapiSlurmdbdJobsRespJobsInnerComment.from_dict(
                    obj["comment"]
                )
                if obj.get("comment") is not None
                else None,
                "allocation_nodes": obj.get("allocation_nodes"),
                "array": V0041OpenapiSlurmdbdJobsRespJobsInnerArray.from_dict(
                    obj["array"]
                )
                if obj.get("array") is not None
                else None,
                "association": V0041OpenapiSlurmdbdJobsRespJobsInnerAssociation.from_dict(
                    obj["association"]
                )
                if obj.get("association") is not None
                else None,
                "block": obj.get("block"),
                "cluster": obj.get("cluster"),
                "constraints": obj.get("constraints"),
                "container": obj.get("container"),
                "derived_exit_code": V0041OpenapiJobInfoRespJobsInnerDerivedExitCode.from_dict(
                    obj["derived_exit_code"]
                )
                if obj.get("derived_exit_code") is not None
                else None,
                "time": V0041OpenapiSlurmdbdJobsRespJobsInnerTime.from_dict(obj["time"])
                if obj.get("time") is not None
                else None,
                "exit_code": V0041OpenapiSlurmdbdJobsRespJobsInnerExitCode.from_dict(
                    obj["exit_code"]
                )
                if obj.get("exit_code") is not None
                else None,
                "extra": obj.get("extra"),
                "failed_node": obj.get("failed_node"),
                "flags": obj.get("flags"),
                "group": obj.get("group"),
                "het": V0041OpenapiSlurmdbdJobsRespJobsInnerHet.from_dict(obj["het"])
                if obj.get("het") is not None
                else None,
                "job_id": obj.get("job_id"),
                "name": obj.get("name"),
                "licenses": obj.get("licenses"),
                "mcs": V0041OpenapiSlurmdbdJobsRespJobsInnerMcs.from_dict(obj["mcs"])
                if obj.get("mcs") is not None
                else None,
                "nodes": obj.get("nodes"),
                "partition": obj.get("partition"),
                "hold": obj.get("hold"),
                "priority": V0041JobDescMsgPriority.from_dict(obj["priority"])
                if obj.get("priority") is not None
                else None,
                "qos": obj.get("qos"),
                "required": V0041OpenapiSlurmdbdJobsRespJobsInnerRequired.from_dict(
                    obj["required"]
                )
                if obj.get("required") is not None
                else None,
                "kill_request_user": obj.get("kill_request_user"),
                "reservation": V0041OpenapiSlurmdbdJobsRespJobsInnerReservation.from_dict(
                    obj["reservation"]
                )
                if obj.get("reservation") is not None
                else None,
                "script": obj.get("script"),
                "stdin_expanded": obj.get("stdin_expanded"),
                "stdout_expanded": obj.get("stdout_expanded"),
                "stderr_expanded": obj.get("stderr_expanded"),
                "stdout": obj.get("stdout"),
                "stderr": obj.get("stderr"),
                "stdin": obj.get("stdin"),
                "state": V0041OpenapiSlurmdbdJobsRespJobsInnerState.from_dict(
                    obj["state"]
                )
                if obj.get("state") is not None
                else None,
                "steps": [
                    V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInner.from_dict(_item)
                    for _item in obj["steps"]
                ]
                if obj.get("steps") is not None
                else None,
                "submit_line": obj.get("submit_line"),
                "tres": V0041OpenapiSlurmdbdJobsRespJobsInnerTres.from_dict(obj["tres"])
                if obj.get("tres") is not None
                else None,
                "used_gres": obj.get("used_gres"),
                "user": obj.get("user"),
                "wckey": V0041OpenapiSlurmdbdJobsRespJobsInnerWckey.from_dict(
                    obj["wckey"]
                )
                if obj.get("wckey") is not None
                else None,
                "working_directory": obj.get("working_directory"),
            }
        )
        return _obj
