# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_exit_code import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerExitCode,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_steps_inner_cpu import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerCPU,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_steps_inner_nodes import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerNodes,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_steps_inner_statistics import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerStatistics,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_steps_inner_step import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerStep,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_steps_inner_task import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTask,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_steps_inner_tasks import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTasks,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_steps_inner_time import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTime,
)
from slurpy.v0041.asyncio.models.v0041_openapi_slurmdbd_jobs_resp_jobs_inner_steps_inner_tres import (
    V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTres,
)
from typing import Set
from typing_extensions import Self


class V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInner(BaseModel):
    """
    V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInner
    """  # noqa: E501

    time: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTime] = None
    exit_code: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerExitCode] = None
    nodes: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerNodes] = None
    tasks: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTasks] = None
    pid: Optional[StrictStr] = Field(default=None, description="Process ID")
    cpu: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerCPU] = Field(
        default=None, alias="CPU"
    )
    kill_request_user: Optional[StrictStr] = Field(
        default=None, description="User ID that requested termination of the step"
    )
    state: Optional[List[StrictStr]] = Field(default=None, description="Current state")
    statistics: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerStatistics] = (
        None
    )
    step: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerStep] = None
    task: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTask] = None
    tres: Optional[V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTres] = None
    __properties: ClassVar[List[str]] = [
        "time",
        "exit_code",
        "nodes",
        "tasks",
        "pid",
        "CPU",
        "kill_request_user",
        "state",
        "statistics",
        "step",
        "task",
        "tres",
    ]

    @field_validator("state")
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(
                [
                    "PENDING",
                    "RUNNING",
                    "SUSPENDED",
                    "COMPLETED",
                    "CANCELLED",
                    "FAILED",
                    "TIMEOUT",
                    "NODE_FAIL",
                    "PREEMPTED",
                    "BOOT_FAIL",
                    "DEADLINE",
                    "OUT_OF_MEMORY",
                    "LAUNCH_FAILED",
                    "REQUEUED",
                    "REQUEUE_HOLD",
                    "SPECIAL_EXIT",
                    "RESIZING",
                    "CONFIGURING",
                    "COMPLETING",
                    "STOPPED",
                    "RECONFIG_FAIL",
                    "POWER_UP_NODE",
                    "REVOKED",
                    "REQUEUE_FED",
                    "RESV_DEL_HOLD",
                    "SIGNALING",
                    "STAGE_OUT",
                ]
            ):
                raise ValueError(
                    "each list item must be one of ('PENDING', 'RUNNING', 'SUSPENDED', 'COMPLETED', 'CANCELLED', 'FAILED', 'TIMEOUT', 'NODE_FAIL', 'PREEMPTED', 'BOOT_FAIL', 'DEADLINE', 'OUT_OF_MEMORY', 'LAUNCH_FAILED', 'REQUEUED', 'REQUEUE_HOLD', 'SPECIAL_EXIT', 'RESIZING', 'CONFIGURING', 'COMPLETING', 'STOPPED', 'RECONFIG_FAIL', 'POWER_UP_NODE', 'REVOKED', 'REQUEUE_FED', 'RESV_DEL_HOLD', 'SIGNALING', 'STAGE_OUT')"
                )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time
        if self.time:
            _dict["time"] = self.time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of exit_code
        if self.exit_code:
            _dict["exit_code"] = self.exit_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nodes
        if self.nodes:
            _dict["nodes"] = self.nodes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tasks
        if self.tasks:
            _dict["tasks"] = self.tasks.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cpu
        if self.cpu:
            _dict["CPU"] = self.cpu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict["statistics"] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of step
        if self.step:
            _dict["step"] = self.step.to_dict()
        # override the default output from pydantic by calling `to_dict()` of task
        if self.task:
            _dict["task"] = self.task.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tres
        if self.tres:
            _dict["tres"] = self.tres.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "time": V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTime.from_dict(
                    obj["time"]
                )
                if obj.get("time") is not None
                else None,
                "exit_code": V0041OpenapiSlurmdbdJobsRespJobsInnerExitCode.from_dict(
                    obj["exit_code"]
                )
                if obj.get("exit_code") is not None
                else None,
                "nodes": V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerNodes.from_dict(
                    obj["nodes"]
                )
                if obj.get("nodes") is not None
                else None,
                "tasks": V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTasks.from_dict(
                    obj["tasks"]
                )
                if obj.get("tasks") is not None
                else None,
                "pid": obj.get("pid"),
                "CPU": V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerCPU.from_dict(
                    obj["CPU"]
                )
                if obj.get("CPU") is not None
                else None,
                "kill_request_user": obj.get("kill_request_user"),
                "state": obj.get("state"),
                "statistics": V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerStatistics.from_dict(
                    obj["statistics"]
                )
                if obj.get("statistics") is not None
                else None,
                "step": V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerStep.from_dict(
                    obj["step"]
                )
                if obj.get("step") is not None
                else None,
                "task": V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTask.from_dict(
                    obj["task"]
                )
                if obj.get("task") is not None
                else None,
                "tres": V0041OpenapiSlurmdbdJobsRespJobsInnerStepsInnerTres.from_dict(
                    obj["tres"]
                )
                if obj.get("tres") is not None
                else None,
            }
        )
        return _obj
