# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0041.asyncio.models.v0041_openapi_tres_resp_tres_inner import (
    V0041OpenapiTresRespTRESInner,
)
from slurpy.v0041.asyncio.models.v0041_openapi_users_add_cond_resp_association_condition_association_grpjobs import (
    V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpjobs,
)
from slurpy.v0041.asyncio.models.v0041_openapi_users_add_cond_resp_association_condition_association_grpjobsaccrue import (
    V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpjobsaccrue,
)
from slurpy.v0041.asyncio.models.v0041_openapi_users_add_cond_resp_association_condition_association_grpsubmitjobs import (
    V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpsubmitjobs,
)
from slurpy.v0041.asyncio.models.v0041_openapi_users_add_cond_resp_association_condition_association_grpwall import (
    V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpwall,
)
from slurpy.v0041.asyncio.models.v0041_openapi_users_add_cond_resp_association_condition_association_maxjobs import (
    V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxjobs,
)
from slurpy.v0041.asyncio.models.v0041_openapi_users_add_cond_resp_association_condition_association_maxjobsaccrue import (
    V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxjobsaccrue,
)
from slurpy.v0041.asyncio.models.v0041_openapi_users_add_cond_resp_association_condition_association_maxsubmitjobs import (
    V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxsubmitjobs,
)
from slurpy.v0041.asyncio.models.v0041_openapi_users_add_cond_resp_association_condition_association_maxwalldurationperjob import (
    V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxwalldurationperjob,
)
from slurpy.v0041.asyncio.models.v0041_openapi_users_add_cond_resp_association_condition_association_minpriothresh import (
    V0041OpenapiUsersAddCondRespAssociationConditionAssociationMinpriothresh,
)
from slurpy.v0041.asyncio.models.v0041_openapi_users_add_cond_resp_association_condition_association_priority import (
    V0041OpenapiUsersAddCondRespAssociationConditionAssociationPriority,
)
from typing import Set
from typing_extensions import Self


class V0041OpenapiUsersAddCondRespAssociationConditionAssociation(BaseModel):
    """
    Association limits and options
    """  # noqa: E501

    comment: Optional[StrictStr] = Field(default=None, description="Arbitrary comment")
    defaultqos: Optional[StrictStr] = Field(default=None, description="Default QOS")
    grpjobs: Optional[
        V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpjobs
    ] = None
    grpjobsaccrue: Optional[
        V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpjobsaccrue
    ] = None
    grpsubmitjobs: Optional[
        V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpsubmitjobs
    ] = None
    grptres: Optional[List[V0041OpenapiTresRespTRESInner]] = Field(
        default=None,
        description="Maximum number of TRES able to be allocated by running jobs in this association and its children",
    )
    grptresmins: Optional[List[V0041OpenapiTresRespTRESInner]] = Field(
        default=None,
        description="Total number of TRES minutes that can possibly be used by past, present and future jobs in this association and its children",
    )
    grptresrunmins: Optional[List[V0041OpenapiTresRespTRESInner]] = Field(
        default=None,
        description="Maximum number of TRES minutes able to be allocated by running jobs in this association and its children",
    )
    grpwall: Optional[
        V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpwall
    ] = None
    maxjobs: Optional[
        V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxjobs
    ] = None
    maxjobsaccrue: Optional[
        V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxjobsaccrue
    ] = None
    maxsubmitjobs: Optional[
        V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxsubmitjobs
    ] = None
    maxtresminsperjob: Optional[List[V0041OpenapiTresRespTRESInner]] = Field(
        default=None,
        description="Maximum number of TRES minutes each job is able to use in this association",
    )
    maxtresrunmins: Optional[List[V0041OpenapiTresRespTRESInner]] = Field(
        default=None,
        description="Maximum number of TRES minutes able to be allocated by running jobs in this association",
    )
    maxtresperjob: Optional[List[V0041OpenapiTresRespTRESInner]] = Field(
        default=None,
        description="Maximum number of TRES each job is able to use in this association",
    )
    maxtrespernode: Optional[List[V0041OpenapiTresRespTRESInner]] = Field(
        default=None, description="Maximum number of TRES each node is able to use"
    )
    maxwalldurationperjob: Optional[
        V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxwalldurationperjob
    ] = None
    minpriothresh: Optional[
        V0041OpenapiUsersAddCondRespAssociationConditionAssociationMinpriothresh
    ] = None
    parent: Optional[StrictStr] = Field(
        default=None, description="Name of parent account"
    )
    priority: Optional[
        V0041OpenapiUsersAddCondRespAssociationConditionAssociationPriority
    ] = None
    qoslevel: Optional[List[StrictStr]] = Field(
        default=None, description="List of available QOS names"
    )
    fairshare: Optional[StrictInt] = Field(
        default=None, description="Allocated shares used for fairshare calculation"
    )
    __properties: ClassVar[List[str]] = [
        "comment",
        "defaultqos",
        "grpjobs",
        "grpjobsaccrue",
        "grpsubmitjobs",
        "grptres",
        "grptresmins",
        "grptresrunmins",
        "grpwall",
        "maxjobs",
        "maxjobsaccrue",
        "maxsubmitjobs",
        "maxtresminsperjob",
        "maxtresrunmins",
        "maxtresperjob",
        "maxtrespernode",
        "maxwalldurationperjob",
        "minpriothresh",
        "parent",
        "priority",
        "qoslevel",
        "fairshare",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V0041OpenapiUsersAddCondRespAssociationConditionAssociation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of grpjobs
        if self.grpjobs:
            _dict["grpjobs"] = self.grpjobs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of grpjobsaccrue
        if self.grpjobsaccrue:
            _dict["grpjobsaccrue"] = self.grpjobsaccrue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of grpsubmitjobs
        if self.grpsubmitjobs:
            _dict["grpsubmitjobs"] = self.grpsubmitjobs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in grptres (list)
        _items = []
        if self.grptres:
            for _item_grptres in self.grptres:
                if _item_grptres:
                    _items.append(_item_grptres.to_dict())
            _dict["grptres"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in grptresmins (list)
        _items = []
        if self.grptresmins:
            for _item_grptresmins in self.grptresmins:
                if _item_grptresmins:
                    _items.append(_item_grptresmins.to_dict())
            _dict["grptresmins"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in grptresrunmins (list)
        _items = []
        if self.grptresrunmins:
            for _item_grptresrunmins in self.grptresrunmins:
                if _item_grptresrunmins:
                    _items.append(_item_grptresrunmins.to_dict())
            _dict["grptresrunmins"] = _items
        # override the default output from pydantic by calling `to_dict()` of grpwall
        if self.grpwall:
            _dict["grpwall"] = self.grpwall.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maxjobs
        if self.maxjobs:
            _dict["maxjobs"] = self.maxjobs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maxjobsaccrue
        if self.maxjobsaccrue:
            _dict["maxjobsaccrue"] = self.maxjobsaccrue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maxsubmitjobs
        if self.maxsubmitjobs:
            _dict["maxsubmitjobs"] = self.maxsubmitjobs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in maxtresminsperjob (list)
        _items = []
        if self.maxtresminsperjob:
            for _item_maxtresminsperjob in self.maxtresminsperjob:
                if _item_maxtresminsperjob:
                    _items.append(_item_maxtresminsperjob.to_dict())
            _dict["maxtresminsperjob"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in maxtresrunmins (list)
        _items = []
        if self.maxtresrunmins:
            for _item_maxtresrunmins in self.maxtresrunmins:
                if _item_maxtresrunmins:
                    _items.append(_item_maxtresrunmins.to_dict())
            _dict["maxtresrunmins"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in maxtresperjob (list)
        _items = []
        if self.maxtresperjob:
            for _item_maxtresperjob in self.maxtresperjob:
                if _item_maxtresperjob:
                    _items.append(_item_maxtresperjob.to_dict())
            _dict["maxtresperjob"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in maxtrespernode (list)
        _items = []
        if self.maxtrespernode:
            for _item_maxtrespernode in self.maxtrespernode:
                if _item_maxtrespernode:
                    _items.append(_item_maxtrespernode.to_dict())
            _dict["maxtrespernode"] = _items
        # override the default output from pydantic by calling `to_dict()` of maxwalldurationperjob
        if self.maxwalldurationperjob:
            _dict["maxwalldurationperjob"] = self.maxwalldurationperjob.to_dict()
        # override the default output from pydantic by calling `to_dict()` of minpriothresh
        if self.minpriothresh:
            _dict["minpriothresh"] = self.minpriothresh.to_dict()
        # override the default output from pydantic by calling `to_dict()` of priority
        if self.priority:
            _dict["priority"] = self.priority.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V0041OpenapiUsersAddCondRespAssociationConditionAssociation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "comment": obj.get("comment"),
                "defaultqos": obj.get("defaultqos"),
                "grpjobs": V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpjobs.from_dict(
                    obj["grpjobs"]
                )
                if obj.get("grpjobs") is not None
                else None,
                "grpjobsaccrue": V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpjobsaccrue.from_dict(
                    obj["grpjobsaccrue"]
                )
                if obj.get("grpjobsaccrue") is not None
                else None,
                "grpsubmitjobs": V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpsubmitjobs.from_dict(
                    obj["grpsubmitjobs"]
                )
                if obj.get("grpsubmitjobs") is not None
                else None,
                "grptres": [
                    V0041OpenapiTresRespTRESInner.from_dict(_item)
                    for _item in obj["grptres"]
                ]
                if obj.get("grptres") is not None
                else None,
                "grptresmins": [
                    V0041OpenapiTresRespTRESInner.from_dict(_item)
                    for _item in obj["grptresmins"]
                ]
                if obj.get("grptresmins") is not None
                else None,
                "grptresrunmins": [
                    V0041OpenapiTresRespTRESInner.from_dict(_item)
                    for _item in obj["grptresrunmins"]
                ]
                if obj.get("grptresrunmins") is not None
                else None,
                "grpwall": V0041OpenapiUsersAddCondRespAssociationConditionAssociationGrpwall.from_dict(
                    obj["grpwall"]
                )
                if obj.get("grpwall") is not None
                else None,
                "maxjobs": V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxjobs.from_dict(
                    obj["maxjobs"]
                )
                if obj.get("maxjobs") is not None
                else None,
                "maxjobsaccrue": V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxjobsaccrue.from_dict(
                    obj["maxjobsaccrue"]
                )
                if obj.get("maxjobsaccrue") is not None
                else None,
                "maxsubmitjobs": V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxsubmitjobs.from_dict(
                    obj["maxsubmitjobs"]
                )
                if obj.get("maxsubmitjobs") is not None
                else None,
                "maxtresminsperjob": [
                    V0041OpenapiTresRespTRESInner.from_dict(_item)
                    for _item in obj["maxtresminsperjob"]
                ]
                if obj.get("maxtresminsperjob") is not None
                else None,
                "maxtresrunmins": [
                    V0041OpenapiTresRespTRESInner.from_dict(_item)
                    for _item in obj["maxtresrunmins"]
                ]
                if obj.get("maxtresrunmins") is not None
                else None,
                "maxtresperjob": [
                    V0041OpenapiTresRespTRESInner.from_dict(_item)
                    for _item in obj["maxtresperjob"]
                ]
                if obj.get("maxtresperjob") is not None
                else None,
                "maxtrespernode": [
                    V0041OpenapiTresRespTRESInner.from_dict(_item)
                    for _item in obj["maxtrespernode"]
                ]
                if obj.get("maxtrespernode") is not None
                else None,
                "maxwalldurationperjob": V0041OpenapiUsersAddCondRespAssociationConditionAssociationMaxwalldurationperjob.from_dict(
                    obj["maxwalldurationperjob"]
                )
                if obj.get("maxwalldurationperjob") is not None
                else None,
                "minpriothresh": V0041OpenapiUsersAddCondRespAssociationConditionAssociationMinpriothresh.from_dict(
                    obj["minpriothresh"]
                )
                if obj.get("minpriothresh") is not None
                else None,
                "parent": obj.get("parent"),
                "priority": V0041OpenapiUsersAddCondRespAssociationConditionAssociationPriority.from_dict(
                    obj["priority"]
                )
                if obj.get("priority") is not None
                else None,
                "qoslevel": obj.get("qoslevel"),
                "fairshare": obj.get("fairshare"),
            }
        )
        return _obj
