# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0041.models.v0041_openapi_accounts_resp_accounts_inner_associations_inner import (
    V0041OpenapiAccountsRespAccountsInnerAssociationsInner,
)
from slurpy.v0041.models.v0041_openapi_accounts_resp_accounts_inner_coordinators_inner import (
    V0041OpenapiAccountsRespAccountsInnerCoordinatorsInner,
)
from typing import Set
from typing_extensions import Self


class V0041OpenapiAccountsRespAccountsInner(BaseModel):
    """
    V0041OpenapiAccountsRespAccountsInner
    """  # noqa: E501

    associations: Optional[
        List[V0041OpenapiAccountsRespAccountsInnerAssociationsInner]
    ] = Field(
        default=None,
        description="Associations involving this account (only populated if requested)",
    )
    coordinators: Optional[
        List[V0041OpenapiAccountsRespAccountsInnerCoordinatorsInner]
    ] = Field(
        default=None,
        description="List of users that are a coordinator of this account (only populated if requested)",
    )
    description: StrictStr = Field(
        description="Arbitrary string describing the account"
    )
    name: StrictStr = Field(description="Account name")
    organization: StrictStr = Field(
        description="Organization to which the account belongs"
    )
    flags: Optional[List[StrictStr]] = Field(
        default=None, description="Flags associated with the account"
    )
    __properties: ClassVar[List[str]] = [
        "associations",
        "coordinators",
        "description",
        "name",
        "organization",
        "flags",
    ]

    @field_validator("flags")
    def flags_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(
                [
                    "DELETED",
                    "WithAssociations",
                    "WithCoordinators",
                    "NoUsersAreCoords",
                    "UsersAreCoords",
                ]
            ):
                raise ValueError(
                    "each list item must be one of ('DELETED', 'WithAssociations', 'WithCoordinators', 'NoUsersAreCoords', 'UsersAreCoords')"
                )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V0041OpenapiAccountsRespAccountsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in associations (list)
        _items = []
        if self.associations:
            for _item_associations in self.associations:
                if _item_associations:
                    _items.append(_item_associations.to_dict())
            _dict["associations"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in coordinators (list)
        _items = []
        if self.coordinators:
            for _item_coordinators in self.coordinators:
                if _item_coordinators:
                    _items.append(_item_coordinators.to_dict())
            _dict["coordinators"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V0041OpenapiAccountsRespAccountsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "associations": [
                    V0041OpenapiAccountsRespAccountsInnerAssociationsInner.from_dict(
                        _item
                    )
                    for _item in obj["associations"]
                ]
                if obj.get("associations") is not None
                else None,
                "coordinators": [
                    V0041OpenapiAccountsRespAccountsInnerCoordinatorsInner.from_dict(
                        _item
                    )
                    for _item in obj["coordinators"]
                ]
                if obj.get("coordinators") is not None
                else None,
                "description": obj.get("description"),
                "name": obj.get("name"),
                "organization": obj.get("organization"),
                "flags": obj.get("flags"),
            }
        )
        return _obj
