# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class V0041OpenapiDiagRespStatisticsBfExit(BaseModel):
    """
    Reasons for which the backfill scheduling cycle exited since last reset
    """  # noqa: E501

    end_job_queue: Optional[StrictInt] = Field(
        default=None, description="Reached end of queue"
    )
    bf_max_job_start: Optional[StrictInt] = Field(
        default=None, description="Reached number of jobs allowed to start"
    )
    bf_max_job_test: Optional[StrictInt] = Field(
        default=None, description="Reached number of jobs allowed to be tested"
    )
    bf_max_time: Optional[StrictInt] = Field(
        default=None, description="Reached maximum allowed scheduler time"
    )
    bf_node_space_size: Optional[StrictInt] = Field(
        default=None, description="Reached table size limit"
    )
    state_changed: Optional[StrictInt] = Field(
        default=None, description="System state changed"
    )
    __properties: ClassVar[List[str]] = [
        "end_job_queue",
        "bf_max_job_start",
        "bf_max_job_test",
        "bf_max_time",
        "bf_node_space_size",
        "state_changed",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V0041OpenapiDiagRespStatisticsBfExit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V0041OpenapiDiagRespStatisticsBfExit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "end_job_queue": obj.get("end_job_queue"),
                "bf_max_job_start": obj.get("bf_max_job_start"),
                "bf_max_job_test": obj.get("bf_max_job_test"),
                "bf_max_time": obj.get("bf_max_time"),
                "bf_node_space_size": obj.get("bf_node_space_size"),
                "state_changed": obj.get("state_changed"),
            }
        )
        return _obj
