# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0042.models.tres import Tres
from slurpy.v0042.models.v0042_accounting_allocated import V0042AccountingAllocated
from typing import Set
from typing_extensions import Self


class Accounting(BaseModel):
    """
    Accounting
    """  # noqa: E501

    allocated: Optional[V0042AccountingAllocated] = None
    id: Optional[StrictInt] = Field(
        default=None, description="Association ID or Workload characterization key ID"
    )
    id_alt: Optional[StrictInt] = Field(
        default=None, description="Alternate ID (not currently used)"
    )
    start: Optional[StrictInt] = Field(
        default=None, description="When the record was started (UNIX timestamp)"
    )
    tres: Optional[Tres] = Field(default=None, alias="TRES")
    __properties: ClassVar[List[str]] = ["allocated", "id", "id_alt", "start", "TRES"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Accounting from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of allocated
        if self.allocated:
            _dict["allocated"] = self.allocated.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tres
        if self.tres:
            _dict["TRES"] = self.tres.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Accounting from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "allocated": V0042AccountingAllocated.from_dict(obj["allocated"])
                if obj.get("allocated") is not None
                else None,
                "id": obj.get("id"),
                "id_alt": obj.get("id_alt"),
                "start": obj.get("start"),
                "TRES": Tres.from_dict(obj["TRES"])
                if obj.get("TRES") is not None
                else None,
            }
        )
        return _obj
