# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0042.models.job_res_socket import JobResSocket
from slurpy.v0042.models.v0042_job_res_node_cpus import V0042JobResNodeCpus
from slurpy.v0042.models.v0042_job_res_node_memory import V0042JobResNodeMemory
from typing import Set
from typing_extensions import Self


class JobResNode(BaseModel):
    """
    JobResNode
    """  # noqa: E501

    index: StrictInt = Field(description="Node index")
    name: StrictStr = Field(description="Node name")
    cpus: Optional[V0042JobResNodeCpus] = None
    memory: Optional[V0042JobResNodeMemory] = None
    sockets: List[JobResSocket]
    __properties: ClassVar[List[str]] = ["index", "name", "cpus", "memory", "sockets"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobResNode from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cpus
        if self.cpus:
            _dict["cpus"] = self.cpus.to_dict()
        # override the default output from pydantic by calling `to_dict()` of memory
        if self.memory:
            _dict["memory"] = self.memory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sockets (list)
        _items = []
        if self.sockets:
            for _item_sockets in self.sockets:
                if _item_sockets:
                    _items.append(_item_sockets.to_dict())
            _dict["sockets"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobResNode from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "index": obj.get("index"),
                "name": obj.get("name"),
                "cpus": V0042JobResNodeCpus.from_dict(obj["cpus"])
                if obj.get("cpus") is not None
                else None,
                "memory": V0042JobResNodeMemory.from_dict(obj["memory"])
                if obj.get("memory") is not None
                else None,
                "sockets": [JobResSocket.from_dict(_item) for _item in obj["sockets"]]
                if obj.get("sockets") is not None
                else None,
            }
        )
        return _obj
