# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class V0042JobState(BaseModel):
    """
    V0042JobState
    """  # noqa: E501

    current: Optional[List[StrictStr]] = None
    reason: Optional[StrictStr] = Field(
        default=None, description="Reason for previous Pending or Failed state"
    )
    __properties: ClassVar[List[str]] = ["current", "reason"]

    @field_validator("current")
    def current_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(
                [
                    "PENDING",
                    "RUNNING",
                    "SUSPENDED",
                    "COMPLETED",
                    "CANCELLED",
                    "FAILED",
                    "TIMEOUT",
                    "NODE_FAIL",
                    "PREEMPTED",
                    "BOOT_FAIL",
                    "DEADLINE",
                    "OUT_OF_MEMORY",
                    "LAUNCH_FAILED",
                    "REQUEUED",
                    "REQUEUE_HOLD",
                    "SPECIAL_EXIT",
                    "RESIZING",
                    "CONFIGURING",
                    "COMPLETING",
                    "STOPPED",
                    "RECONFIG_FAIL",
                    "POWER_UP_NODE",
                    "REVOKED",
                    "REQUEUE_FED",
                    "RESV_DEL_HOLD",
                    "SIGNALING",
                    "STAGE_OUT",
                ]
            ):
                raise ValueError(
                    "each list item must be one of ('PENDING', 'RUNNING', 'SUSPENDED', 'COMPLETED', 'CANCELLED', 'FAILED', 'TIMEOUT', 'NODE_FAIL', 'PREEMPTED', 'BOOT_FAIL', 'DEADLINE', 'OUT_OF_MEMORY', 'LAUNCH_FAILED', 'REQUEUED', 'REQUEUE_HOLD', 'SPECIAL_EXIT', 'RESIZING', 'CONFIGURING', 'COMPLETING', 'STOPPED', 'RECONFIG_FAIL', 'POWER_UP_NODE', 'REVOKED', 'REQUEUE_FED', 'RESV_DEL_HOLD', 'SIGNALING', 'STAGE_OUT')"
                )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V0042JobState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V0042JobState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {"current": obj.get("current"), "reason": obj.get("reason")}
        )
        return _obj
