# coding: utf-8

"""
Slurm REST API

API to access and control Slurm

The version of the OpenAPI document: Slurm-24.11.6&openapi/slurmdbd&openapi/slurmctld
Contact: sales@schedmd.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from slurpy.v0042.models.v0042_openapi_meta_slurm_version import (
    V0042OpenapiMetaSlurmVersion,
)
from typing import Set
from typing_extensions import Self


class V0042OpenapiMetaSlurm(BaseModel):
    """
    V0042OpenapiMetaSlurm
    """  # noqa: E501

    version: Optional[V0042OpenapiMetaSlurmVersion] = None
    release: Optional[StrictStr] = Field(
        default=None, description="Slurm release string"
    )
    cluster: Optional[StrictStr] = Field(default=None, description="Slurm cluster name")
    __properties: ClassVar[List[str]] = ["version", "release", "cluster"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V0042OpenapiMetaSlurm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict["version"] = self.version.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V0042OpenapiMetaSlurm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "version": V0042OpenapiMetaSlurmVersion.from_dict(obj["version"])
                if obj.get("version") is not None
                else None,
                "release": obj.get("release"),
                "cluster": obj.get("cluster"),
            }
        )
        return _obj
