# coding: utf-8

"""
    IaaS-API

    This API allows you to create and modify IaaS resources.

    The version of the OpenAPI document: 1
    Contact: stackit-iaas@mail.schwarz
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing_extensions import Self


class ImageConfig(BaseModel):
    """
    Properties to set hardware and scheduling settings for an Image.
    """  # noqa: E501

    architecture: Optional[StrictStr] = Field(
        default=None,
        description="Represents CPU architecture. The default for new images is x86. Possible values: `arm64`, `x86`.",
    )
    boot_menu: Optional[StrictBool] = Field(
        default=None, description="Enables the BIOS bootmenu. The default for new images is disabled.", alias="bootMenu"
    )
    cdrom_bus: Optional[StrictStr] = Field(
        default=None,
        description="Sets CDROM bus controller type. Possible values: `scsi`, `virtio`, `ide`, `usb`.",
        alias="cdromBus",
    )
    disk_bus: Optional[StrictStr] = Field(
        default=None,
        description="Sets Disk bus controller type. Possible values: `scsi`, `virtio`, `ide`, `usb`.",
        alias="diskBus",
    )
    nic_model: Optional[StrictStr] = Field(
        default=None,
        description="Sets virtual nic model. Possible values: `e1000`, `e1000e`, `ne2k_pci`, `pcnet`, `rtl8139`, `virtio`, `vmxnet3`.",
        alias="nicModel",
    )
    operating_system: Optional[StrictStr] = Field(
        default=None,
        description="Enables OS specific optimizations. Possible values: `windows`, `linux`.",
        alias="operatingSystem",
    )
    operating_system_distro: Optional[StrictStr] = Field(
        default=None, description="Operating System Distribution.", alias="operatingSystemDistro"
    )
    operating_system_version: Optional[StrictStr] = Field(
        default=None, description="Version of the OS.", alias="operatingSystemVersion"
    )
    rescue_bus: Optional[StrictStr] = Field(
        default=None,
        description="Sets the device bus when the image is used as a rescue image. Possible values: `sata`, `scsi`, `virtio`, `usb`.",
        alias="rescueBus",
    )
    rescue_device: Optional[StrictStr] = Field(
        default=None,
        description="Sets the device when the image is used as a rescue image. Possible values: `cdrom`, `disk`.",
        alias="rescueDevice",
    )
    secure_boot: Optional[StrictBool] = Field(
        default=None, description="Enables Secure Boot. The default for new images is disabled.", alias="secureBoot"
    )
    uefi: Optional[StrictBool] = Field(
        default=None, description="Configure UEFI boot. The default for new images is enabled."
    )
    video_model: Optional[StrictStr] = Field(
        default=None,
        description="Sets Graphic device model. Possible values: `vga`, `cirrus`, `vmvga`, `qxl`, `virtio`, `none`.",
        alias="videoModel",
    )
    virtio_scsi: Optional[StrictBool] = Field(
        default=None,
        description="Enables the use of VirtIO SCSI to provide block device access. By default servers use VirtIO Block.",
        alias="virtioScsi",
    )
    __properties: ClassVar[List[str]] = [
        "architecture",
        "bootMenu",
        "cdromBus",
        "diskBus",
        "nicModel",
        "operatingSystem",
        "operatingSystemDistro",
        "operatingSystemVersion",
        "rescueBus",
        "rescueDevice",
        "secureBoot",
        "uefi",
        "videoModel",
        "virtioScsi",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImageConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if cdrom_bus (nullable) is None
        # and model_fields_set contains the field
        if self.cdrom_bus is None and "cdrom_bus" in self.model_fields_set:
            _dict["cdromBus"] = None

        # set to None if disk_bus (nullable) is None
        # and model_fields_set contains the field
        if self.disk_bus is None and "disk_bus" in self.model_fields_set:
            _dict["diskBus"] = None

        # set to None if nic_model (nullable) is None
        # and model_fields_set contains the field
        if self.nic_model is None and "nic_model" in self.model_fields_set:
            _dict["nicModel"] = None

        # set to None if operating_system_distro (nullable) is None
        # and model_fields_set contains the field
        if self.operating_system_distro is None and "operating_system_distro" in self.model_fields_set:
            _dict["operatingSystemDistro"] = None

        # set to None if operating_system_version (nullable) is None
        # and model_fields_set contains the field
        if self.operating_system_version is None and "operating_system_version" in self.model_fields_set:
            _dict["operatingSystemVersion"] = None

        # set to None if rescue_bus (nullable) is None
        # and model_fields_set contains the field
        if self.rescue_bus is None and "rescue_bus" in self.model_fields_set:
            _dict["rescueBus"] = None

        # set to None if rescue_device (nullable) is None
        # and model_fields_set contains the field
        if self.rescue_device is None and "rescue_device" in self.model_fields_set:
            _dict["rescueDevice"] = None

        # set to None if video_model (nullable) is None
        # and model_fields_set contains the field
        if self.video_model is None and "video_model" in self.model_fields_set:
            _dict["videoModel"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImageConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "architecture": obj.get("architecture"),
                "bootMenu": obj.get("bootMenu"),
                "cdromBus": obj.get("cdromBus"),
                "diskBus": obj.get("diskBus"),
                "nicModel": obj.get("nicModel"),
                "operatingSystem": obj.get("operatingSystem"),
                "operatingSystemDistro": obj.get("operatingSystemDistro"),
                "operatingSystemVersion": obj.get("operatingSystemVersion"),
                "rescueBus": obj.get("rescueBus"),
                "rescueDevice": obj.get("rescueDevice"),
                "secureBoot": obj.get("secureBoot"),
                "uefi": obj.get("uefi"),
                "videoModel": obj.get("videoModel"),
                "virtioScsi": obj.get("virtioScsi"),
            }
        )
        return _obj
