# coding: utf-8

"""
    IaaS-API

    This API allows you to create and modify IaaS resources.

    The version of the OpenAPI document: 1
    Contact: stackit-iaas@mail.schwarz
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field
from typing_extensions import Self

from stackit.iaas.models.quota import Quota


class QuotaList(BaseModel):
    """
    Object that represents the quotas for a project.
    """  # noqa: E501

    backup_gigabytes: Quota = Field(description="Total size in GiB of backups.", alias="backupGigabytes")
    backups: Quota = Field(description="Number of backups.")
    gigabytes: Quota = Field(description="Total size in GiB of volumes and snapshots.")
    networks: Quota = Field(description="Number of networks.")
    nics: Quota = Field(description="Number of network interfaces.")
    public_ips: Quota = Field(description="Number of public IP addresses.", alias="publicIps")
    ram: Quota = Field(description="Amount of server RAM in MiB.")
    security_group_rules: Quota = Field(description="Number of security group rules.", alias="securityGroupRules")
    security_groups: Quota = Field(description="Number of security groups.", alias="securityGroups")
    snapshots: Quota = Field(description="Number of snapshots.")
    vcpu: Quota = Field(description="Number of server cores.")
    volumes: Quota = Field(description="Number of volumes.")
    __properties: ClassVar[List[str]] = [
        "backupGigabytes",
        "backups",
        "gigabytes",
        "networks",
        "nics",
        "publicIps",
        "ram",
        "securityGroupRules",
        "securityGroups",
        "snapshots",
        "vcpu",
        "volumes",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QuotaList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of backup_gigabytes
        if self.backup_gigabytes:
            _dict["backupGigabytes"] = self.backup_gigabytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of backups
        if self.backups:
            _dict["backups"] = self.backups.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gigabytes
        if self.gigabytes:
            _dict["gigabytes"] = self.gigabytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of networks
        if self.networks:
            _dict["networks"] = self.networks.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nics
        if self.nics:
            _dict["nics"] = self.nics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of public_ips
        if self.public_ips:
            _dict["publicIps"] = self.public_ips.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ram
        if self.ram:
            _dict["ram"] = self.ram.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security_group_rules
        if self.security_group_rules:
            _dict["securityGroupRules"] = self.security_group_rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security_groups
        if self.security_groups:
            _dict["securityGroups"] = self.security_groups.to_dict()
        # override the default output from pydantic by calling `to_dict()` of snapshots
        if self.snapshots:
            _dict["snapshots"] = self.snapshots.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vcpu
        if self.vcpu:
            _dict["vcpu"] = self.vcpu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of volumes
        if self.volumes:
            _dict["volumes"] = self.volumes.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QuotaList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "backupGigabytes": (
                    Quota.from_dict(obj["backupGigabytes"]) if obj.get("backupGigabytes") is not None else None
                ),
                "backups": Quota.from_dict(obj["backups"]) if obj.get("backups") is not None else None,
                "gigabytes": Quota.from_dict(obj["gigabytes"]) if obj.get("gigabytes") is not None else None,
                "networks": Quota.from_dict(obj["networks"]) if obj.get("networks") is not None else None,
                "nics": Quota.from_dict(obj["nics"]) if obj.get("nics") is not None else None,
                "publicIps": Quota.from_dict(obj["publicIps"]) if obj.get("publicIps") is not None else None,
                "ram": Quota.from_dict(obj["ram"]) if obj.get("ram") is not None else None,
                "securityGroupRules": (
                    Quota.from_dict(obj["securityGroupRules"]) if obj.get("securityGroupRules") is not None else None
                ),
                "securityGroups": (
                    Quota.from_dict(obj["securityGroups"]) if obj.get("securityGroups") is not None else None
                ),
                "snapshots": Quota.from_dict(obj["snapshots"]) if obj.get("snapshots") is not None else None,
                "vcpu": Quota.from_dict(obj["vcpu"]) if obj.get("vcpu") is not None else None,
                "volumes": Quota.from_dict(obj["volumes"]) if obj.get("volumes") is not None else None,
            }
        )
        return _obj
