# coding: utf-8

"""
    IaaS-API

    This API allows you to create and modify IaaS resources.

    The version of the OpenAPI document: 1
    Contact: stackit-iaas@mail.schwarz
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set, Union

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBytes,
    StrictInt,
    StrictStr,
    field_validator,
)
from typing_extensions import Annotated, Self


class VolumeEncryptionParameter(BaseModel):
    """
    Parameter to connect to a key-encryption-key within the STACKIT-KMS to create encrypted volumes. If no key_payload is set, a random passphrase is generated, which will be encrypted against the STACKIT-KMS. These parameter never leave the backend again. So these parameters are not in the responses.
    """  # noqa: E501

    kek_key_id: Annotated[str, Field(min_length=36, strict=True, max_length=36)] = Field(
        description="UUID of the Key within the STACKIT-KMS to use for the encryption.", alias="kekKeyId"
    )
    kek_key_version: StrictInt = Field(
        description="Version of the key within the STACKIT-KMS to use for the encryption.", alias="kekKeyVersion"
    )
    kek_keyring_id: Annotated[str, Field(min_length=36, strict=True, max_length=36)] = Field(
        description="UUID of the keyring where the key is located within the STACKTI-KMS.", alias="kekKeyringId"
    )
    kek_project_id: Optional[Annotated[str, Field(min_length=36, strict=True, max_length=36)]] = Field(
        default=None,
        description="Id of the project, where the key in the STACKIT-KMS belongs to, in case the key is located in a different project. By default the same project ID is used, like for the volume itself. Defining a key in a different project is only allowed for privileged internal projects.",
        alias="kekProjectId",
    )
    key_payload: Optional[Union[StrictBytes, StrictStr]] = Field(
        default=None,
        description="Optional predefined secret, which will be encrypted against the key-encryption-key within the STACKIT-KMS. If not defined, a random secret will be generated by the API and encrypted against the STACKIT-KMS. If a key-payload is provided here, it must be base64 encoded.",
        alias="keyPayload",
    )
    service_account: Annotated[str, Field(strict=True, max_length=255)] = Field(
        description="Service-Account linked to the Key within the STACKIT-KMS.", alias="serviceAccount"
    )
    __properties: ClassVar[List[str]] = [
        "kekKeyId",
        "kekKeyVersion",
        "kekKeyringId",
        "kekProjectId",
        "keyPayload",
        "serviceAccount",
    ]

    @field_validator("kek_key_id")
    def kek_key_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", value):
            raise ValueError(
                r"must validate the regular expression /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/"
            )
        return value

    @field_validator("kek_keyring_id")
    def kek_keyring_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", value):
            raise ValueError(
                r"must validate the regular expression /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/"
            )
        return value

    @field_validator("kek_project_id")
    def kek_project_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", value):
            raise ValueError(
                r"must validate the regular expression /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/"
            )
        return value

    @field_validator("service_account")
    def service_account_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(
            r"[a-z0-9-]+(?:\.[a-z0-9]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?", value
        ):
            raise ValueError(
                r"must validate the regular expression /[a-z0-9-]+(?:\.[a-z0-9]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VolumeEncryptionParameter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VolumeEncryptionParameter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "kekKeyId": obj.get("kekKeyId"),
                "kekKeyVersion": obj.get("kekKeyVersion"),
                "kekKeyringId": obj.get("kekKeyringId"),
                "kekProjectId": obj.get("kekProjectId"),
                "keyPayload": obj.get("keyPayload"),
                "serviceAccount": obj.get("serviceAccount"),
            }
        )
        return _obj
