"""Activity model."""

from datetime import datetime
from typing import Annotated

from pydantic import Field

from entitysdk.models.core import Identifiable
from entitysdk.models.entity import Entity
from entitysdk.types import ActivityType


class Activity(Identifiable):
    """Activity model."""

    type: Annotated[
        ActivityType | None,
        Field(description="The type of the activity."),
    ] = None

    start_time: Annotated[
        datetime,
        Field(description="The time at which the activity started."),
    ]
    end_time: Annotated[
        datetime | None,
        Field(description="The time at which the activity ended."),
    ] = None

    used: Annotated[
        list[Entity] | None,
        Field(description="Entities that were used by this activity."),
    ] = None
    generated: Annotated[
        list[Entity] | None,
        Field(description="Entities that were generated by this activity."),
    ] = None
