"""Fix issues in default cogwheel_pe/meta.yaml generated by grayskull.

* import name `cogwheel_pe` should be `cogwheel`.
* Add `cogwheel.sampling` to import tests.
* The home item is missing in the about section.
* The license identifier GPL-3.0 is deprecated.
"""
from pathlib import Path

cogwheel_dir = Path(__file__).parents[1]
recipe_filename = cogwheel_dir/'cogwheel-pe'/'meta.yaml'
with open(recipe_filename) as file:
    text = file.read()


# Rename default import name `cogwheel_pe` to `cogwheel`
target = """
test:
  imports:
    - cogwheel_pe
"""
new = """
test:
  imports:
    - cogwheel
    - cogwheel.sampling
"""
text = text.replace(target, new)


# Add `about: home:` entry.
target = """
about:"""
new = """
  home: https://github.com/jroulet/cogwheel"""
text = text.replace(target, target + new)


# Rename license identifier
target = """
  license: GPL-3.0
"""
new = """
  license: GPL-3.0-or-later
"""
text = text.replace(target, new)


# Overwrite meta.yaml
with open(recipe_filename, 'w') as file:
    file.write(text)
