# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...engine.types.object import Object
from ...ocsf.resources.v_1_5_0.resources.applicationsecurityposturefinding.resources.objects.types.application import (
    Application,
)
from .app_sec_application_uid_type import AppSecApplicationUidType

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AppSecApplication(Application):
    """
    An application describes the details for an inventoried application as reported by an Application Security tool or other Developer-centric tooling. Applications can be defined as Github repositories or other code-centric resources.
    """

    uid_type: typing.Optional[AppSecApplicationUidType] = pydantic.Field(default=None)
    """
    An attribute that describes the type of the application's unique identifier as defined by the provider. This may be used to help find the application in the provider's user interface. Note that the uid attribute is used as the primary identifier for the application for the purposes of the Synqly API.
    """

    uid_alt_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    An attribute that describes the type of the application's alternate unique identifier as defined by the provider. This may be used to help find the application in the provider's user interface.
    """

    unmapped: typing.Optional[Object] = pydantic.Field(default=None)
    """
    The attributes that are not mapped to the application schema. The names and values of those attributes are specific to the provider.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
