# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...engine.types.object import Object
from .integration_web_hook_id import IntegrationWebHookId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class IntegrationWebHook(pydantic.BaseModel):
    """
    Integration webhook
    """

    id: IntegrationWebHookId
    creator: str = pydantic.Field()
    """
    The user who created the webHook.
    """

    enabled: bool = pydantic.Field()
    """
    Status of the WebHook.
    """

    events: typing.List[str] = pydantic.Field()
    """
    List of events that trigger the WebHook.
    """

    name: str = pydantic.Field()
    """
    A name for the WebHook.
    """

    value: str = pydantic.Field()
    """
    The content of the webHook, this can be a URL or a specific code, it depends on the provider.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The date the WebHook was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date the WebHook was last updated.
    """

    unmapped: typing.Optional[Object] = pydantic.Field(default=None)
    """
    The attributes that are not mapped to the WebHook schema. The names and values of those attributes are specific to the provider.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
