# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.process_name import ProcessName
from ...base.types.timestamp import Timestamp

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ProcessEntity(pydantic.BaseModel):
    """
    The Process Entity object provides critical fields for referencing a process.
    """

    cmd_line: typing.Optional[str] = pydantic.Field(default=None)
    """
    The full command line used to launch an application, service, process, or job. For example: <code>ssh user@10.0.0.10</code>. If the command line is unavailable or missing, the empty string <code>''</code> is to be used.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the process was created/started.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the process was created/started.
    """

    name: typing.Optional[ProcessName] = pydantic.Field(default=None)
    """
    The friendly name of the process, for example: <code>Notepad++</code>.
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The process file path.
    """

    pid: typing.Optional[int] = pydantic.Field(default=None)
    """
    The process identifier, as reported by the operating system. Process ID (PID) is a number used by the operating system to uniquely identify an active process.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for this process assigned by the producer (tool). Facilitates correlation of a process event with other events for that process.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
