# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .mitigation import Mitigation
from .sub_technique import SubTechnique
from .tactic import Tactic
from .technique import Technique

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Attack(pydantic.BaseModel):
    """
    The MITRE ATT&CK® & ATLAS™ object describes the tactic, technique, sub-technique & mitigation associated to an attack.
    """

    mitigation: typing.Optional[Mitigation] = pydantic.Field(default=None)
    """
    The Mitigation object describes the MITRE ATT&CK® or ATLAS™ Mitigation ID and/or name that is associated to an attack.
    """

    sub_technique: typing.Optional[SubTechnique] = pydantic.Field(default=None)
    """
    The Sub-technique object describes the MITRE ATT&CK® or ATLAS™ Sub-technique ID and/or name associated to an attack.
    """

    tactic: typing.Optional[Tactic] = pydantic.Field(default=None)
    """
    The Tactic object describes the MITRE ATT&CK® or ATLAS™ Tactic ID and/or name that is associated to an attack.
    """

    tactics: typing.Optional[typing.List[Tactic]] = pydantic.Field(default=None)
    """
    The Tactic object describes the tactic ID and/or tactic name that are associated with the attack technique, as defined by <a target='_blank' href='https://attack.mitre.org/wiki/ATT&CK_Matrix'>ATT&CK® Matrix</a>.
    """

    technique: typing.Optional[Technique] = pydantic.Field(default=None)
    """
    The Technique object describes the MITRE ATT&CK® or ATLAS™ Technique ID and/or name associated to an attack.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ATT&CK® or ATLAS™ Matrix version.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
