# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .d_3_f_tactic import D3FTactic
from .d_3_f_technique import D3FTechnique

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class D3Fend(pydantic.BaseModel):
    """
    The MITRE D3FEND™ object describes the tactic & technique associated with a countermeasure.
    """

    d_3_f_tactic: typing.Optional[D3FTactic] = pydantic.Field(alias="d3f_tactic", default=None)
    """
    The Tactic object describes the tactic ID and/or name that is associated with a countermeasure.
    """

    d_3_f_technique: typing.Optional[D3FTechnique] = pydantic.Field(alias="d3f_technique", default=None)
    """
    The Technique object describes the technique ID and/or name associated with a countermeasure.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The D3FEND™ Matrix version.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
