# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .edge import Edge
from .graph_query_language_id import GraphQueryLanguageId
from .node import Node

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Graph(pydantic.BaseModel):
    """
    A graph data structure representation with nodes and edges.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The graph description - provides additional details about the graph's purpose and contents.
    """

    edges: typing.Optional[typing.List[Edge]] = pydantic.Field(default=None)
    """
    The edges/connections between nodes in the graph - contains the collection of <code>edge</code> objects defining relationships between nodes.
    """

    is_directed: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the graph is directed (<code>true</code>) or undirected (<code>false</code>).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The graph name - a human readable identifier for the graph.
    """

    nodes: typing.List[Node] = pydantic.Field()
    """
    The nodes/vertices of the graph - contains the collection of <code>node</code> objects that make up the graph.
    """

    query_language: typing.Optional[str] = pydantic.Field(default=None)
    """
    The graph query language, normalized to the caption of the <code>query_language_id</code> value.
    """

    query_language_id: typing.Optional[GraphQueryLanguageId] = pydantic.Field(default=None)
    """
    The normalized identifier of a graph query language that can be used to interact with the graph.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The graph type. Typically useful to represent the specifc type of graph that is used.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier of the graph - a unique ID to reference this specific graph.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
