# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Node(pydantic.BaseModel):
    """
    Represents a node or a vertex in a graph structure.
    """

    data: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    Additional data about the node stored as key-value pairs. Can include custom properties specific to the node.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human-readable description of the node's purpose or meaning in the graph.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human-readable name or label for the node. Should be descriptive and unique within the graph context.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Categorizes the node into a specific class or type. Useful for grouping and filtering nodes.
    """

    uid: str = pydantic.Field()
    """
    A unique string or numeric identifier that distinguishes this node from all others in the graph. Must be unique across all nodes.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
