# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.subnet import Subnet
from ...base.types.timestamp import Timestamp
from ...base.types.url_string import UrlString
from .analytic import Analytic
from .attack import Attack
from .autonomous_system import AutonomousSystem
from .campaign import Campaign
from .digital_signature import DigitalSignature
from .dns_answer import DnsAnswer
from .email import Email
from .email_auth import EmailAuth
from .file import File
from .kill_chain_phase import KillChainPhase
from .location import Location
from .malware import Malware
from .osint_confidence_id import OsintConfidenceId
from .osint_detection_pattern_type_id import OsintDetectionPatternTypeId
from .osint_severity_id import OsintSeverityId
from .osint_tlp import OsintTlp
from .osint_type_id import OsintTypeId
from .reputation import Reputation
from .script import Script
from .threat_actor import ThreatActor
from .user import User
from .vulnerability import Vulnerability
from .whois import Whois

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Osint(pydantic.BaseModel):
    """
    The OSINT (Open Source Intelligence) object contains details related to an indicator such as the indicator itself, related indicators, geolocation, registrar information, subdomains, analyst commentary, and other contextual information. This information can be used to further enrich a detection or finding by providing decisioning support to other analysts and engineers.
    """

    answers: typing.Optional[typing.List[DnsAnswer]] = pydantic.Field(default=None)
    """
    Any pertinent DNS answers information related to an indicator or OSINT analysis.
    """

    attacks: typing.Optional[typing.List[Attack]] = pydantic.Field(default=None)
    """
    MITRE ATT&CK Tactics, Techniques, and/or Procedures (TTPs) pertinent to an indicator or OSINT analysis.
    """

    autonomous_system: typing.Optional[AutonomousSystem] = pydantic.Field(default=None)
    """
    Any pertinent autonomous system information related to an indicator or OSINT analysis.
    """

    campaign: typing.Optional[Campaign] = pydantic.Field(default=None)
    """
    The campaign object describes details about the campaign that was the source of the activity.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    Categorizes the threat indicator based on its functional or operational role.
    """

    comment: typing.Optional[str] = pydantic.Field(default=None)
    """
    Analyst commentary or source commentary about an indicator or OSINT analysis.
    """

    confidence: typing.Optional[str] = pydantic.Field(default=None)
    """
    The confidence of an indicator being malicious and/or pertinent, normalized to the caption of the confidence_id value. In the case of 'Other', it is defined by the event source or analyst.
    """

    confidence_id: typing.Optional[OsintConfidenceId] = pydantic.Field(default=None)
    """
    The normalized confidence refers to the accuracy of collected information related to the OSINT or how pertinent an indicator or analysis is to a specific event or finding. A low confidence means that the information collected or analysis conducted lacked detail or is not accurate enough to qualify an indicator as fully malicious.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp when the indicator was initially created or identified.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the indicator was initially created or identified.
    """

    creator: typing.Optional[User] = pydantic.Field(default=None)
    """
    The identifier of the user, system, or organization that contributed the indicator.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    A detailed explanation of the indicator, including its context, purpose, and relevance.
    """

    detection_pattern: typing.Optional[str] = pydantic.Field(default=None)
    """
    The specific detection pattern or signature associated with the indicator.
    """

    detection_pattern_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The detection pattern type, normalized to the caption of the detection_pattern_type_id value. In the case of 'Other', it is defined by the event source.
    """

    detection_pattern_type_id: typing.Optional[OsintDetectionPatternTypeId] = pydantic.Field(default=None)
    """
    Specifies the type of detection pattern used to identify the associated threat indicator.
    """

    email: typing.Optional[Email] = pydantic.Field(default=None)
    """
    Any email information pertinent to an indicator or OSINT analysis.
    """

    email_auth: typing.Optional[EmailAuth] = pydantic.Field(default=None)
    """
    Any email authentication information pertinent to an indicator or OSINT analysis.
    """

    expiration_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The expiration date of the indicator, after which it is no longer considered reliable.
    """

    expiration_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The expiration date of the indicator, after which it is no longer considered reliable.
    """

    external_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier assigned by an external system for cross-referencing.
    """

    file: typing.Optional[File] = pydantic.Field(default=None)
    """
    Any pertinent file information related to an indicator or OSINT analysis.
    """

    intrusion_sets: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A grouping of adversarial behaviors and resources believed to be associated with specific threat actors or campaigns. Intrusion sets often encompass multiple campaigns and are used to organize related activities under a common label.
    """

    kill_chain: typing.Optional[typing.List[KillChainPhase]] = pydantic.Field(default=None)
    """
    Lockheed Martin Kill Chain Phases pertinent to an indicator or OSINT analysis.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Tags or keywords associated with the indicator to enhance searchability.
    """

    location: typing.Optional[Location] = pydantic.Field(default=None)
    """
    Any pertinent geolocation information related to an indicator or OSINT analysis.
    """

    malware: typing.Optional[typing.List[Malware]] = pydantic.Field(default=None)
    """
    A list of Malware objects, describing details about the identified malware.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp of the last modification or update to the indicator.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp of the last modification or update to the indicator.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The <code>name</code> is a pointer/reference to an attribute within the OCSF event data. For example: file.name.
    """

    references: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Provides a reference to an external source of information related to the CTI being represented. This may include a URL, a document, or some other type of reference that provides additional context or information about the CTI.
    """

    related_analytics: typing.Optional[typing.List[Analytic]] = pydantic.Field(default=None)
    """
    Any analytics related to an indicator or OSINT analysis.
    """

    reputation: typing.Optional[Reputation] = pydantic.Field(default=None)
    """
    Related reputational analysis from third-party engines and analysts for a given indicator or OSINT analysis.
    """

    risk_score: typing.Optional[int] = pydantic.Field(default=None)
    """
    A numerical representation of the threat indicator’s risk level.
    """

    script: typing.Optional[Script] = pydantic.Field(default=None)
    """
    Any pertinent script information related to an indicator or OSINT analysis.
    """

    severity: typing.Optional[str] = pydantic.Field(default=None)
    """
    Represents the severity level of the threat indicator, typically reflecting its potential impact or damage.
    """

    severity_id: typing.Optional[OsintSeverityId] = pydantic.Field(default=None)
    """
    The normalized severity level of the threat indicator, typically reflecting its potential impact or damage.
    """

    signatures: typing.Optional[typing.List[DigitalSignature]] = pydantic.Field(default=None)
    """
    Any digital signatures or hashes related to an indicator or OSINT analysis.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The source URL of an indicator or OSINT analysis, e.g., a URL back to a TIP, report, or otherwise.
    """

    subdomains: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Any pertinent subdomain information - such as those generated by a Domain Generation Algorithm - related to an indicator or OSINT analysis.
    """

    subnet: typing.Optional[Subnet] = pydantic.Field(default=None)
    """
    A CIDR or network block related to an indicator or OSINT analysis.
    """

    threat_actor: typing.Optional[ThreatActor] = pydantic.Field(default=None)
    """
    A threat actor is an individual or group that conducts malicious cyber activities, often with financial, political, or ideological motives.
    """

    tlp: typing.Optional[OsintTlp] = pydantic.Field(default=None)
    """
    The <a target='_blank' href='https://www.first.org/tlp/'>Traffic Light Protocol</a> was created to facilitate greater sharing of potentially sensitive information and more effective collaboration. TLP provides a simple and intuitive schema for indicating with whom potentially sensitive information can be shared.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The OSINT indicator type.
    """

    type_id: OsintTypeId = pydantic.Field()
    """
    The OSINT indicator type ID.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the OSINT object.
    """

    uploaded_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp indicating when the associated indicator or intelligence was added to the system or repository.
    """

    uploaded_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp indicating when the associated indicator or intelligence was added to the system or repository.
    """

    value: str = pydantic.Field()
    """
    The actual indicator value in scope, e.g., a SHA-256 hash hexdigest or a domain name.
    """

    vendor_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The vendor name of a tool which generates intelligence or provides indicators.
    """

    vulnerabilities: typing.Optional[typing.List[Vulnerability]] = pydantic.Field(default=None)
    """
    Any vulnerabilities related to an indicator or OSINT analysis.
    """

    whois: typing.Optional[Whois] = pydantic.Field(default=None)
    """
    Any pertinent WHOIS information related to an indicator or OSINT analysis.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
