# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .group import Group

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Policy(pydantic.BaseModel):
    """
    The Policy object describes the policies that are applicable. <p>Policy attributes provide traceability to the operational state of the security product at the time that the event was captured, facilitating forensics, troubleshooting, and policy tuning/adjustments.</p>
    """

    data: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    Additional data about the policy such as the underlying JSON policy itself or other details.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the policy.
    """

    group: typing.Optional[Group] = pydantic.Field(default=None)
    """
    The policy group.
    """

    is_applied: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A determination if the content of a policy was applied to a target or request, or not.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The policy name. For example: <code>IAM Policy</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier of the policy instance.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The policy version number.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
