# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.hostname import Hostname
from ...base.types.ip_address import IpAddress
from ...base.types.resource_uid import ResourceUid
from ...base.types.timestamp import Timestamp
from .agent import Agent
from .graph import Graph
from .group import Group
from .key_value_object import KeyValueObject
from .user import User

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ResourceDetails(pydantic.BaseModel):
    """
    The Resource Details object describes details about resources that were affected by the activity/event.
    """

    agent_list: typing.Optional[typing.List[Agent]] = pydantic.Field(default=None)
    """
    A list of <code>agent</code> objects associated with a device, endpoint, or resource.
    """

    cloud_partition: typing.Optional[str] = pydantic.Field(default=None)
    """
    The canonical cloud partition name to which the region is assigned (e.g. AWS Partitions: aws, aws-cn, aws-us-gov).
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the resource was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the resource was created.
    """

    criticality: typing.Optional[str] = pydantic.Field(default=None)
    """
    The criticality of the resource as defined by the event source.
    """

    data: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    Additional data describing the resource.
    """

    group: typing.Optional[Group] = pydantic.Field(default=None)
    """
    The name of the related resource group.
    """

    hostname: typing.Optional[Hostname] = pydantic.Field(default=None)
    """
    The fully qualified name of the resource.
    """

    ip: typing.Optional[IpAddress] = pydantic.Field(default=None)
    """
    The IP address of the resource, in either IPv4 or IPv6 format.
    """

    is_backed_up: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether the device or resource has a backup enabled, such as an automated snapshot or a cloud backup. For example, this is indicated by the <code>cloudBackupEnabled</code> value within JAMF Pro mobile devices or the registration of an AWS ARN with the AWS Backup service.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels associated to the resource.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the resource was last modified.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the resource was last modified.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the resource.
    """

    namespace: typing.Optional[str] = pydantic.Field(default=None)
    """
    The namespace is useful when similar entities exist that you need to keep separate.
    """

    owner: typing.Optional[User] = pydantic.Field(default=None)
    """
    The identity of the service or user account that owns the resource.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The cloud region of the resource.
    """

    resource_relationship: typing.Optional[Graph] = pydantic.Field(default=None)
    """
    A graph representation showing how this resource relates to and interacts with other entities in the environment. This can include parent/child relationships, dependencies, or other connections.
    """

    tags: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(default=None)
    """
    The list of tags; <code>{key:value}</code> pairs associated to the resource.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The resource type as defined by the event source.
    """

    uid: typing.Optional[ResourceUid] = pydantic.Field(default=None)
    """
    The unique identifier of the resource.
    """

    uid_alt: typing.Optional[ResourceUid] = pydantic.Field(default=None)
    """
    The alternative unique identifier of the resource.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the resource. For example <code>1.2.3</code>.
    """

    zone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The specific availability zone within a cloud region where the resource is located.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
