# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.timestamp import Timestamp
from ...base.types.url_string import UrlString
from .product import Product

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class TransformationInfo(pydantic.BaseModel):
    """
    The transformation_info object represents the mapping or transformation used.
    """

    lang: typing.Optional[str] = pydantic.Field(default=None)
    """
    The transformation language used to transform the data.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the transformation or mapping.
    """

    product: typing.Optional[Product] = pydantic.Field(default=None)
    """
    The product or instance used to make the transformation
    """

    time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    Time of the transformation.
    """

    time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Time of the transformation.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the mapping or transformation.
    """

    url_string: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The Uniform Resource Locator String where the mapping or transformation exists.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
