# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...ocsf.resources.v_1_3_0.resources.securityfinding.resources.classes.types.severity_id import SeverityId
from .provider_specific_finding_state import ProviderSpecificFindingState
from .vulnerability_severity_filter_value import VulnerabilitySeverityFilterValue
from .vulnerability_state_filter_value import VulnerabilityStateFilterValue

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class UpdateFindingRequest(pydantic.BaseModel):
    severity_id: SeverityId
    severity: typing.Optional[VulnerabilitySeverityFilterValue] = pydantic.Field(default=None)
    """
    severity of the finding
    """

    state: typing.Optional[VulnerabilityStateFilterValue] = pydantic.Field(default=None)
    """
    state of the finding
    """

    unmapped: typing.Optional[ProviderSpecificFindingState] = None

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
